/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.IntArray;
import java.util.ArrayList;

@SystemApi
public class IncidentReportArgs
implements Parcelable {
    private final IntArray mSections = new IntArray();
    private final ArrayList<byte[]> mHeaders = new ArrayList();
    private boolean mAll;
    private int mPrivacyPolicy;
    private String mReceiverPkg;
    private String mReceiverCls;
    @NonNull
    public static final Parcelable.Creator<IncidentReportArgs> CREATOR = new Parcelable.Creator<IncidentReportArgs>(){

        @Override
        public IncidentReportArgs createFromParcel(Parcel in) {
            return new IncidentReportArgs(in);
        }

        public IncidentReportArgs[] newArray(int size) {
            return new IncidentReportArgs[size];
        }
    };

    public IncidentReportArgs() {
        this.mPrivacyPolicy = 200;
    }

    public IncidentReportArgs(Parcel in) {
        this.readFromParcel(in);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        int i;
        out.writeInt(this.mAll ? 1 : 0);
        int N2 = this.mSections.size();
        out.writeInt(N2);
        for (i = 0; i < N2; ++i) {
            out.writeInt(this.mSections.get(i));
        }
        N2 = this.mHeaders.size();
        out.writeInt(N2);
        for (i = 0; i < N2; ++i) {
            out.writeByteArray(this.mHeaders.get(i));
        }
        out.writeInt(this.mPrivacyPolicy);
        out.writeString(this.mReceiverPkg);
        out.writeString(this.mReceiverCls);
    }

    public void readFromParcel(Parcel in) {
        int i;
        this.mAll = in.readInt() != 0;
        this.mSections.clear();
        int N2 = in.readInt();
        for (i = 0; i < N2; ++i) {
            this.mSections.add(in.readInt());
        }
        this.mHeaders.clear();
        N2 = in.readInt();
        for (i = 0; i < N2; ++i) {
            this.mHeaders.add(in.createByteArray());
        }
        this.mPrivacyPolicy = in.readInt();
        this.mReceiverPkg = in.readString();
        this.mReceiverCls = in.readString();
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder("Incident(");
        if (this.mAll) {
            sb.append("all");
        } else {
            int N2 = this.mSections.size();
            if (N2 > 0) {
                sb.append(this.mSections.get(0));
            }
            for (int i = 1; i < N2; ++i) {
                sb.append(" ");
                sb.append(this.mSections.get(i));
            }
        }
        sb.append(", ");
        sb.append(this.mHeaders.size());
        sb.append(" headers), ");
        sb.append("privacy: ").append(this.mPrivacyPolicy);
        sb.append("receiver pkg: ").append(this.mReceiverPkg);
        sb.append("receiver cls: ").append(this.mReceiverCls);
        return sb.toString();
    }

    public void setAll(boolean all) {
        this.mAll = all;
        if (all) {
            this.mSections.clear();
        }
    }

    public void setPrivacyPolicy(int privacyPolicy) {
        switch (privacyPolicy) {
            case 0: 
            case 100: 
            case 200: {
                this.mPrivacyPolicy = privacyPolicy;
                break;
            }
            default: {
                this.mPrivacyPolicy = 200;
            }
        }
    }

    public void addSection(int section) {
        if (!this.mAll && section > 1) {
            this.mSections.add(section);
        }
    }

    public boolean isAll() {
        return this.mAll;
    }

    public boolean containsSection(int section) {
        return this.mAll || this.mSections.indexOf(section) >= 0;
    }

    public int sectionCount() {
        return this.mSections.size();
    }

    public void addHeader(byte[] header) {
        this.mHeaders.add(header);
    }
}

