/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.ComponentName;
import android.content.pm.SignedPackageParcel;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface ISystemConfig
extends IInterface {
    public static final String DESCRIPTOR = "android.os.ISystemConfig";

    public List<String> getDisabledUntilUsedPreinstalledCarrierApps() throws RemoteException;

    public Map getDisabledUntilUsedPreinstalledCarrierAssociatedApps() throws RemoteException;

    public Map getDisabledUntilUsedPreinstalledCarrierAssociatedAppEntries() throws RemoteException;

    public int[] getSystemPermissionUids(String var1) throws RemoteException;

    public List<ComponentName> getEnabledComponentOverrides(String var1) throws RemoteException;

    public List<ComponentName> getDefaultVrComponents() throws RemoteException;

    public List<String> getPreventUserDisablePackages() throws RemoteException;

    public List<SignedPackageParcel> getEnhancedConfirmationTrustedPackages() throws RemoteException;

    public List<SignedPackageParcel> getEnhancedConfirmationTrustedInstallers() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISystemConfig {
        static final int TRANSACTION_getDisabledUntilUsedPreinstalledCarrierApps = 1;
        static final int TRANSACTION_getDisabledUntilUsedPreinstalledCarrierAssociatedApps = 2;
        static final int TRANSACTION_getDisabledUntilUsedPreinstalledCarrierAssociatedAppEntries = 3;
        static final int TRANSACTION_getSystemPermissionUids = 4;
        static final int TRANSACTION_getEnabledComponentOverrides = 5;
        static final int TRANSACTION_getDefaultVrComponents = 6;
        static final int TRANSACTION_getPreventUserDisablePackages = 7;
        static final int TRANSACTION_getEnhancedConfirmationTrustedPackages = 8;
        static final int TRANSACTION_getEnhancedConfirmationTrustedInstallers = 9;

        public Stub() {
            this.attachInterface(this, ISystemConfig.DESCRIPTOR);
        }

        public static ISystemConfig asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISystemConfig.DESCRIPTOR);
            if (iin != null && iin instanceof ISystemConfig) {
                return (ISystemConfig)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getDisabledUntilUsedPreinstalledCarrierApps";
                }
                case 2: {
                    return "getDisabledUntilUsedPreinstalledCarrierAssociatedApps";
                }
                case 3: {
                    return "getDisabledUntilUsedPreinstalledCarrierAssociatedAppEntries";
                }
                case 4: {
                    return "getSystemPermissionUids";
                }
                case 5: {
                    return "getEnabledComponentOverrides";
                }
                case 6: {
                    return "getDefaultVrComponents";
                }
                case 7: {
                    return "getPreventUserDisablePackages";
                }
                case 8: {
                    return "getEnhancedConfirmationTrustedPackages";
                }
                case 9: {
                    return "getEnhancedConfirmationTrustedInstallers";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISystemConfig.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    List<String> _result = this.getDisabledUntilUsedPreinstalledCarrierApps();
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 2: {
                    Map _result = this.getDisabledUntilUsedPreinstalledCarrierAssociatedApps();
                    reply.writeNoException();
                    reply.writeMap(_result);
                    break;
                }
                case 3: {
                    Map _result = this.getDisabledUntilUsedPreinstalledCarrierAssociatedAppEntries();
                    reply.writeNoException();
                    reply.writeMap(_result);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    int[] _result = this.getSystemPermissionUids(_arg0);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    List<ComponentName> _result = this.getEnabledComponentOverrides(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 6: {
                    List<ComponentName> _result = this.getDefaultVrComponents();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 7: {
                    List<String> _result = this.getPreventUserDisablePackages();
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 8: {
                    List<SignedPackageParcel> _result = this.getEnhancedConfirmationTrustedPackages();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 9: {
                    List<SignedPackageParcel> _result = this.getEnhancedConfirmationTrustedInstallers();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 8;
        }

        private static class Proxy
        implements ISystemConfig {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISystemConfig.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getDisabledUntilUsedPreinstalledCarrierApps() throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISystemConfig.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getDisabledUntilUsedPreinstalledCarrierAssociatedApps() throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISystemConfig.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getDisabledUntilUsedPreinstalledCarrierAssociatedAppEntries() throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISystemConfig.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getSystemPermissionUids(String permissionName) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISystemConfig.DESCRIPTOR);
                    _data.writeString(permissionName);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ComponentName> getEnabledComponentOverrides(String packageName) throws RemoteException {
                ArrayList<ComponentName> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISystemConfig.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(ComponentName.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ComponentName> getDefaultVrComponents() throws RemoteException {
                ArrayList<ComponentName> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISystemConfig.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(ComponentName.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getPreventUserDisablePackages() throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISystemConfig.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SignedPackageParcel> getEnhancedConfirmationTrustedPackages() throws RemoteException {
                ArrayList<SignedPackageParcel> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISystemConfig.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SignedPackageParcel.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SignedPackageParcel> getEnhancedConfirmationTrustedInstallers() throws RemoteException {
                ArrayList<SignedPackageParcel> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISystemConfig.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SignedPackageParcel.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ISystemConfig {
        @Override
        public List<String> getDisabledUntilUsedPreinstalledCarrierApps() throws RemoteException {
            return null;
        }

        @Override
        public Map getDisabledUntilUsedPreinstalledCarrierAssociatedApps() throws RemoteException {
            return null;
        }

        @Override
        public Map getDisabledUntilUsedPreinstalledCarrierAssociatedAppEntries() throws RemoteException {
            return null;
        }

        @Override
        public int[] getSystemPermissionUids(String permissionName) throws RemoteException {
            return null;
        }

        @Override
        public List<ComponentName> getEnabledComponentOverrides(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public List<ComponentName> getDefaultVrComponents() throws RemoteException {
            return null;
        }

        @Override
        public List<String> getPreventUserDisablePackages() throws RemoteException {
            return null;
        }

        @Override
        public List<SignedPackageParcel> getEnhancedConfirmationTrustedPackages() throws RemoteException {
            return null;
        }

        @Override
        public List<SignedPackageParcel> getEnhancedConfirmationTrustedInstallers() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

