/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.ravenwood.annotation.RavenwoodKeep;
import java.io.FileDescriptor;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

public interface IBinder {
    public static final int FIRST_CALL_TRANSACTION = 1;
    public static final int LAST_CALL_TRANSACTION = 0xFFFFFF;
    public static final int PING_TRANSACTION = 1599098439;
    public static final int DUMP_TRANSACTION = 1598311760;
    public static final int SHELL_COMMAND_TRANSACTION = 1598246212;
    public static final int INTERFACE_TRANSACTION = 1598968902;
    public static final int TWEET_TRANSACTION = 1599362900;
    public static final int LIKE_TRANSACTION = 1598835019;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int SYSPROPS_TRANSACTION = 1599295570;
    public static final int FLAG_ONEWAY = 1;
    public static final int FLAG_CLEAR_BUF = 32;
    public static final int FLAG_COLLECT_NOTED_APP_OPS = 2;
    public static final int MAX_IPC_SIZE = 65536;

    @RavenwoodKeep
    public static int getSuggestedMaxIpcSizeBytes() {
        return 65536;
    }

    @Nullable
    public String getInterfaceDescriptor() throws RemoteException;

    public boolean pingBinder();

    public boolean isBinderAlive();

    @Nullable
    public IInterface queryLocalInterface(@NonNull String var1);

    public void dump(@NonNull FileDescriptor var1, @Nullable String[] var2) throws RemoteException;

    public void dumpAsync(@NonNull FileDescriptor var1, @Nullable String[] var2) throws RemoteException;

    public void shellCommand(@Nullable FileDescriptor var1, @Nullable FileDescriptor var2, @Nullable FileDescriptor var3, @NonNull String[] var4, @Nullable ShellCallback var5, @NonNull ResultReceiver var6) throws RemoteException;

    @Nullable
    default public IBinder getExtension() throws RemoteException {
        throw new IllegalStateException("Method is not implemented");
    }

    public boolean transact(int var1, @NonNull Parcel var2, @Nullable Parcel var3, int var4) throws RemoteException;

    public void linkToDeath(@NonNull DeathRecipient var1, int var2) throws RemoteException;

    public boolean unlinkToDeath(@NonNull DeathRecipient var1, int var2);

    @FlaggedApi(value="android.os.binder_frozen_state_change_callback")
    default public void addFrozenStateChangeCallback(@NonNull Executor executor, @NonNull FrozenStateChangeCallback callback) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    default public void addFrozenStateChangeCallback(@NonNull FrozenStateChangeCallback callback) throws RemoteException {
        this.addFrozenStateChangeCallback(Runnable::run, callback);
    }

    @FlaggedApi(value="android.os.binder_frozen_state_change_callback")
    default public boolean removeFrozenStateChangeCallback(@NonNull FrozenStateChangeCallback callback) {
        throw new UnsupportedOperationException();
    }

    @FlaggedApi(value="android.os.binder_frozen_state_change_callback")
    public static interface FrozenStateChangeCallback {
        public static final int STATE_FROZEN = 0;
        public static final int STATE_UNFROZEN = 1;

        public void onFrozenStateChanged(@NonNull IBinder var1, int var2);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface State {
        }
    }

    public static interface DeathRecipient {
        public void binderDied();

        default public void binderDied(@NonNull IBinder who) {
            this.binderDied();
        }
    }
}

