/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.content.Context;
import android.os.CpuUsageInfo;
import android.os.IHardwarePropertiesManager;
import android.os.RemoteException;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class HardwarePropertiesManager {
    private static final String TAG = HardwarePropertiesManager.class.getSimpleName();
    private final IHardwarePropertiesManager mService;
    public static final int DEVICE_TEMPERATURE_CPU = 0;
    public static final int DEVICE_TEMPERATURE_GPU = 1;
    public static final int DEVICE_TEMPERATURE_BATTERY = 2;
    public static final int DEVICE_TEMPERATURE_SKIN = 3;
    public static final int TEMPERATURE_CURRENT = 0;
    public static final int TEMPERATURE_THROTTLING = 1;
    public static final int TEMPERATURE_SHUTDOWN = 2;
    public static final int TEMPERATURE_THROTTLING_BELOW_VR_MIN = 3;
    public static final float UNDEFINED_TEMPERATURE = -3.4028235E38f;
    private final Context mContext;

    public HardwarePropertiesManager(Context context, IHardwarePropertiesManager service) {
        this.mContext = context;
        this.mService = service;
    }

    @NonNull
    public float[] getDeviceTemperatures(int type, int source) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                switch (source) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        try {
                            return this.mService.getDeviceTemperatures(this.mContext.getOpPackageName(), type, source);
                        }
                        catch (RemoteException e) {
                            throw e.rethrowFromSystemServer();
                        }
                    }
                }
                Log.w(TAG, "Unknown device temperature source.");
                return new float[0];
            }
        }
        Log.w(TAG, "Unknown device temperature type.");
        return new float[0];
    }

    @NonNull
    public CpuUsageInfo[] getCpuUsages() {
        try {
            return this.mService.getCpuUsages(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public float[] getFanSpeeds() {
        try {
            return this.mService.getFanSpeeds(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TemperatureSource {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceTemperatureType {
    }
}

