/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os.CpuHeadroomParamsInternal;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;

@FlaggedApi(value="android.os.cpu_gpu_headrooms")
public class CpuHeadroomParams {
    public static final int CPU_HEADROOM_CALCULATION_TYPE_MIN = 0;
    public static final int CPU_HEADROOM_CALCULATION_TYPE_AVERAGE = 1;
    public final CpuHeadroomParamsInternal mInternal = new CpuHeadroomParamsInternal();

    private CpuHeadroomParams() {
    }

    @NonNull
    public Builder toBuilder() {
        return new Builder(this);
    }

    public int getCalculationType() {
        byte by;
        switch (this.mInternal.calculationType) {
            case 0: 
            case 1: {
                by = this.mInternal.calculationType;
                break;
            }
            default: {
                by = 0;
            }
        }
        byte validatedType = by;
        return validatedType;
    }

    public long getCalculationWindowMillis() {
        return this.mInternal.calculationWindowMillis;
    }

    @NonNull
    public int[] getTids() {
        return this.mInternal.tids == null ? null : Arrays.copyOf(this.mInternal.tids, this.mInternal.tids.length);
    }

    public String toString() {
        return "CpuHeadroomParams{calculationType=" + this.mInternal.calculationType + ", calculationWindowMillis=" + this.mInternal.calculationWindowMillis + ", tids=" + Arrays.toString(this.mInternal.tids) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CpuHeadroomParams that = (CpuHeadroomParams)o;
        return this.mInternal.equals(that.mInternal);
    }

    public int hashCode() {
        return this.mInternal.hashCode();
    }

    public static class Builder {
        private int mCalculationType = -1;
        private int mCalculationWindowMillis = -1;
        private int[] mTids = null;

        public Builder() {
        }

        public Builder(@NonNull CpuHeadroomParams params) {
            if (params.mInternal.calculationType >= 0) {
                this.mCalculationType = params.mInternal.calculationType;
            }
            if (params.mInternal.calculationWindowMillis >= 0) {
                this.mCalculationWindowMillis = params.mInternal.calculationWindowMillis;
            }
            if (params.mInternal.tids != null) {
                this.mTids = Arrays.copyOf(params.mInternal.tids, params.mInternal.tids.length);
            }
        }

        @NonNull
        public Builder setCalculationType(int calculationType) {
            switch (calculationType) {
                case 0: 
                case 1: {
                    this.mCalculationType = calculationType;
                    return this;
                }
            }
            throw new IllegalArgumentException("Invalid calculation type: " + calculationType);
        }

        @NonNull
        public Builder setCalculationWindowMillis(int windowMillis) {
            if (windowMillis <= 0) {
                throw new IllegalArgumentException("Invalid calculation window: " + windowMillis);
            }
            this.mCalculationWindowMillis = windowMillis;
            return this;
        }

        @NonNull
        public Builder setTids(int ... tids) {
            for (int tid : tids) {
                if (tid > 0) continue;
                throw new IllegalArgumentException("Invalid TID: " + tid);
            }
            this.mTids = tids;
            return this;
        }

        @NonNull
        public CpuHeadroomParams build() {
            CpuHeadroomParams params = new CpuHeadroomParams();
            if (this.mCalculationType >= 0) {
                params.mInternal.calculationType = (byte)this.mCalculationType;
            }
            if (this.mCalculationWindowMillis >= 0) {
                params.mInternal.calculationWindowMillis = this.mCalculationWindowMillis;
            }
            if (this.mTids != null) {
                params.mInternal.tids = this.mTids;
            }
            return params;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CpuHeadroomCalculationType {
    }
}

