/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.BadTypeParcelableException;
import android.os.BaseBundle;
import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.ArrayMap;
import android.util.Size;
import android.util.SizeF;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@RavenwoodKeepWholeClass
public class Bundle
extends BaseBundle
implements Cloneable,
Parcelable {
    @VisibleForTesting
    static final int FLAG_HAS_FDS = 256;
    @VisibleForTesting
    static final int FLAG_HAS_FDS_KNOWN = 512;
    @VisibleForTesting
    static final int FLAG_ALLOW_FDS = 1024;
    @VisibleForTesting
    static final int FLAG_HAS_BINDERS_KNOWN = 2048;
    @VisibleForTesting
    static final int FLAG_HAS_BINDERS = 4096;
    static final int FLAG_VERIFY_TOKENS_PRESENT = 8192;
    static final int FLAG_HAS_INTENT = 16384;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="android.os.enable_has_binders")
    public static final int STATUS_BINDERS_NOT_PRESENT = 0;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="android.os.enable_has_binders")
    public static final int STATUS_BINDERS_PRESENT = 1;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="android.os.enable_has_binders")
    public static final int STATUS_BINDERS_UNKNOWN = 2;
    public static final Bundle EMPTY = new Bundle();
    public static Class<?> intentClass;
    public static final Bundle STRIPPED;
    private boolean isFirstRetrievedFromABundle = false;
    @NonNull
    public static final Parcelable.Creator<Bundle> CREATOR;

    public Bundle() {
        this.mFlags = 3584;
    }

    @VisibleForTesting
    public Bundle(Parcel parcelledData) {
        super(parcelledData);
        this.mFlags = 1024;
        this.maybePrefillHasFds();
    }

    @VisibleForTesting
    public Bundle(Parcel parcelledData, int length) {
        super(parcelledData, length);
        this.mFlags = 1024;
        this.maybePrefillHasFds();
    }

    Bundle(Bundle from, boolean deep) {
        super(from, deep);
    }

    private void maybePrefillHasFds() {
        if (this.mParcelledData != null) {
            this.mFlags = this.mParcelledData.hasFileDescriptors() ? (this.mFlags |= 0x300) : (this.mFlags |= 0x200);
        }
    }

    public Bundle(ClassLoader loader) {
        super(loader);
        this.mFlags = 3584;
    }

    public Bundle(int capacity) {
        super(capacity);
        this.mFlags = 3584;
    }

    public Bundle(Bundle b) {
        super(b);
        this.mFlags = b.mFlags;
    }

    public Bundle(PersistableBundle b) {
        super(b);
        this.mFlags = 3584;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static Bundle forPair(String key, String value) {
        Bundle b = new Bundle(1);
        b.putString(key, value);
        return b;
    }

    @Override
    public void setClassLoader(ClassLoader loader) {
        super.setClassLoader(loader);
    }

    @Override
    public ClassLoader getClassLoader() {
        return super.getClassLoader();
    }

    public boolean setAllowFds(boolean allowFds) {
        boolean orig;
        boolean bl = orig = (this.mFlags & 0x400) != 0;
        this.mFlags = allowFds ? (this.mFlags |= 0x400) : (this.mFlags &= 0xFFFFFBFF);
        return orig;
    }

    public void enableTokenVerification() {
        this.mFlags |= 0x2000;
    }

    public void setDefusable(boolean defusable) {
        this.mFlags = defusable ? (this.mFlags |= 1) : (this.mFlags &= 0xFFFFFFFE);
    }

    @UnsupportedAppUsage
    public static Bundle setDefusable(Bundle bundle, boolean defusable) {
        if (bundle != null) {
            bundle.setDefusable(defusable);
        }
        return bundle;
    }

    public Object clone() {
        return new Bundle(this);
    }

    public Bundle deepCopy() {
        return new Bundle(this, true);
    }

    @Override
    public void clear() {
        super.clear();
        this.mFlags = 1536;
    }

    @Override
    public void remove(String key) {
        super.remove(key);
        if ((this.mFlags & 0x100) != 0) {
            this.mFlags &= 0xFFFFFDFF;
        }
        if ((this.mFlags & 0x1000) != 0) {
            this.mFlags &= 0xFFFFF7FF;
        }
    }

    public void putAll(Bundle bundle) {
        this.unparcel();
        bundle.unparcel();
        this.mOwnsLazyValues = false;
        bundle.mOwnsLazyValues = false;
        int N2 = bundle.mMap.size();
        for (int i = 0; i < N2; ++i) {
            String key = (String)bundle.mMap.keyAt(i);
            Object value = bundle.mMap.valueAt(i);
            if (value instanceof Bundle) {
                ((Bundle)value).isFirstRetrievedFromABundle = true;
            }
            this.mMap.put(key, value);
        }
        if ((bundle.mFlags & 0x100) != 0) {
            this.mFlags |= 0x100;
        }
        if ((bundle.mFlags & 0x200) == 0) {
            this.mFlags &= 0xFFFFFDFF;
        }
        if ((bundle.mFlags & 0x1000) != 0) {
            this.mFlags |= 0x1000;
        }
        if ((bundle.mFlags & 0x800) == 0) {
            this.mFlags &= 0xFFFFF7FF;
        }
        this.setHasIntent(this.hasIntent() || bundle.hasIntent());
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int getSize() {
        if (this.mParcelledData != null) {
            return this.mParcelledData.dataSize();
        }
        return 0;
    }

    public boolean hasFileDescriptors() {
        if ((this.mFlags & 0x200) == 0) {
            Parcel p = this.mParcelledData;
            this.mFlags = Parcel.hasFileDescriptors(p != null ? p : this.mMap) ? this.mFlags | 0x100 : this.mFlags & 0xFFFFFEFF;
            this.mFlags |= 0x200;
        }
        return (this.mFlags & 0x100) != 0;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="android.os.enable_has_binders")
    public int hasBinders() {
        if ((this.mFlags & 0x800) != 0) {
            if ((this.mFlags & 0x1000) != 0) {
                return 1;
            }
            return 0;
        }
        Parcel p = this.mParcelledData;
        if (p == null) {
            return 2;
        }
        if (p.hasBinders()) {
            this.mFlags = this.mFlags | 0x1000 | 0x800;
            return 1;
        }
        this.mFlags &= 0xFFFFEFFF;
        this.mFlags |= 0x800;
        return 0;
    }

    @Override
    public boolean hasIntent() {
        return super.hasIntent();
    }

    @Override
    public void putObject(@Nullable String key, @Nullable Object value) {
        if (value instanceof Byte) {
            this.putByte(key, (Byte)value);
        } else if (value instanceof Character) {
            this.putChar(key, ((Character)value).charValue());
        } else if (value instanceof Short) {
            this.putShort(key, (Short)value);
        } else if (value instanceof Float) {
            this.putFloat(key, ((Float)value).floatValue());
        } else if (value instanceof CharSequence) {
            this.putCharSequence(key, (CharSequence)value);
        } else if (value instanceof Parcelable) {
            this.putParcelable(key, (Parcelable)value);
        } else if (value instanceof Size) {
            this.putSize(key, (Size)value);
        } else if (value instanceof SizeF) {
            this.putSizeF(key, (SizeF)value);
        } else if (value instanceof Parcelable[]) {
            this.putParcelableArray(key, (Parcelable[])value);
        } else if (value instanceof ArrayList) {
            this.putParcelableArrayList(key, (ArrayList)value);
        } else if (value instanceof List) {
            this.putParcelableList(key, (List)value);
        } else if (value instanceof SparseArray) {
            this.putSparseParcelableArray(key, (SparseArray)value);
        } else if (value instanceof Serializable) {
            this.putSerializable(key, (Serializable)value);
        } else if (value instanceof byte[]) {
            this.putByteArray(key, (byte[])value);
        } else if (value instanceof short[]) {
            this.putShortArray(key, (short[])value);
        } else if (value instanceof char[]) {
            this.putCharArray(key, (char[])value);
        } else if (value instanceof float[]) {
            this.putFloatArray(key, (float[])value);
        } else if (value instanceof CharSequence[]) {
            this.putCharSequenceArray(key, (CharSequence[])value);
        } else if (value instanceof Bundle) {
            this.putBundle(key, (Bundle)value);
        } else if (value instanceof Binder) {
            this.putBinder(key, (Binder)value);
        } else if (value instanceof IBinder) {
            this.putIBinder(key, (IBinder)value);
        } else {
            super.putObject(key, value);
        }
    }

    @Override
    public void putByte(@Nullable String key, byte value) {
        super.putByte(key, value);
    }

    @Override
    public void putChar(@Nullable String key, char value) {
        super.putChar(key, value);
    }

    @Override
    public void putShort(@Nullable String key, short value) {
        super.putShort(key, value);
    }

    @Override
    public void putFloat(@Nullable String key, float value) {
        super.putFloat(key, value);
    }

    @Override
    public void putCharSequence(@Nullable String key, @Nullable CharSequence value) {
        super.putCharSequence(key, value);
    }

    public void putParcelable(@Nullable String key, @Nullable Parcelable value) {
        this.unparcel();
        this.mMap.put(key, value);
        this.mFlags &= 0xFFFFFDFF;
        this.mFlags &= 0xFFFFF7FF;
        if (intentClass != null && intentClass.isInstance(value)) {
            this.setHasIntent(true);
        } else if (value instanceof Bundle) {
            ((Bundle)value).isFirstRetrievedFromABundle = true;
        }
    }

    public void putSize(@Nullable String key, @Nullable Size value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    public void putSizeF(@Nullable String key, @Nullable SizeF value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    public void putParcelableArray(@Nullable String key, @Nullable Parcelable[] value) {
        this.unparcel();
        this.mMap.put(key, value);
        this.mFlags &= 0xFFFFFDFF;
        this.mFlags &= 0xFFFFF7FF;
    }

    public void putParcelableArrayList(@Nullable String key, @Nullable ArrayList<? extends Parcelable> value) {
        this.unparcel();
        this.mMap.put(key, value);
        this.mFlags &= 0xFFFFFDFF;
        this.mFlags &= 0xFFFFF7FF;
    }

    @UnsupportedAppUsage
    public void putParcelableList(String key, List<? extends Parcelable> value) {
        this.unparcel();
        this.mMap.put(key, value);
        this.mFlags &= 0xFFFFFDFF;
        this.mFlags &= 0xFFFFF7FF;
    }

    public void putSparseParcelableArray(@Nullable String key, @Nullable SparseArray<? extends Parcelable> value) {
        this.unparcel();
        this.mMap.put(key, value);
        this.mFlags &= 0xFFFFFDFF;
        this.mFlags &= 0xFFFFF7FF;
    }

    @Override
    public void putIntegerArrayList(@Nullable String key, @Nullable ArrayList<Integer> value) {
        super.putIntegerArrayList(key, value);
    }

    @Override
    public void putStringArrayList(@Nullable String key, @Nullable ArrayList<String> value) {
        super.putStringArrayList(key, value);
    }

    @Override
    public void putCharSequenceArrayList(@Nullable String key, @Nullable ArrayList<CharSequence> value) {
        super.putCharSequenceArrayList(key, value);
    }

    @Override
    public void putSerializable(@Nullable String key, @Nullable Serializable value) {
        super.putSerializable(key, value);
    }

    @Override
    public void putByteArray(@Nullable String key, @Nullable byte[] value) {
        super.putByteArray(key, value);
    }

    @Override
    public void putShortArray(@Nullable String key, @Nullable short[] value) {
        super.putShortArray(key, value);
    }

    @Override
    public void putCharArray(@Nullable String key, @Nullable char[] value) {
        super.putCharArray(key, value);
    }

    @Override
    public void putFloatArray(@Nullable String key, @Nullable float[] value) {
        super.putFloatArray(key, value);
    }

    @Override
    public void putCharSequenceArray(@Nullable String key, @Nullable CharSequence[] value) {
        super.putCharSequenceArray(key, value);
    }

    public void putBundle(@Nullable String key, @Nullable Bundle value) {
        this.unparcel();
        if (value != null) {
            value.isFirstRetrievedFromABundle = true;
        }
        this.mMap.put(key, value);
    }

    public void putBinder(@Nullable String key, @Nullable IBinder value) {
        this.unparcel();
        this.mMap.put(key, value);
        this.mFlags &= 0xFFFFF7FF;
    }

    @Deprecated
    @UnsupportedAppUsage
    public void putIBinder(@Nullable String key, @Nullable IBinder value) {
        this.unparcel();
        this.mMap.put(key, value);
        this.mFlags &= 0xFFFFF7FF;
    }

    @Override
    public byte getByte(String key) {
        return super.getByte(key);
    }

    @Override
    public Byte getByte(String key, byte defaultValue) {
        return super.getByte(key, defaultValue);
    }

    @Override
    public char getChar(String key) {
        return super.getChar(key);
    }

    @Override
    public char getChar(String key, char defaultValue) {
        return super.getChar(key, defaultValue);
    }

    @Override
    public short getShort(String key) {
        return super.getShort(key);
    }

    @Override
    public short getShort(String key, short defaultValue) {
        return super.getShort(key, defaultValue);
    }

    @Override
    public float getFloat(String key) {
        return super.getFloat(key);
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        return super.getFloat(key, defaultValue);
    }

    @Override
    @Nullable
    public CharSequence getCharSequence(@Nullable String key) {
        return super.getCharSequence(key);
    }

    @Override
    public CharSequence getCharSequence(@Nullable String key, CharSequence defaultValue) {
        return super.getCharSequence(key, defaultValue);
    }

    @Nullable
    public Size getSize(@Nullable String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        try {
            return (Size)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Size", e);
            return null;
        }
    }

    @Nullable
    public SizeF getSizeF(@Nullable String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        try {
            return (SizeF)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "SizeF", e);
            return null;
        }
    }

    @Nullable
    public Bundle getBundle(@Nullable String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            Bundle bundle = (Bundle)o;
            bundle.setClassLoaderSameAsContainerBundleWhenRetrievedFirstTime(this);
            return bundle;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Bundle", e);
            return null;
        }
    }

    void setClassLoaderSameAsContainerBundleWhenRetrievedFirstTime(BaseBundle containerBundle) {
        if (!this.isFirstRetrievedFromABundle) {
            this.setClassLoader(containerBundle.getClassLoader());
            this.isFirstRetrievedFromABundle = true;
        }
    }

    @Deprecated
    @Nullable
    public <T extends Parcelable> T getParcelable(@Nullable String key) {
        this.unparcel();
        Object o = this.getValue(key);
        if (o == null) {
            return null;
        }
        try {
            return (T)((Parcelable)o);
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Parcelable", e);
            return null;
        }
    }

    @Nullable
    public <T> T getParcelable(@Nullable String key, @NonNull Class<T> clazz) {
        return this.get(key, clazz);
    }

    @Deprecated
    @Nullable
    public Parcelable[] getParcelableArray(@Nullable String key) {
        this.unparcel();
        Object o = this.getValue(key);
        if (o == null) {
            return null;
        }
        try {
            return (Parcelable[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Parcelable[]", e);
            return null;
        }
    }

    @SuppressLint(value={"ArrayReturn", "NullableCollection"})
    @Nullable
    public <T> T[] getParcelableArray(@Nullable String key, @NonNull Class<T> clazz) {
        this.unparcel();
        try {
            return this.getValue(key, Parcelable[].class, Objects.requireNonNull(clazz));
        }
        catch (BadTypeParcelableException | ClassCastException e) {
            this.typeWarning(key, clazz.getCanonicalName() + "[]", e);
            return null;
        }
    }

    @Deprecated
    @Nullable
    public <T extends Parcelable> ArrayList<T> getParcelableArrayList(@Nullable String key) {
        this.unparcel();
        Object o = this.getValue(key);
        if (o == null) {
            return null;
        }
        try {
            return (ArrayList)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "ArrayList", e);
            return null;
        }
    }

    @SuppressLint(value={"NullableCollection"})
    @Nullable
    public <T> ArrayList<T> getParcelableArrayList(@Nullable String key, @NonNull Class<? extends T> clazz) {
        return this.getArrayList(key, clazz);
    }

    @Deprecated
    @Nullable
    public <T extends Parcelable> SparseArray<T> getSparseParcelableArray(@Nullable String key) {
        this.unparcel();
        Object o = this.getValue(key);
        if (o == null) {
            return null;
        }
        try {
            return (SparseArray)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "SparseArray", e);
            return null;
        }
    }

    @Nullable
    public <T> SparseArray<T> getSparseParcelableArray(@Nullable String key, @NonNull Class<? extends T> clazz) {
        this.unparcel();
        try {
            return this.getValue(key, SparseArray.class, Objects.requireNonNull(clazz));
        }
        catch (BadTypeParcelableException | ClassCastException e) {
            this.typeWarning(key, "SparseArray<" + clazz.getCanonicalName() + ">", e);
            return null;
        }
    }

    @Override
    @Deprecated
    @Nullable
    public Serializable getSerializable(@Nullable String key) {
        return super.getSerializable(key);
    }

    @Override
    @Nullable
    public <T extends Serializable> T getSerializable(@Nullable String key, @NonNull Class<T> clazz) {
        return super.getSerializable(key, Objects.requireNonNull(clazz));
    }

    @Override
    @Nullable
    public ArrayList<Integer> getIntegerArrayList(@Nullable String key) {
        return super.getIntegerArrayList(key);
    }

    @Override
    @Nullable
    public ArrayList<String> getStringArrayList(@Nullable String key) {
        return super.getStringArrayList(key);
    }

    @Override
    @Nullable
    public ArrayList<CharSequence> getCharSequenceArrayList(@Nullable String key) {
        return super.getCharSequenceArrayList(key);
    }

    @Override
    @Nullable
    public byte[] getByteArray(@Nullable String key) {
        return super.getByteArray(key);
    }

    @Override
    @Nullable
    public short[] getShortArray(@Nullable String key) {
        return super.getShortArray(key);
    }

    @Override
    @Nullable
    public char[] getCharArray(@Nullable String key) {
        return super.getCharArray(key);
    }

    @Override
    @Nullable
    public float[] getFloatArray(@Nullable String key) {
        return super.getFloatArray(key);
    }

    @Override
    @Nullable
    public CharSequence[] getCharSequenceArray(@Nullable String key) {
        return super.getCharSequenceArray(key);
    }

    @Nullable
    public IBinder getBinder(@Nullable String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (IBinder)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "IBinder", e);
            return null;
        }
    }

    @Deprecated
    @UnsupportedAppUsage
    @Nullable
    public IBinder getIBinder(@Nullable String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (IBinder)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "IBinder", e);
            return null;
        }
    }

    @Override
    public int describeContents() {
        int mask = 0;
        if (this.hasFileDescriptors()) {
            mask |= 1;
        }
        return mask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        boolean oldAllowFds = parcel.pushAllowFds((this.mFlags & 0x400) != 0);
        try {
            this.writeToParcelInner(parcel, flags);
        }
        finally {
            parcel.restoreAllowFds(oldAllowFds);
        }
    }

    public void readFromParcel(Parcel parcel) {
        this.readFromParcelInner(parcel);
        this.mFlags = 1024;
        this.maybePrefillHasFds();
    }

    public synchronized String toString() {
        if (this.mParcelledData != null) {
            if (this.isEmptyParcel()) {
                return "Bundle[EMPTY_PARCEL]";
            }
            return "Bundle[mParcelledData.dataSize=" + this.mParcelledData.dataSize() + "]";
        }
        return "Bundle[" + this.mMap.toString() + "]";
    }

    public synchronized String toShortString() {
        if (this.mParcelledData != null) {
            if (this.isEmptyParcel()) {
                return "EMPTY_PARCEL";
            }
            return "mParcelledData.dataSize=" + this.mParcelledData.dataSize();
        }
        return this.mMap.toString();
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        if (this.mParcelledData != null) {
            if (this.isEmptyParcel()) {
                proto.write(0x10500000001L, 0);
            } else {
                proto.write(0x10500000001L, this.mParcelledData.dataSize());
            }
        } else {
            proto.write(1138166333442L, this.mMap.toString());
        }
        proto.end(token);
    }

    static {
        Bundle.EMPTY.mMap = ArrayMap.EMPTY;
        STRIPPED = new Bundle();
        STRIPPED.putInt("STRIPPED", 1);
        CREATOR = new Parcelable.Creator<Bundle>(){

            @Override
            public Bundle createFromParcel(Parcel in) {
                return in.readBundle();
            }

            public Bundle[] newArray(int size) {
                return new Bundle[size];
            }
        };
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HasBinderStatus {
    }
}

