/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.cardemulation;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.content.ComponentName;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import android.util.proto.ProtoOutputStream;
import com.android.internal.R;
import java.io.IOException;
import java.io.PrintWriter;
import org.xmlpull.v1.XmlPullParserException;

@SystemApi
@FlaggedApi(value="android.nfc.enable_nfc_mainline")
public class NfcFServiceInfo
implements Parcelable {
    static final String TAG = "NfcFServiceInfo";
    private static final String DEFAULT_T3T_PMM = "FFFFFFFFFFFFFFFF";
    private final ResolveInfo mService;
    private final String mDescription;
    private final String mSystemCode;
    private String mDynamicSystemCode;
    private final String mNfcid2;
    private String mDynamicNfcid2;
    private final int mUid;
    private final String mT3tPmm;
    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public static final Parcelable.Creator<NfcFServiceInfo> CREATOR = new Parcelable.Creator<NfcFServiceInfo>(){

        @Override
        public NfcFServiceInfo createFromParcel(Parcel source) {
            ResolveInfo info = ResolveInfo.CREATOR.createFromParcel(source);
            String description = source.readString();
            String systemCode = source.readString();
            String dynamicSystemCode = null;
            if (source.readInt() != 0) {
                dynamicSystemCode = source.readString();
            }
            String nfcid2 = source.readString();
            String dynamicNfcid2 = null;
            if (source.readInt() != 0) {
                dynamicNfcid2 = source.readString();
            }
            int uid = source.readInt();
            String t3tPmm = source.readString();
            NfcFServiceInfo service = new NfcFServiceInfo(info, description, systemCode, dynamicSystemCode, nfcid2, dynamicNfcid2, uid, t3tPmm);
            return service;
        }

        public NfcFServiceInfo[] newArray(int size) {
            return new NfcFServiceInfo[size];
        }
    };

    public NfcFServiceInfo(ResolveInfo info, String description, String systemCode, String dynamicSystemCode, String nfcid2, String dynamicNfcid2, int uid, String t3tPmm) {
        this.mService = info;
        this.mDescription = description;
        this.mSystemCode = systemCode;
        this.mDynamicSystemCode = dynamicSystemCode;
        this.mNfcid2 = nfcid2;
        this.mDynamicNfcid2 = dynamicNfcid2;
        this.mUid = uid;
        this.mT3tPmm = t3tPmm;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public NfcFServiceInfo(@NonNull PackageManager pm, @NonNull ResolveInfo info) throws XmlPullParserException, IOException {
        ServiceInfo si = info.serviceInfo;
        try (XmlResourceParser parser = null;){
            parser = si.loadXmlMetaData(pm, "android.nfc.cardemulation.host_nfcf_service");
            if (parser == null) {
                throw new XmlPullParserException("No android.nfc.cardemulation.host_nfcf_service meta-data");
            }
            int eventType = parser.getEventType();
            while (eventType != 2 && eventType != 1) {
                eventType = parser.next();
            }
            String tagName = parser.getName();
            if (!"host-nfcf-service".equals(tagName)) {
                throw new XmlPullParserException("Meta-data does not start with <host-nfcf-service> tag");
            }
            Resources res = pm.getResourcesForApplication(si.applicationInfo);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            TypedArray sa = res.obtainAttributes(attrs, R.styleable.HostNfcFService);
            this.mService = info;
            this.mDescription = sa.getString(0);
            this.mDynamicSystemCode = null;
            this.mDynamicNfcid2 = null;
            sa.recycle();
            String systemCode = null;
            String nfcid2 = null;
            String t3tPmm = null;
            int depth = parser.getDepth();
            while (((eventType = parser.next()) != 3 || parser.getDepth() > depth) && eventType != 1) {
                TypedArray a;
                tagName = parser.getName();
                if (eventType == 2 && "system-code-filter".equals(tagName) && systemCode == null) {
                    a = res.obtainAttributes(attrs, R.styleable.SystemCodeFilter);
                    systemCode = a.getString(0).toUpperCase();
                    if (!NfcFServiceInfo.isValidSystemCode(systemCode) && !systemCode.equalsIgnoreCase("NULL")) {
                        Log.e(TAG, "Invalid System Code: " + systemCode);
                        systemCode = null;
                    }
                    a.recycle();
                    continue;
                }
                if (eventType == 2 && "nfcid2-filter".equals(tagName) && nfcid2 == null) {
                    a = res.obtainAttributes(attrs, R.styleable.Nfcid2Filter);
                    nfcid2 = a.getString(0).toUpperCase();
                    if (!(nfcid2.equalsIgnoreCase("RANDOM") || nfcid2.equalsIgnoreCase("NULL") || NfcFServiceInfo.isValidNfcid2(nfcid2))) {
                        Log.e(TAG, "Invalid NFCID2: " + nfcid2);
                        nfcid2 = null;
                    }
                    a.recycle();
                    continue;
                }
                if (eventType != 2 || !tagName.equals("t3tPmm-filter") || t3tPmm != null) continue;
                a = res.obtainAttributes(attrs, R.styleable.T3tPmmFilter);
                t3tPmm = a.getString(0).toUpperCase();
                a.recycle();
            }
            this.mSystemCode = systemCode == null ? "NULL" : systemCode;
            this.mNfcid2 = nfcid2 == null ? "NULL" : nfcid2;
            this.mT3tPmm = t3tPmm == null ? DEFAULT_T3T_PMM : t3tPmm;
        }
        this.mUid = si.applicationInfo.uid;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public ComponentName getComponent() {
        return new ComponentName(this.mService.serviceInfo.packageName, this.mService.serviceInfo.name);
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public String getSystemCode() {
        return this.mDynamicSystemCode == null ? this.mSystemCode : this.mDynamicSystemCode;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public void setDynamicSystemCode(@NonNull String systemCode) {
        this.mDynamicSystemCode = systemCode;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public String getNfcid2() {
        return this.mDynamicNfcid2 == null ? this.mNfcid2 : this.mDynamicNfcid2;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public void setDynamicNfcid2(@NonNull String nfcid2) {
        this.mDynamicNfcid2 = nfcid2;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public String getDescription() {
        return this.mDescription;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public int getUid() {
        return this.mUid;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public String getT3tPmm() {
        return this.mT3tPmm;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public CharSequence loadLabel(@NonNull PackageManager pm) {
        return this.mService.loadLabel(pm);
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public Drawable loadIcon(@NonNull PackageManager pm) {
        return this.mService.loadIcon(pm);
    }

    public String toString() {
        StringBuilder out = new StringBuilder("NfcFService: ");
        out.append(this.getComponent());
        out.append(", UID: " + this.mUid);
        out.append(", description: " + this.mDescription);
        out.append(", System Code: " + this.mSystemCode);
        if (this.mDynamicSystemCode != null) {
            out.append(", dynamic System Code: " + this.mDynamicSystemCode);
        }
        out.append(", NFCID2: " + this.mNfcid2);
        if (this.mDynamicNfcid2 != null) {
            out.append(", dynamic NFCID2: " + this.mDynamicNfcid2);
        }
        out.append(", T3T PMM:" + this.mT3tPmm);
        return out.toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NfcFServiceInfo)) {
            return false;
        }
        NfcFServiceInfo thatService = (NfcFServiceInfo)o;
        if (!thatService.getComponent().equals(this.getComponent())) {
            return false;
        }
        if (thatService.getUid() != this.getUid()) {
            return false;
        }
        if (!thatService.mSystemCode.equalsIgnoreCase(this.mSystemCode)) {
            return false;
        }
        if (!thatService.mNfcid2.equalsIgnoreCase(this.mNfcid2)) {
            return false;
        }
        return thatService.mT3tPmm.equalsIgnoreCase(this.mT3tPmm);
    }

    public int hashCode() {
        return this.getComponent().hashCode();
    }

    @Override
    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public int describeContents() {
        return 0;
    }

    @Override
    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        this.mService.writeToParcel(dest, flags);
        dest.writeString(this.mDescription);
        dest.writeString(this.mSystemCode);
        dest.writeInt(this.mDynamicSystemCode != null ? 1 : 0);
        if (this.mDynamicSystemCode != null) {
            dest.writeString(this.mDynamicSystemCode);
        }
        dest.writeString(this.mNfcid2);
        dest.writeInt(this.mDynamicNfcid2 != null ? 1 : 0);
        if (this.mDynamicNfcid2 != null) {
            dest.writeString(this.mDynamicNfcid2);
        }
        dest.writeInt(this.mUid);
        dest.writeString(this.mT3tPmm);
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public void dump(@NonNull ParcelFileDescriptor fd, @NonNull PrintWriter pw, @NonNull String[] args) {
        pw.println("    " + this.getComponent() + " (Description: " + this.getDescription() + ") (UID: " + this.getUid() + ")");
        pw.println("    System Code: " + this.getSystemCode());
        pw.println("    NFCID2: " + this.getNfcid2());
        pw.println("    T3tPmm: " + this.getT3tPmm());
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public void dumpDebug(@NonNull ProtoOutputStream proto) {
        this.getComponent().dumpDebug(proto, 0x10B00000001L);
        proto.write(1138166333442L, this.getDescription());
        proto.write(1138166333443L, this.getSystemCode());
        proto.write(1138166333444L, this.getNfcid2());
        proto.write(1138166333445L, this.getT3tPmm());
    }

    private static boolean isValidSystemCode(String systemCode) {
        if (systemCode == null) {
            return false;
        }
        if (systemCode.length() != 4) {
            Log.e(TAG, "System Code " + systemCode + " is not a valid System Code.");
            return false;
        }
        if (!systemCode.startsWith("4") || systemCode.toUpperCase().endsWith("FF")) {
            Log.e(TAG, "System Code " + systemCode + " is not a valid System Code.");
            return false;
        }
        try {
            Integer.parseInt(systemCode, 16);
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "System Code " + systemCode + " is not a valid System Code.");
            return false;
        }
        return true;
    }

    private static boolean isValidNfcid2(String nfcid2) {
        if (nfcid2 == null) {
            return false;
        }
        if (nfcid2.length() != 16) {
            Log.e(TAG, "NFCID2 " + nfcid2 + " is not a valid NFCID2.");
            return false;
        }
        if (!nfcid2.toUpperCase().startsWith("02FE")) {
            Log.e(TAG, "NFCID2 " + nfcid2 + " is not a valid NFCID2.");
            return false;
        }
        try {
            Long.parseLong(nfcid2, 16);
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "NFCID2 " + nfcid2 + " is not a valid NFCID2.");
            return false;
        }
        return true;
    }
}

