/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.cardemulation;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.Activity;
import android.app.role.RoleManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.nfc.ComponentNameAndUser;
import android.nfc.INfcCardEmulation;
import android.nfc.INfcEventCallback;
import android.nfc.NfcAdapter;
import android.nfc.cardemulation.AidGroup;
import android.nfc.cardemulation.ApduServiceInfo;
import android.nfc.cardemulation.PollingFrame;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.ArrayMap;
import android.util.Log;
import com.android.nfc.x.android.nfc.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;

public class CardEmulation {
    private static final Pattern AID_PATTERN = Pattern.compile("[0-9A-Fa-f]{10,32}\\*?\\#?");
    private static final Pattern PLPF_PATTERN = Pattern.compile("[0-9A-Fa-f]{2,}[0-9A-Fa-f,\\?,\\*\\.]*");
    static final String TAG = "CardEmulation";
    @Deprecated
    public static final String ACTION_CHANGE_DEFAULT = "android.nfc.cardemulation.action.ACTION_CHANGE_DEFAULT";
    public static final String EXTRA_CATEGORY = "category";
    public static final String EXTRA_SERVICE_COMPONENT = "component";
    public static final String CATEGORY_PAYMENT = "payment";
    public static final String CATEGORY_OTHER = "other";
    public static final int SELECTION_MODE_PREFER_DEFAULT = 0;
    public static final int SELECTION_MODE_ALWAYS_ASK = 1;
    public static final int SELECTION_MODE_ASK_IF_CONFLICT = 2;
    @FlaggedApi(value="android.nfc.nfc_override_recover_routing_table")
    public static final int PROTOCOL_AND_TECHNOLOGY_ROUTE_DH = 0;
    @FlaggedApi(value="android.nfc.nfc_override_recover_routing_table")
    public static final int PROTOCOL_AND_TECHNOLOGY_ROUTE_ESE = 1;
    @FlaggedApi(value="android.nfc.nfc_override_recover_routing_table")
    public static final int PROTOCOL_AND_TECHNOLOGY_ROUTE_UICC = 2;
    @FlaggedApi(value="android.nfc.nfc_override_recover_routing_table")
    public static final int PROTOCOL_AND_TECHNOLOGY_ROUTE_DEFAULT = 3;
    @FlaggedApi(value="com.android.nfc.module.flags.oem_extension_25q4")
    public static final int PROTOCOL_AND_TECHNOLOGY_ROUTE_NDEF_NFCEE = 4;
    @FlaggedApi(value="android.nfc.nfc_override_recover_routing_table")
    public static final int PROTOCOL_AND_TECHNOLOGY_ROUTE_UNSET = -1;
    @SystemApi
    @FlaggedApi(value="android.nfc.nfc_set_service_enabled_for_category_other")
    public static final int SET_SERVICE_ENABLED_STATUS_OK = 0;
    @SystemApi
    @FlaggedApi(value="android.nfc.nfc_set_service_enabled_for_category_other")
    public static final int SET_SERVICE_ENABLED_STATUS_FAILURE_FEATURE_UNSUPPORTED = 1;
    @SystemApi
    @FlaggedApi(value="android.nfc.nfc_set_service_enabled_for_category_other")
    public static final int SET_SERVICE_ENABLED_STATUS_FAILURE_INVALID_SERVICE = 2;
    @SystemApi
    @FlaggedApi(value="android.nfc.nfc_set_service_enabled_for_category_other")
    public static final int SET_SERVICE_ENABLED_STATUS_FAILURE_ALREADY_SET = 3;
    @SystemApi
    @FlaggedApi(value="android.nfc.nfc_set_service_enabled_for_category_other")
    public static final int SET_SERVICE_ENABLED_STATUS_FAILURE_UNKNOWN_ERROR = 4;
    @FlaggedApi(value="android.nfc.nfc_associated_role_services")
    public static final String PROPERTY_ALLOW_SHARED_ROLE_PRIORITY = "android.nfc.cardemulation.PROPERTY_ALLOW_SHARED_ROLE_PRIORITY";
    static boolean sIsInitialized = false;
    static HashMap<Context, CardEmulation> sCardEmus = new HashMap();
    static INfcCardEmulation sService;
    final Context mContext;
    @SystemApi
    @FlaggedApi(value="android.nfc.enable_card_emulation_euicc")
    public static final int SET_SUBSCRIPTION_ID_STATUS_SUCCESS = 0;
    @SystemApi
    @FlaggedApi(value="android.nfc.enable_card_emulation_euicc")
    public static final int SET_SUBSCRIPTION_ID_STATUS_FAILED_INVALID_SUBSCRIPTION_ID = 1;
    @SystemApi
    @FlaggedApi(value="android.nfc.enable_card_emulation_euicc")
    public static final int SET_SUBSCRIPTION_ID_STATUS_FAILED_INTERNAL_ERROR = 2;
    @SystemApi
    @FlaggedApi(value="android.nfc.enable_card_emulation_euicc")
    public static final int SET_SUBSCRIPTION_ID_STATUS_FAILED_NOT_SUPPORTED = 3;
    @SystemApi
    @FlaggedApi(value="android.nfc.enable_card_emulation_euicc")
    public static final int SET_SUBSCRIPTION_ID_STATUS_UNKNOWN = -1;
    @FlaggedApi(value="android.nfc.nfc_event_listener")
    public static final int NFC_INTERNAL_ERROR_UNKNOWN = 0;
    @FlaggedApi(value="android.nfc.nfc_event_listener")
    public static final int NFC_INTERNAL_ERROR_NFC_CRASH_RESTART = 1;
    @FlaggedApi(value="android.nfc.nfc_event_listener")
    public static final int NFC_INTERNAL_ERROR_NFC_HARDWARE_ERROR = 2;
    @FlaggedApi(value="android.nfc.nfc_event_listener")
    public static final int NFC_INTERNAL_ERROR_COMMAND_TIMEOUT = 3;
    private final ArrayMap<NfcEventCallback, Executor> mNfcEventCallbacks = new ArrayMap();
    final INfcEventCallback mINfcEventCallback = new INfcEventCallback.Stub(){

        @Override
        public void onPreferredServiceChanged(ComponentNameAndUser componentNameAndUser) {
            if (!Flags.nfcEventListener()) {
                return;
            }
            boolean isPreferred = componentNameAndUser != null && componentNameAndUser.getUserId() == CardEmulation.this.mContext.getUser().getIdentifier() && componentNameAndUser.getComponentName() != null && Objects.equals(CardEmulation.this.mContext.getPackageName(), componentNameAndUser.getComponentName().getPackageName());
            this.callListeners(listener -> listener.onPreferredServiceChanged(isPreferred));
        }

        @Override
        public void onObserveModeStateChanged(boolean isEnabled) {
            if (!Flags.nfcEventListener()) {
                return;
            }
            this.callListeners(listener -> listener.onObserveModeStateChanged(isEnabled));
        }

        @Override
        public void onObserveModeDisabledInFirmware(PollingFrame exitFrame) {
            if (!Flags.nfcEventListener()) {
                return;
            }
            this.callListeners(listener -> listener.onObserveModeDisabledInFirmware(exitFrame));
        }

        @Override
        public void onAidConflictOccurred(String aid) {
            if (!Flags.nfcEventListener()) {
                return;
            }
            this.callListeners(listener -> listener.onAidConflictOccurred(aid));
        }

        @Override
        public void onAidNotRouted(String aid) {
            if (!Flags.nfcEventListener()) {
                return;
            }
            this.callListeners(listener -> listener.onAidNotRouted(aid));
        }

        @Override
        public void onNfcStateChanged(int state) {
            if (!Flags.nfcEventListener()) {
                return;
            }
            this.callListeners(listener -> listener.onNfcStateChanged(state));
        }

        @Override
        public void onRemoteFieldChanged(boolean isDetected) {
            if (!Flags.nfcEventListener()) {
                return;
            }
            this.callListeners(listener -> listener.onRemoteFieldChanged(isDetected));
        }

        @Override
        public void onInternalErrorReported(int errorType) {
            if (!Flags.nfcEventListener()) {
                return;
            }
            this.callListeners(listener -> listener.onInternalErrorReported(errorType));
        }

        @Override
        public void onOffHostAidSelected(String aid, String eeName) {
            if (!com.android.nfc.module.flags.Flags.eventListenerOffhostAidSelected()) {
                return;
            }
            this.callListeners(listener -> listener.onOffHostAidSelected(aid, eeName));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void callListeners(ListenerCall listenerCall) {
            ArrayMap<NfcEventCallback, Executor> arrayMap = CardEmulation.this.mNfcEventCallbacks;
            synchronized (arrayMap) {
                CardEmulation.this.mNfcEventCallbacks.forEach((listener, executor) -> executor.execute(() -> listenerCall.invoke((NfcEventCallback)listener)));
            }
        }

        static interface ListenerCall {
            public void invoke(NfcEventCallback var1);
        }
    };
    private IBinder.DeathRecipient mDeathRecipient;

    private CardEmulation(Context context, INfcCardEmulation service) {
        this.mContext = context.getApplicationContext();
        sService = service;
    }

    public static synchronized CardEmulation getInstance(NfcAdapter adapter) {
        CardEmulation manager;
        if (adapter == null) {
            throw new NullPointerException("NfcAdapter is null");
        }
        Context context = adapter.getContext();
        if (context == null) {
            Log.e(TAG, "NfcAdapter context is null.");
            throw new UnsupportedOperationException();
        }
        if (!sIsInitialized) {
            PackageManager pm = context.getPackageManager();
            if (pm == null) {
                Log.e(TAG, "Cannot get PackageManager");
                throw new UnsupportedOperationException();
            }
            if (!pm.hasSystemFeature("android.hardware.nfc.hce")) {
                Log.e(TAG, "This device does not support card emulation");
                throw new UnsupportedOperationException();
            }
            sIsInitialized = true;
        }
        if ((manager = sCardEmus.get(context)) == null) {
            INfcCardEmulation service = adapter.getCardEmulationService();
            if (service == null) {
                Log.e(TAG, "This device does not implement the INfcCardEmulation interface.");
                throw new UnsupportedOperationException();
            }
            manager = new CardEmulation(context, service);
            sCardEmus.put(context, manager);
        }
        return manager;
    }

    public boolean isDefaultServiceForCategory(ComponentName service, String category) {
        return CardEmulation.callServiceReturn(() -> sService.isDefaultServiceForCategory(this.mContext.getUser().getIdentifier(), service, category), false);
    }

    public boolean isDefaultServiceForAid(ComponentName service, String aid) {
        return CardEmulation.callServiceReturn(() -> sService.isDefaultServiceForAid(this.mContext.getUser().getIdentifier(), service, aid), false);
    }

    public boolean categoryAllowsForegroundPreference(String category) {
        Context contextAsUser = this.mContext.createContextAsUser(UserHandle.of(UserHandle.myUserId()), 0);
        RoleManager roleManager = contextAsUser.getSystemService(RoleManager.class);
        if (roleManager.isRoleAvailable("android.app.role.WALLET")) {
            return true;
        }
        if (CATEGORY_PAYMENT.equals(category)) {
            boolean preferForeground = false;
            try {
                preferForeground = Settings.Secure.getInt(contextAsUser.getContentResolver(), "nfc_payment_foreground") != 0;
            }
            catch (Settings.SettingNotFoundException settingNotFoundException) {
                // empty catch block
            }
            return preferForeground;
        }
        return true;
    }

    public int getSelectionModeForCategory(String category) {
        if (CATEGORY_PAYMENT.equals(category)) {
            boolean paymentRegistered = CardEmulation.callServiceReturn(() -> sService.isDefaultPaymentRegistered(), false);
            if (paymentRegistered) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    public boolean setShouldDefaultToObserveModeForService(@NonNull ComponentName service, boolean enable) {
        return CardEmulation.callServiceReturn(() -> sService.setShouldDefaultToObserveModeForService(this.mContext.getUser().getIdentifier(), service, enable), false);
    }

    @FlaggedApi(value="com.android.nfc.module.flags.screen_state_attribute_toggle")
    public void setRequireDeviceScreenOnForService(@NonNull ComponentName service, boolean enable) {
        CardEmulation.callService(() -> sService.setRequireDeviceScreenOnForService(this.mContext.getUser().getIdentifier(), service, enable));
    }

    @FlaggedApi(value="com.android.nfc.module.flags.screen_state_attribute_toggle")
    public boolean isDeviceScreenOnRequiredForService(@NonNull ComponentName service) {
        return CardEmulation.callServiceReturn(() -> sService.isDeviceScreenOnRequiredForService(this.mContext.getUser().getIdentifier(), service), false);
    }

    @FlaggedApi(value="com.android.nfc.module.flags.screen_state_attribute_toggle")
    public void setRequireDeviceUnlockForService(@NonNull ComponentName service, boolean enable) {
        CardEmulation.callService(() -> sService.setRequireDeviceUnlockForService(this.mContext.getUser().getIdentifier(), service, enable));
    }

    @FlaggedApi(value="com.android.nfc.module.flags.screen_state_attribute_toggle")
    public boolean isDeviceUnlockRequiredForService(@NonNull ComponentName service) {
        return CardEmulation.callServiceReturn(() -> sService.isDeviceUnlockRequiredForService(this.mContext.getUser().getIdentifier(), service), false);
    }

    public boolean registerPollingLoopFilterForService(@NonNull ComponentName service, @NonNull String pollingLoopFilter, boolean autoTransact) {
        String pollingLoopFilterV = CardEmulation.validatePollingLoopFilter(pollingLoopFilter);
        return CardEmulation.callServiceReturn(() -> sService.registerPollingLoopFilterForService(this.mContext.getUser().getIdentifier(), service, pollingLoopFilterV, autoTransact), false);
    }

    public boolean removePollingLoopFilterForService(@NonNull ComponentName service, @NonNull String pollingLoopFilter) {
        String pollingLoopFilterV = CardEmulation.validatePollingLoopFilter(pollingLoopFilter);
        return CardEmulation.callServiceReturn(() -> sService.removePollingLoopFilterForService(this.mContext.getUser().getIdentifier(), service, pollingLoopFilterV), false);
    }

    @NonNull
    @FlaggedApi(value="com.android.nfc.module.flags.get_polling_loop_filters")
    public List<String> getPollingLoopFiltersForService(@NonNull ComponentName service) {
        return CardEmulation.callServiceReturn(() -> sService.getPollingLoopFiltersForService(this.mContext.getUser().getIdentifier(), service), List.of());
    }

    public boolean registerPollingLoopPatternFilterForService(@NonNull ComponentName service, @NonNull String pollingLoopPatternFilter, boolean autoTransact) {
        String pollingLoopPatternFilterV = CardEmulation.validatePollingLoopPatternFilter(pollingLoopPatternFilter);
        return CardEmulation.callServiceReturn(() -> sService.registerPollingLoopPatternFilterForService(this.mContext.getUser().getIdentifier(), service, pollingLoopPatternFilterV, autoTransact), false);
    }

    public boolean removePollingLoopPatternFilterForService(@NonNull ComponentName service, @NonNull String pollingLoopPatternFilter) {
        String pollingLoopPatternFilterV = CardEmulation.validatePollingLoopPatternFilter(pollingLoopPatternFilter);
        return CardEmulation.callServiceReturn(() -> sService.removePollingLoopPatternFilterForService(this.mContext.getUser().getIdentifier(), service, pollingLoopPatternFilterV), false);
    }

    @NonNull
    @FlaggedApi(value="com.android.nfc.module.flags.get_polling_loop_filters")
    public List<String> getPollingLoopPatternFiltersForService(@NonNull ComponentName service) {
        return CardEmulation.callServiceReturn(() -> sService.getPollingLoopPatternFiltersForService(this.mContext.getUser().getIdentifier(), service), List.of());
    }

    public boolean registerAidsForService(ComponentName service, String category, List<String> aids) {
        AidGroup aidGroup = new AidGroup(aids, category);
        return CardEmulation.callServiceReturn(() -> sService.registerAidGroupForService(this.mContext.getUser().getIdentifier(), service, aidGroup), false);
    }

    @RequiresPermission(value="android.permission.NFC")
    @NonNull
    public boolean unsetOffHostForService(@NonNull ComponentName service) {
        return CardEmulation.callServiceReturn(() -> sService.unsetOffHostForService(this.mContext.getUser().getIdentifier(), service), false);
    }

    @RequiresPermission(value="android.permission.NFC")
    @NonNull
    public boolean setOffHostForService(@NonNull ComponentName service, @NonNull String offHostSecureElement) {
        NfcAdapter adapter = NfcAdapter.getDefaultAdapter(this.mContext);
        if (adapter == null || offHostSecureElement == null) {
            return false;
        }
        List<String> validSE = adapter.getSupportedOffHostSecureElements();
        if (offHostSecureElement.startsWith("eSE") && !validSE.contains("eSE") || offHostSecureElement.startsWith("SIM") && !validSE.contains("SIM")) {
            return false;
        }
        if (!offHostSecureElement.startsWith("eSE") && !offHostSecureElement.startsWith("SIM")) {
            return false;
        }
        if (offHostSecureElement.equals("eSE")) {
            offHostSecureElement = "eSE1";
        } else if (offHostSecureElement.equals("SIM")) {
            offHostSecureElement = "SIM1";
        }
        String offHostSecureElementV = new String(offHostSecureElement);
        return CardEmulation.callServiceReturn(() -> sService.setOffHostForService(this.mContext.getUser().getIdentifier(), service, offHostSecureElementV), false);
    }

    public List<String> getAidsForService(ComponentName service, String category) {
        AidGroup group = CardEmulation.callServiceReturn(() -> sService.getAidGroupForService(this.mContext.getUser().getIdentifier(), service, category), null);
        return group != null ? group.getAids() : null;
    }

    public boolean removeAidsForService(ComponentName service, String category) {
        return CardEmulation.callServiceReturn(() -> sService.removeAidGroupForService(this.mContext.getUser().getIdentifier(), service, category), false);
    }

    public boolean setPreferredService(Activity activity, ComponentName service) {
        if (activity == null || service == null) {
            throw new NullPointerException("activity or service or category is null");
        }
        return CardEmulation.callServiceReturn(() -> sService.setPreferredService(service), false);
    }

    public boolean unsetPreferredService(Activity activity) {
        if (activity == null) {
            throw new NullPointerException("activity is null");
        }
        return CardEmulation.callServiceReturn(() -> sService.unsetPreferredService(), false);
    }

    public boolean supportsAidPrefixRegistration() {
        return CardEmulation.callServiceReturn(() -> sService.supportsAidPrefixRegistration(), false);
    }

    @RequiresPermission(value="android.permission.NFC_PREFERRED_PAYMENT_INFO")
    @Nullable
    public List<String> getAidsForPreferredPaymentService() {
        ApduServiceInfo serviceInfo = CardEmulation.callServiceReturn(() -> sService.getPreferredPaymentService(this.mContext.getUser().getIdentifier()), null);
        return serviceInfo != null ? serviceInfo.getAids() : null;
    }

    @RequiresPermission(value="android.permission.NFC_PREFERRED_PAYMENT_INFO")
    @Nullable
    public String getRouteDestinationForPreferredPaymentService() {
        ApduServiceInfo serviceInfo = CardEmulation.callServiceReturn(() -> sService.getPreferredPaymentService(this.mContext.getUser().getIdentifier()), null);
        if (serviceInfo != null) {
            if (!serviceInfo.isOnHost()) {
                return serviceInfo.getOffHostSecureElement() == null ? "OffHost" : serviceInfo.getOffHostSecureElement();
            }
            return "Host";
        }
        return null;
    }

    @RequiresPermission(value="android.permission.NFC_PREFERRED_PAYMENT_INFO")
    @Nullable
    public CharSequence getDescriptionForPreferredPaymentService() {
        ApduServiceInfo serviceInfo = CardEmulation.callServiceReturn(() -> sService.getPreferredPaymentService(this.mContext.getUser().getIdentifier()), null);
        return serviceInfo != null ? serviceInfo.getDescription() : null;
    }

    public boolean setDefaultServiceForCategory(ComponentName service, String category) {
        return CardEmulation.callServiceReturn(() -> sService.setDefaultServiceForCategory(this.mContext.getUser().getIdentifier(), service, category), false);
    }

    public boolean setDefaultForNextTap(ComponentName service) {
        return CardEmulation.callServiceReturn(() -> sService.setDefaultForNextTap(this.mContext.getUser().getIdentifier(), service), false);
    }

    public boolean setDefaultForNextTap(int userId, ComponentName service) {
        return CardEmulation.callServiceReturn(() -> sService.setDefaultForNextTap(userId, service), false);
    }

    public List<ApduServiceInfo> getServices(String category) {
        return CardEmulation.callServiceReturn(() -> sService.getServices(this.mContext.getUser().getIdentifier(), category), null);
    }

    @SystemApi
    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public List<ApduServiceInfo> getServices(@NonNull String category, int userId) {
        return CardEmulation.callServiceReturn(() -> sService.getServices(userId, category), null);
    }

    @NonNull
    public static String validatePollingLoopFilter(@NonNull String pollingLoopFilter) {
        byte[] plfBytes = HexFormat.of().parseHex(pollingLoopFilter);
        if (plfBytes.length == 0) {
            throw new IllegalArgumentException("Polling loop filter must contain at least one byte.");
        }
        return HexFormat.of().withUpperCase().formatHex(plfBytes);
    }

    @NonNull
    public static String validatePollingLoopPatternFilter(@NonNull String pollingLoopPatternFilter) {
        if (!PLPF_PATTERN.matcher(pollingLoopPatternFilter).matches()) {
            throw new IllegalArgumentException("Polling loop pattern filters may only contain hexadecimal numbers, ?s and *s");
        }
        return ((Object)Pattern.compile(pollingLoopPatternFilter.toUpperCase(Locale.ROOT))).toString();
    }

    public static boolean isValidAid(String aid) {
        if (aid == null) {
            return false;
        }
        if ((aid.endsWith("*") || aid.endsWith("#")) && aid.length() % 2 == 0) {
            Log.e(TAG, "AID " + aid + " is not a valid AID.");
            return false;
        }
        if (!aid.endsWith("*") && !aid.endsWith("#") && aid.length() % 2 != 0) {
            Log.e(TAG, "AID " + aid + " is not a valid AID.");
            return false;
        }
        if (!AID_PATTERN.matcher(aid).matches()) {
            Log.e(TAG, "AID " + aid + " is not a valid AID.");
            return false;
        }
        return true;
    }

    @SystemApi
    @FlaggedApi(value="android.nfc.nfc_set_service_enabled_for_category_other")
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public int setServiceEnabledForCategoryOther(@NonNull ComponentName service, boolean status) {
        return this.setServiceEnabledForCategoryOther(service, this.mContext.getUser().getIdentifier(), status);
    }

    public int setServiceEnabledForCategoryOther(@NonNull ComponentName service, int userId, boolean status) {
        return CardEmulation.callServiceReturn(() -> sService.setServiceEnabledForCategoryOther(userId, service, status), 4);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    @FlaggedApi(value="android.nfc.nfc_override_recover_routing_table")
    public void overrideRoutingTable(@NonNull Activity activity, int protocol, int technology) {
        if (!activity.isResumed()) {
            throw new IllegalArgumentException("Activity must be resumed.");
        }
        String protocolRoute = CardEmulation.routeIntToString(protocol);
        String technologyRoute = CardEmulation.routeIntToString(technology);
        CardEmulation.callService(() -> sService.overrideRoutingTable(this.mContext.getUser().getIdentifier(), protocolRoute, technologyRoute, this.mContext.getPackageName()));
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    @FlaggedApi(value="android.nfc.nfc_override_recover_routing_table")
    public void recoverRoutingTable(@NonNull Activity activity) {
        if (!activity.isResumed()) {
            throw new IllegalArgumentException("Activity must be resumed.");
        }
        CardEmulation.callService(() -> sService.recoverRoutingTable(this.mContext.getUser().getIdentifier()));
    }

    @FlaggedApi(value="android.nfc.enable_card_emulation_euicc")
    public boolean isEuiccSupported() {
        return CardEmulation.callServiceReturn(() -> sService.isEuiccSupported(), false);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    @FlaggedApi(value="android.nfc.enable_card_emulation_euicc")
    public int setDefaultNfcSubscriptionId(int subscriptionId) {
        return CardEmulation.callServiceReturn(() -> sService.setDefaultNfcSubscriptionId(subscriptionId, this.mContext.getPackageName()), 2);
    }

    @FlaggedApi(value="android.nfc.enable_card_emulation_euicc")
    public int getDefaultNfcSubscriptionId() {
        return CardEmulation.callServiceReturn(() -> sService.getDefaultNfcSubscriptionId(this.mContext.getPackageName()), -1);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NFC_PREFERRED_PAYMENT_INFO")
    @FlaggedApi(value="com.android.nfc.x.android.permission.flags.wallet_role_enabled")
    @Nullable
    public static ComponentName getPreferredPaymentService(@NonNull Context context) {
        context.checkCallingOrSelfPermission("android.permission.NFC_PREFERRED_PAYMENT_INFO");
        String defaultPaymentComponent = Settings.Secure.getString(context.getContentResolver(), "nfc_payment_default_component");
        if (defaultPaymentComponent == null) {
            return null;
        }
        return ComponentName.unflattenFromString(defaultPaymentComponent);
    }

    public static void callService(ServiceCall call) {
        try {
            if (sService == null) {
                NfcAdapter.attemptDeadServiceRecovery(new RemoteException("NFC CardEmulation Service is null"));
                sService = NfcAdapter.getCardEmulationService();
            }
            call.call();
        }
        catch (RemoteException e) {
            NfcAdapter.attemptDeadServiceRecovery(e);
            sService = NfcAdapter.getCardEmulationService();
            try {
                call.call();
            }
            catch (RemoteException ee) {
                ee.rethrowAsRuntimeException();
            }
        }
    }

    public static <T> T callServiceReturn(ServiceCallReturn<T> call, T defaultReturn) {
        try {
            if (sService == null) {
                NfcAdapter.attemptDeadServiceRecovery(new RemoteException("NFC CardEmulation Service is null"));
                sService = NfcAdapter.getCardEmulationService();
            }
            return call.call();
        }
        catch (RemoteException e) {
            NfcAdapter.attemptDeadServiceRecovery(e);
            sService = NfcAdapter.getCardEmulationService();
            try {
                return call.call();
            }
            catch (RemoteException ee) {
                ee.rethrowAsRuntimeException();
                return defaultReturn;
            }
        }
    }

    public static String routeIntToString(int route) {
        String string2;
        switch (route) {
            case 0: {
                string2 = "DH";
                break;
            }
            case 1: {
                string2 = "eSE";
                break;
            }
            case 2: {
                string2 = "SIM";
                break;
            }
            case -1: {
                string2 = null;
                break;
            }
            case 3: {
                string2 = "default";
                break;
            }
            case 4: {
                string2 = "NDEF-NFCEE";
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + route);
            }
        }
        return string2;
    }

    private void linkToNfcDeath() {
        try {
            this.mDeathRecipient = new IBinder.DeathRecipient(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void binderDied() {
                    ArrayMap<NfcEventCallback, Executor> arrayMap = CardEmulation.this.mNfcEventCallbacks;
                    synchronized (arrayMap) {
                        CardEmulation.this.mDeathRecipient = null;
                        sService = null;
                    }
                    final Handler handler = new Handler(Looper.getMainLooper());
                    handler.postDelayed(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                ArrayMap<NfcEventCallback, Executor> arrayMap = CardEmulation.this.mNfcEventCallbacks;
                                synchronized (arrayMap) {
                                    if (CardEmulation.this.mNfcEventCallbacks.size() > 0) {
                                        CardEmulation.callService(() -> sService.registerNfcEventCallback(CardEmulation.this.mINfcEventCallback));
                                    }
                                }
                            }
                            catch (Throwable t) {
                                handler.postDelayed(this, 50L);
                            }
                        }
                    }, 50L);
                }
            };
            sService.asBinder().linkToDeath(this.mDeathRecipient, 0);
        }
        catch (RemoteException re) {
            Log.e(TAG, "Couldn't link to death");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="android.nfc.nfc_event_listener")
    public void registerNfcEventCallback(@NonNull Executor executor, @NonNull NfcEventCallback callback) {
        if (!Flags.nfcEventListener()) {
            return;
        }
        ArrayMap<NfcEventCallback, Executor> arrayMap = this.mNfcEventCallbacks;
        synchronized (arrayMap) {
            this.mNfcEventCallbacks.put(callback, executor);
            if (this.mNfcEventCallbacks.size() == 1) {
                CardEmulation.callService(() -> sService.registerNfcEventCallback(this.mINfcEventCallback));
                this.linkToNfcDeath();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="android.nfc.nfc_event_listener")
    public void unregisterNfcEventCallback(@NonNull NfcEventCallback callback) {
        if (!Flags.nfcEventListener()) {
            return;
        }
        ArrayMap<NfcEventCallback, Executor> arrayMap = this.mNfcEventCallbacks;
        synchronized (arrayMap) {
            this.mNfcEventCallbacks.remove(callback);
            if (this.mNfcEventCallbacks.size() == 0) {
                CardEmulation.callService(() -> sService.unregisterNfcEventCallback(this.mINfcEventCallback));
                if (this.mDeathRecipient != null) {
                    sService.asBinder().unlinkToDeath(this.mDeathRecipient, 0);
                    this.mDeathRecipient = null;
                }
            }
        }
    }

    static interface ServiceCallReturn<T> {
        public T call() throws RemoteException;
    }

    static interface ServiceCall {
        public void call() throws RemoteException;
    }

    @FlaggedApi(value="android.nfc.nfc_event_listener")
    public static interface NfcEventCallback {
        @FlaggedApi(value="android.nfc.nfc_event_listener")
        default public void onPreferredServiceChanged(boolean isPreferred) {
        }

        @FlaggedApi(value="android.nfc.nfc_event_listener")
        default public void onObserveModeStateChanged(boolean isEnabled) {
        }

        @FlaggedApi(value="android.nfc.nfc_event_listener")
        default public void onObserveModeDisabledInFirmware(@Nullable PollingFrame exitFrame) {
        }

        @FlaggedApi(value="android.nfc.nfc_event_listener")
        default public void onAidConflictOccurred(@NonNull String aid) {
        }

        @FlaggedApi(value="android.nfc.nfc_event_listener")
        default public void onAidNotRouted(@NonNull String aid) {
        }

        @FlaggedApi(value="android.nfc.nfc_event_listener")
        default public void onNfcStateChanged(int state) {
        }

        @FlaggedApi(value="android.nfc.nfc_event_listener")
        default public void onRemoteFieldChanged(boolean isDetected) {
        }

        @FlaggedApi(value="android.nfc.nfc_event_listener")
        default public void onInternalErrorReported(int errorType) {
        }

        @FlaggedApi(value="com.android.nfc.module.flags.event_listener_offhost_aid_selected")
        default public void onOffHostAidSelected(@NonNull String aid, @NonNull String offHostSecureElement) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @FlaggedApi(value="android.nfc.nfc_event_listener")
    public static @interface NfcInternalErrorType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SetSubscriptionIdStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProtocolAndTechnologyRoute {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SetServiceEnabledStatusCode {
    }
}

