/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.nfc.Tag;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;

@SystemApi
@FlaggedApi(value="android.nfc.nfc_oem_extension")
public class OemLogItems
implements Parcelable {
    public static final int LOG_ACTION_RF_FIELD_STATE_CHANGED = 1;
    public static final int LOG_ACTION_NFC_TOGGLE = 513;
    public static final int LOG_ACTION_HCE_DATA = 516;
    public static final int LOG_ACTION_SCREEN_STATE_CHANGED = 518;
    public static final int LOG_ACTION_TAG_DETECTED = 3;
    public static final int EVENT_UNSET = 0;
    public static final int EVENT_ENABLE = 1;
    public static final int EVENT_DISABLE = 2;
    private int mAction;
    private int mEvent;
    private int mCallingPid;
    private byte[] mCommandApdus;
    private byte[] mResponseApdus;
    private Instant mRfFieldOnTime;
    private Tag mTag;
    @NonNull
    public static final Parcelable.Creator<OemLogItems> CREATOR = new Parcelable.Creator<OemLogItems>(){

        @Override
        public OemLogItems createFromParcel(Parcel in) {
            return new OemLogItems(in);
        }

        public OemLogItems[] newArray(int size) {
            return new OemLogItems[size];
        }
    };

    public OemLogItems(int action, int event, int callingPid, byte[] commandApdus, byte[] responseApdus, Instant rfFieldOnTime, Tag tag) {
        this.mAction = action;
        this.mEvent = event;
        this.mTag = tag;
        this.mCallingPid = callingPid;
        this.mCommandApdus = commandApdus;
        this.mResponseApdus = responseApdus;
        this.mRfFieldOnTime = rfFieldOnTime;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mAction);
        dest.writeInt(this.mEvent);
        dest.writeInt(this.mCallingPid);
        dest.writeInt(this.mCommandApdus.length);
        dest.writeByteArray(this.mCommandApdus);
        dest.writeInt(this.mResponseApdus.length);
        dest.writeByteArray(this.mResponseApdus);
        dest.writeBoolean(this.mRfFieldOnTime != null);
        if (this.mRfFieldOnTime != null) {
            dest.writeLong(this.mRfFieldOnTime.getEpochSecond());
            dest.writeInt(this.mRfFieldOnTime.getNano());
        }
        dest.writeParcelable(this.mTag, 0);
    }

    public int getAction() {
        return this.mAction;
    }

    public int getEvent() {
        return this.mEvent;
    }

    public int getCallingPid() {
        return this.mCallingPid;
    }

    @Nullable
    public byte[] getCommandApdu() {
        return this.mCommandApdus;
    }

    @Nullable
    public byte[] getResponseApdu() {
        return this.mResponseApdus;
    }

    @Nullable
    public Instant getRfFieldEventTimeMillis() {
        return this.mRfFieldOnTime;
    }

    @Nullable
    public Tag getTag() {
        return this.mTag;
    }

    private String byteToHex(byte[] bytes) {
        char[] HexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HexArray[v >>> 4];
            hexChars[j * 2 + 1] = HexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public String toString() {
        return "[mCommandApdus: " + (this.mCommandApdus != null ? this.byteToHex(this.mCommandApdus) : "null") + "[mResponseApdus: " + (this.mResponseApdus != null ? this.byteToHex(this.mResponseApdus) : "null") + ", mCallingApi= " + this.mEvent + ", mAction= " + this.mAction + ", mCallingPId = " + this.mCallingPid + ", mRfFieldOnTime= " + this.mRfFieldOnTime;
    }

    private OemLogItems(Parcel in) {
        this.mAction = in.readInt();
        this.mEvent = in.readInt();
        this.mCallingPid = in.readInt();
        this.mCommandApdus = new byte[in.readInt()];
        in.readByteArray(this.mCommandApdus);
        this.mResponseApdus = new byte[in.readInt()];
        in.readByteArray(this.mResponseApdus);
        boolean isRfFieldOnTimeSet = in.readBoolean();
        this.mRfFieldOnTime = isRfFieldOnTimeSet ? Instant.ofEpochSecond(in.readLong(), in.readInt()) : null;
        this.mTag = in.readParcelable(Tag.class.getClassLoader(), Tag.class);
    }

    public static class Builder {
        private final OemLogItems mItem;

        public Builder(int type) {
            this.mItem = new OemLogItems(type, 0, 0, new byte[0], new byte[0], null, null);
        }

        public Builder setAction(int action) {
            this.mItem.mAction = action;
            return this;
        }

        public Builder setCallingEvent(int event) {
            this.mItem.mEvent = event;
            return this;
        }

        public Builder setCallingPid(int pid) {
            this.mItem.mCallingPid = pid;
            return this;
        }

        public Builder setApduCommand(byte[] apdus) {
            this.mItem.mCommandApdus = apdus;
            return this;
        }

        public Builder setRfFieldOnTime(Instant time) {
            this.mItem.mRfFieldOnTime = time;
            return this;
        }

        public Builder setApduResponse(byte[] apdus) {
            this.mItem.mResponseApdus = apdus;
            return this;
        }

        public Builder setTag(Tag tag) {
            this.mItem.mTag = tag;
            return this;
        }

        public OemLogItems build() {
            return this.mItem;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LogEvent {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LogAction {
    }
}

