/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.app.SystemServiceRegistry;
import android.nfc.NfcManager;
import android.nfc.NfcServiceManager;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class NfcFrameworkInitializer {
    private static volatile NfcServiceManager sNfcServiceManager;

    private NfcFrameworkInitializer() {
    }

    public static void setNfcServiceManager(@NonNull NfcServiceManager nfcServiceManager) {
        if (sNfcServiceManager != null) {
            throw new IllegalStateException("setNfcServiceManager called twice!");
        }
        if (nfcServiceManager == null) {
            throw new IllegalArgumentException("nfcServiceManager must not be null");
        }
        sNfcServiceManager = nfcServiceManager;
    }

    public static NfcServiceManager getNfcServiceManager() {
        return sNfcServiceManager;
    }

    public static void registerServiceWrappers() {
        SystemServiceRegistry.registerContextAwareService("nfc", NfcManager.class, context -> new NfcManager(context));
    }
}

