/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.app.Activity;
import android.app.Application;
import android.compat.annotation.UnsupportedAppUsage;
import android.nfc.IAppCallback;
import android.nfc.NfcActivityState;
import android.nfc.NfcAdapter;
import android.nfc.NfcApplicationState;
import android.nfc.Tag;
import android.os.Binder;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class NfcActivityManager
extends IAppCallback.Stub
implements Application.ActivityLifecycleCallbacks {
    static final String TAG = "NFC";
    static final Boolean DBG = false;
    @UnsupportedAppUsage
    final NfcAdapter mAdapter;
    final List<NfcApplicationState> mApps;
    final List<NfcActivityState> mActivities;

    public NfcApplicationState findAppState(Application app) {
        for (NfcApplicationState appState : this.mApps) {
            if (appState.app != app) continue;
            return appState;
        }
        return null;
    }

    public void registerApplication(Application app) {
        NfcApplicationState appState = this.findAppState(app);
        if (appState == null) {
            appState = new NfcApplicationState(app, this);
            this.mApps.add(appState);
        }
        appState.register();
    }

    public void unregisterApplication(Application app) {
        NfcApplicationState appState = this.findAppState(app);
        if (appState == null) {
            Log.e(TAG, "unregisterApplication: app was not registered " + app);
            return;
        }
        appState.unregister();
    }

    public synchronized NfcActivityState findActivityState(Activity activity) {
        for (NfcActivityState state : this.mActivities) {
            if (state.activity != activity) continue;
            return state;
        }
        return null;
    }

    public synchronized NfcActivityState getActivityState(Activity activity) {
        NfcActivityState state = this.findActivityState(activity);
        if (state == null) {
            state = new NfcActivityState(activity, this);
            this.mActivities.add(state);
        }
        return state;
    }

    public synchronized NfcActivityState findResumedActivityState() {
        for (NfcActivityState state : this.mActivities) {
            if (!state.resumed) continue;
            return state;
        }
        return null;
    }

    public synchronized void destroyActivityState(Activity activity) {
        NfcActivityState activityState = this.findActivityState(activity);
        if (activityState != null) {
            activityState.destroy();
            this.mActivities.remove(activityState);
        }
    }

    public NfcActivityManager(NfcAdapter adapter) {
        this.mAdapter = adapter;
        this.mActivities = new LinkedList<NfcActivityState>();
        this.mApps = new ArrayList<NfcApplicationState>(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableReaderMode(Activity activity, NfcAdapter.ReaderCallback callback, int flags, Bundle extras) {
        boolean isResumed;
        Binder token;
        int listenTech;
        int pollTech;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.getActivityState(activity);
            state.readerCallback = callback;
            state.readerModeFlags = flags;
            state.readerModeExtras = extras;
            pollTech = state.mPollTech;
            listenTech = state.mListenTech;
            token = state.token;
            isResumed = state.resumed;
        }
        if (isResumed) {
            if (listenTech != 255 || pollTech != 255) {
                throw new IllegalStateException("Cannot be used when alternative DiscoveryTechnology is set");
            }
            this.setReaderMode(token, flags, extras);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableReaderMode(Activity activity) {
        boolean isResumed;
        Binder token;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.getActivityState(activity);
            state.readerCallback = null;
            state.readerModeFlags = 0;
            state.readerModeExtras = null;
            token = state.token;
            isResumed = state.resumed;
        }
        if (isResumed) {
            this.setReaderMode(token, 0, null);
        }
    }

    public void setReaderMode(Binder token, int flags, Bundle extras) {
        if (DBG.booleanValue()) {
            Log.d(TAG, "setReaderModee");
        }
        NfcAdapter.callService(() -> NfcAdapter.sService.setReaderMode(token, this, flags, extras, this.mAdapter.getContext().getPackageName()));
    }

    void requestNfcServiceCallback() {
        NfcAdapter.callService(() -> NfcAdapter.sService.setAppCallback(this));
    }

    void verifyNfcPermission() {
        NfcAdapter.callService(() -> NfcAdapter.sService.verifyNfcPermission());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTagDiscovered(Tag tag) throws RemoteException {
        NfcAdapter.ReaderCallback callback;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.findResumedActivityState();
            if (state == null) {
                return;
            }
            callback = state.readerCallback;
        }
        if (callback != null) {
            callback.onTagDiscovered(tag);
        }
    }

    @Override
    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    @Override
    public void onActivityStarted(Activity activity) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onActivityResumed(Activity activity) {
        int listenTech;
        int pollTech;
        Binder token;
        int readerModeFlags = 0;
        Bundle readerModeExtras = null;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.findActivityState(activity);
            if (DBG.booleanValue()) {
                Log.d(TAG, "onActivityResumed: " + activity + " " + state);
            }
            if (state == null) {
                return;
            }
            state.resumed = true;
            token = state.token;
            readerModeFlags = state.readerModeFlags;
            readerModeExtras = state.readerModeExtras;
            pollTech = state.mPollTech;
            listenTech = state.mListenTech;
        }
        if (readerModeFlags != 0) {
            this.setReaderMode(token, readerModeFlags, readerModeExtras);
        } else if (listenTech != 255 || pollTech != 255) {
            this.changeDiscoveryTech(token, pollTech, listenTech);
        }
        this.requestNfcServiceCallback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onActivityPaused(Activity activity) {
        int listenTech;
        int pollTech;
        boolean readerModeFlagsSet;
        Binder token;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.findActivityState(activity);
            if (DBG.booleanValue()) {
                Log.d(TAG, "onActivityPaused: " + activity + " " + state);
            }
            if (state == null) {
                return;
            }
            state.resumed = false;
            token = state.token;
            readerModeFlagsSet = state.readerModeFlags != 0;
            pollTech = state.mPollTech;
            listenTech = state.mListenTech;
        }
        if (readerModeFlagsSet) {
            this.setReaderMode(token, 0, null);
        } else if (listenTech != 255 || pollTech != 255) {
            this.changeDiscoveryTech(token, 255, 255);
        }
    }

    @Override
    public void onActivityStopped(Activity activity) {
    }

    @Override
    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onActivityDestroyed(Activity activity) {
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.findActivityState(activity);
            if (DBG.booleanValue()) {
                Log.d(TAG, "onActivityDestroyed: " + activity + " " + state);
            }
            if (state != null) {
                this.destroyActivityState(activity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiscoveryTech(Activity activity, int pollTech, int listenTech) {
        boolean isResumed;
        Binder token;
        boolean readerModeFlagsSet;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.getActivityState(activity);
            readerModeFlagsSet = state.readerModeFlags != 0;
            state.mListenTech = listenTech;
            state.mPollTech = pollTech;
            token = state.token;
            isResumed = state.resumed;
        }
        if (!readerModeFlagsSet && isResumed) {
            this.changeDiscoveryTech(token, pollTech, listenTech);
        } else if (readerModeFlagsSet) {
            throw new IllegalStateException("Cannot be used when the Reader Mode is enabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDiscoveryTech(Activity activity) {
        boolean isResumed;
        Binder token;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.getActivityState(activity);
            state.mListenTech = 255;
            state.mPollTech = 255;
            token = state.token;
            isResumed = state.resumed;
        }
        if (isResumed) {
            this.changeDiscoveryTech(token, 255, 255);
        }
    }

    private void changeDiscoveryTech(Binder token, int pollTech, int listenTech) {
        NfcAdapter.callService(() -> NfcAdapter.sService.updateDiscoveryTechnology(token, pollTech, listenTech, this.mAdapter.getContext().getPackageName()));
    }
}

