/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.content.ComponentName;
import android.nfc.cardemulation.NfcFServiceInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface INfcFCardEmulation
extends IInterface {
    public String getSystemCodeForService(int var1, ComponentName var2) throws RemoteException;

    public boolean registerSystemCodeForService(int var1, ComponentName var2, String var3) throws RemoteException;

    public boolean removeSystemCodeForService(int var1, ComponentName var2) throws RemoteException;

    public String getNfcid2ForService(int var1, ComponentName var2) throws RemoteException;

    public boolean setNfcid2ForService(int var1, ComponentName var2, String var3) throws RemoteException;

    public boolean enableNfcFForegroundService(ComponentName var1) throws RemoteException;

    public boolean disableNfcFForegroundService() throws RemoteException;

    public List<NfcFServiceInfo> getNfcFServices(int var1) throws RemoteException;

    public int getMaxNumOfRegisterableSystemCodes() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INfcFCardEmulation {
        public static final String DESCRIPTOR = "android.nfc.INfcFCardEmulation";
        static final int TRANSACTION_getSystemCodeForService = 1;
        static final int TRANSACTION_registerSystemCodeForService = 2;
        static final int TRANSACTION_removeSystemCodeForService = 3;
        static final int TRANSACTION_getNfcid2ForService = 4;
        static final int TRANSACTION_setNfcid2ForService = 5;
        static final int TRANSACTION_enableNfcFForegroundService = 6;
        static final int TRANSACTION_disableNfcFForegroundService = 7;
        static final int TRANSACTION_getNfcFServices = 8;
        static final int TRANSACTION_getMaxNumOfRegisterableSystemCodes = 9;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static INfcFCardEmulation asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof INfcFCardEmulation) {
                return (INfcFCardEmulation)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getSystemCodeForService";
                }
                case 2: {
                    return "registerSystemCodeForService";
                }
                case 3: {
                    return "removeSystemCodeForService";
                }
                case 4: {
                    return "getNfcid2ForService";
                }
                case 5: {
                    return "setNfcid2ForService";
                }
                case 6: {
                    return "enableNfcFForegroundService";
                }
                case 7: {
                    return "disableNfcFForegroundService";
                }
                case 8: {
                    return "getNfcFServices";
                }
                case 9: {
                    return "getMaxNumOfRegisterableSystemCodes";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    String _result = this.getSystemCodeForService(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.registerSystemCodeForService(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.removeSystemCodeForService(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    String _result = this.getNfcid2ForService(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.setNfcid2ForService(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 6: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.enableNfcFForegroundService(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 7: {
                    boolean _result = this.disableNfcFForegroundService();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<NfcFServiceInfo> _result = this.getNfcFServices(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 9: {
                    int _result = this.getMaxNumOfRegisterableSystemCodes();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 8;
        }

        private static class Proxy
        implements INfcFCardEmulation {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getSystemCodeForService(int userHandle, ComponentName service) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    _data.writeTypedObject(service, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerSystemCodeForService(int userHandle, ComponentName service, String systemCode) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    _data.writeTypedObject(service, 0);
                    _data.writeString(systemCode);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeSystemCodeForService(int userHandle, ComponentName service) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    _data.writeTypedObject(service, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getNfcid2ForService(int userHandle, ComponentName service) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    _data.writeTypedObject(service, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setNfcid2ForService(int userHandle, ComponentName service, String nfcid2) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    _data.writeTypedObject(service, 0);
                    _data.writeString(nfcid2);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enableNfcFForegroundService(ComponentName service) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(service, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean disableNfcFForegroundService() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<NfcFServiceInfo> getNfcFServices(int userHandle) throws RemoteException {
                ArrayList<NfcFServiceInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(NfcFServiceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMaxNumOfRegisterableSystemCodes() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements INfcFCardEmulation {
        @Override
        public String getSystemCodeForService(int userHandle, ComponentName service) throws RemoteException {
            return null;
        }

        @Override
        public boolean registerSystemCodeForService(int userHandle, ComponentName service, String systemCode) throws RemoteException {
            return false;
        }

        @Override
        public boolean removeSystemCodeForService(int userHandle, ComponentName service) throws RemoteException {
            return false;
        }

        @Override
        public String getNfcid2ForService(int userHandle, ComponentName service) throws RemoteException {
            return null;
        }

        @Override
        public boolean setNfcid2ForService(int userHandle, ComponentName service, String nfcid2) throws RemoteException {
            return false;
        }

        @Override
        public boolean enableNfcFForegroundService(ComponentName service) throws RemoteException {
            return false;
        }

        @Override
        public boolean disableNfcFForegroundService() throws RemoteException {
            return false;
        }

        @Override
        public List<NfcFServiceInfo> getNfcFServices(int userHandle) throws RemoteException {
            return null;
        }

        @Override
        public int getMaxNumOfRegisterableSystemCodes() throws RemoteException {
            return 0;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

