/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.sharedconnectivity.app;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.res.Resources;
import android.net.wifi.sharedconnectivity.app.HotspotNetwork;
import android.net.wifi.sharedconnectivity.app.HotspotNetworkConnectionStatus;
import android.net.wifi.sharedconnectivity.app.KnownNetwork;
import android.net.wifi.sharedconnectivity.app.KnownNetworkConnectionStatus;
import android.net.wifi.sharedconnectivity.app.SharedConnectivityClientCallback;
import android.net.wifi.sharedconnectivity.app.SharedConnectivitySettingsState;
import android.net.wifi.sharedconnectivity.service.ISharedConnectivityCallback;
import android.net.wifi.sharedconnectivity.service.ISharedConnectivityService;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.os.UserManager;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

@SystemApi
public class SharedConnectivityManager {
    private static final String TAG = SharedConnectivityManager.class.getSimpleName();
    private static final boolean DEBUG = false;
    private ISharedConnectivityService mService;
    @GuardedBy(value={"mProxyDataLock"})
    private final Map<SharedConnectivityClientCallback, SharedConnectivityCallbackProxy> mProxyMap = new HashMap<SharedConnectivityClientCallback, SharedConnectivityCallbackProxy>();
    @GuardedBy(value={"mProxyDataLock"})
    private final Map<SharedConnectivityClientCallback, SharedConnectivityCallbackProxy> mCallbackProxyCache = new HashMap<SharedConnectivityClientCallback, SharedConnectivityCallbackProxy>();
    private final Object mProxyDataLock = new Object();
    private final Context mContext;
    private final String mServicePackageName;
    private final String mIntentAction;
    private ServiceConnection mServiceConnection;
    private UserManager mUserManager;
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            context.unregisterReceiver(SharedConnectivityManager.this.mBroadcastReceiver);
            SharedConnectivityManager.this.bind();
        }
    };

    @Nullable
    public static SharedConnectivityManager create(@NonNull Context context) {
        Resources resources = context.getResources();
        try {
            String servicePackageName = resources.getString(17040096);
            String serviceIntentAction = resources.getString(17040095);
            if (TextUtils.isEmpty(servicePackageName) || TextUtils.isEmpty(serviceIntentAction)) {
                Log.e(TAG, "To support shared connectivity service on this device, the service's package name and intent action strings must not be empty");
                return null;
            }
            return new SharedConnectivityManager(context, servicePackageName, serviceIntentAction);
        }
        catch (Resources.NotFoundException e) {
            Log.e(TAG, "To support shared connectivity service on this device, the service's package name and intent action strings must be defined");
            return null;
        }
    }

    @SuppressLint(value={"ManagerLookup"})
    @Nullable
    public static SharedConnectivityManager create(@NonNull Context context, @NonNull String servicePackageName, @NonNull String serviceIntentAction) {
        return new SharedConnectivityManager(context, servicePackageName, serviceIntentAction);
    }

    private SharedConnectivityManager(@NonNull Context context, String servicePackageName, String serviceIntentAction) {
        this.mContext = context;
        this.mServicePackageName = servicePackageName;
        this.mIntentAction = serviceIntentAction;
        this.mUserManager = context.getSystemService(UserManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind() {
        this.mServiceConnection = new ServiceConnection(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onServiceConnected(ComponentName name, IBinder service) {
                SharedConnectivityManager.this.mService = ISharedConnectivityService.Stub.asInterface(service);
                Object object = SharedConnectivityManager.this.mProxyDataLock;
                synchronized (object) {
                    if (!SharedConnectivityManager.this.mCallbackProxyCache.isEmpty()) {
                        SharedConnectivityManager.this.mCallbackProxyCache.keySet().forEach(callback -> SharedConnectivityManager.this.registerCallbackInternal((SharedConnectivityClientCallback)callback, SharedConnectivityManager.this.mCallbackProxyCache.get(callback)));
                        SharedConnectivityManager.this.mCallbackProxyCache.clear();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onServiceDisconnected(ComponentName name) {
                SharedConnectivityManager.this.mService = null;
                Object object = SharedConnectivityManager.this.mProxyDataLock;
                synchronized (object) {
                    if (!SharedConnectivityManager.this.mCallbackProxyCache.isEmpty()) {
                        SharedConnectivityManager.this.mCallbackProxyCache.values().forEach(SharedConnectivityCallbackProxy::onServiceDisconnected);
                        SharedConnectivityManager.this.mCallbackProxyCache.clear();
                    }
                    if (!SharedConnectivityManager.this.mProxyMap.isEmpty()) {
                        SharedConnectivityManager.this.mProxyMap.values().forEach(SharedConnectivityCallbackProxy::onServiceDisconnected);
                        SharedConnectivityManager.this.mProxyMap.clear();
                    }
                }
            }
        };
        boolean result = this.mContext.bindService(new Intent().setPackage(this.mServicePackageName).setAction(this.mIntentAction), this.mServiceConnection, 1);
        if (!result) {
            this.mServiceConnection = null;
            if (this.mUserManager != null && !this.mUserManager.isUserUnlocked()) {
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.intent.action.USER_UNLOCKED");
                this.mContext.registerReceiver(this.mBroadcastReceiver, intentFilter);
            } else {
                Object object = this.mProxyDataLock;
                synchronized (object) {
                    if (!this.mCallbackProxyCache.isEmpty()) {
                        this.mCallbackProxyCache.keySet().forEach(callback -> callback.onRegisterCallbackFailed(new IllegalStateException("Failed to bind after user unlock")));
                        this.mCallbackProxyCache.clear();
                    }
                }
            }
        }
    }

    @NonNull
    @SuppressLint(value={"UnflaggedApi"})
    public BroadcastReceiver getBroadcastReceiver() {
        return this.mBroadcastReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCallbackInternal(SharedConnectivityClientCallback callback, SharedConnectivityCallbackProxy proxy) {
        try {
            this.mService.registerCallback(proxy);
            Object object = this.mProxyDataLock;
            synchronized (object) {
                this.mProxyMap.put(callback, proxy);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Exception in registerCallback", e);
            callback.onRegisterCallbackFailed(e);
        }
    }

    public void setService(@Nullable IInterface service) {
        this.mService = (ISharedConnectivityService)service;
    }

    @Nullable
    public ServiceConnection getServiceConnection() {
        return this.mServiceConnection;
    }

    private void unbind() {
        if (this.mServiceConnection != null) {
            this.mContext.unbindService(this.mServiceConnection);
            this.mServiceConnection = null;
            this.mService = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public void registerCallback(@NonNull Executor executor, @NonNull SharedConnectivityClientCallback callback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        if (this.mProxyMap.containsKey(callback) || this.mCallbackProxyCache.containsKey(callback)) {
            Log.e(TAG, "Callback already registered");
            callback.onRegisterCallbackFailed(new IllegalStateException("Callback already registered"));
            return;
        }
        SharedConnectivityCallbackProxy proxy = new SharedConnectivityCallbackProxy(executor, callback);
        if (this.mService == null) {
            boolean shouldBind;
            Object object = this.mProxyDataLock;
            synchronized (object) {
                shouldBind = this.mCallbackProxyCache.size() == 0;
                this.mCallbackProxyCache.put(callback, proxy);
            }
            if (shouldBind) {
                this.bind();
            }
            return;
        }
        this.registerCallbackInternal(callback, proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public boolean unregisterCallback(@NonNull SharedConnectivityClientCallback callback) {
        Objects.requireNonNull(callback, "callback cannot be null");
        if (!this.mProxyMap.containsKey(callback) && !this.mCallbackProxyCache.containsKey(callback)) {
            Log.e(TAG, "Callback not found, cannot unregister");
            return false;
        }
        try {
            this.mContext.unregisterReceiver(this.mBroadcastReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.mService == null) {
            boolean shouldUnbind;
            Object object = this.mProxyDataLock;
            synchronized (object) {
                this.mCallbackProxyCache.remove(callback);
                shouldUnbind = this.mCallbackProxyCache.isEmpty();
            }
            if (shouldUnbind) {
                this.unbind();
            }
            return true;
        }
        try {
            boolean shouldUnbind;
            Object object = this.mProxyDataLock;
            synchronized (object) {
                this.mService.unregisterCallback(this.mProxyMap.get(callback));
                this.mProxyMap.remove(callback);
                shouldUnbind = this.mProxyMap.isEmpty();
            }
            if (shouldUnbind) {
                this.unbind();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Exception in unregisterCallback", e);
            return false;
        }
        return true;
    }

    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public boolean connectHotspotNetwork(@NonNull HotspotNetwork network) {
        Objects.requireNonNull(network, "Hotspot network cannot be null");
        if (this.mService == null) {
            return false;
        }
        try {
            this.mService.connectHotspotNetwork(network);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Exception in connectHotspotNetwork", e);
            return false;
        }
        return true;
    }

    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public boolean disconnectHotspotNetwork(@NonNull HotspotNetwork network) {
        if (this.mService == null) {
            return false;
        }
        try {
            this.mService.disconnectHotspotNetwork(network);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Exception in disconnectHotspotNetwork", e);
            return false;
        }
        return true;
    }

    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public boolean connectKnownNetwork(@NonNull KnownNetwork network) {
        Objects.requireNonNull(network, "Known network cannot be null");
        if (this.mService == null) {
            return false;
        }
        try {
            this.mService.connectKnownNetwork(network);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Exception in connectKnownNetwork", e);
            return false;
        }
        return true;
    }

    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public boolean forgetKnownNetwork(@NonNull KnownNetwork network) {
        Objects.requireNonNull(network, "Known network cannot be null");
        if (this.mService == null) {
            return false;
        }
        try {
            this.mService.forgetKnownNetwork(network);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Exception in forgetKnownNetwork", e);
            return false;
        }
        return true;
    }

    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    @Nullable
    public List<HotspotNetwork> getHotspotNetworks() {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getHotspotNetworks();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Exception in getHotspotNetworks", e);
            return null;
        }
    }

    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    @Nullable
    public List<KnownNetwork> getKnownNetworks() {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getKnownNetworks();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Exception in getKnownNetworks", e);
            return null;
        }
    }

    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    @Nullable
    public SharedConnectivitySettingsState getSettingsState() {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getSettingsState();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Exception in getSettingsState", e);
            return null;
        }
    }

    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    @Nullable
    public HotspotNetworkConnectionStatus getHotspotNetworkConnectionStatus() {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getHotspotNetworkConnectionStatus();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Exception in getHotspotNetworkConnectionStatus", e);
            return null;
        }
    }

    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    @Nullable
    public KnownNetworkConnectionStatus getKnownNetworkConnectionStatus() {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getKnownNetworkConnectionStatus();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Exception in getKnownNetworkConnectionStatus", e);
            return null;
        }
    }

    private static class SharedConnectivityCallbackProxy
    extends ISharedConnectivityCallback.Stub {
        private final Executor mExecutor;
        private final SharedConnectivityClientCallback mCallback;

        SharedConnectivityCallbackProxy(@NonNull Executor executor, @NonNull SharedConnectivityClientCallback callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        @Override
        public void onServiceConnected() {
            if (this.mCallback != null) {
                long token = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mCallback.onServiceConnected());
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        }

        @Override
        public void onServiceDisconnected() {
            if (this.mCallback != null) {
                long token = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mCallback.onServiceDisconnected());
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onHotspotNetworksUpdated(@NonNull List<HotspotNetwork> networks) {
            if (this.mCallback != null) {
                long token = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mCallback.onHotspotNetworksUpdated(networks));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onKnownNetworksUpdated(@NonNull List<KnownNetwork> networks) {
            if (this.mCallback != null) {
                long token = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mCallback.onKnownNetworksUpdated(networks));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSharedConnectivitySettingsChanged(@NonNull SharedConnectivitySettingsState state) {
            if (this.mCallback != null) {
                long token = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mCallback.onSharedConnectivitySettingsChanged(state));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onHotspotNetworkConnectionStatusChanged(@NonNull HotspotNetworkConnectionStatus status) {
            if (this.mCallback != null) {
                long token = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mCallback.onHotspotNetworkConnectionStatusChanged(status));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onKnownNetworkConnectionStatusChanged(@NonNull KnownNetworkConnectionStatus status) {
            if (this.mCallback != null) {
                long token = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mCallback.onKnownNetworkConnectionStatusChanged(status));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        }
    }
}

