/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.sharedconnectivity.app;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.wifi.sharedconnectivity.app.NetworkProviderInfo;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.ArraySet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.Set;

@SystemApi
public class KnownNetwork
implements Parcelable {
    public static final int NETWORK_SOURCE_UNKNOWN = 0;
    public static final int NETWORK_SOURCE_NEARBY_SELF = 1;
    public static final int NETWORK_SOURCE_CLOUD_SELF = 2;
    private final int mNetworkSource;
    private final String mSsid;
    private final ArraySet<Integer> mSecurityTypes;
    private final NetworkProviderInfo mNetworkProviderInfo;
    private final Bundle mExtras;
    @NonNull
    public static final Parcelable.Creator<KnownNetwork> CREATOR = new Parcelable.Creator<KnownNetwork>(){

        @Override
        public KnownNetwork createFromParcel(Parcel in) {
            return KnownNetwork.readFromParcel(in);
        }

        public KnownNetwork[] newArray(int size) {
            return new KnownNetwork[size];
        }
    };

    private static void validate(int networkSource, String ssid, Set<Integer> securityTypes, NetworkProviderInfo networkProviderInfo) {
        if (networkSource != 0 && networkSource != 2 && networkSource != 1) {
            throw new IllegalArgumentException("Illegal network source");
        }
        if (TextUtils.isEmpty(ssid)) {
            throw new IllegalArgumentException("SSID must be set");
        }
        if (securityTypes.isEmpty()) {
            throw new IllegalArgumentException("SecurityTypes must be set");
        }
        if (networkSource == 1 && networkProviderInfo == null) {
            throw new IllegalArgumentException("Device info must be provided when network source is NETWORK_SOURCE_NEARBY_SELF");
        }
    }

    private KnownNetwork(int networkSource, @NonNull String ssid, @NonNull ArraySet<Integer> securityTypes, @Nullable NetworkProviderInfo networkProviderInfo, @NonNull Bundle extras) {
        KnownNetwork.validate(networkSource, ssid, securityTypes, networkProviderInfo);
        this.mNetworkSource = networkSource;
        this.mSsid = ssid;
        this.mSecurityTypes = new ArraySet<Integer>(securityTypes);
        this.mNetworkProviderInfo = networkProviderInfo;
        this.mExtras = extras;
    }

    public int getNetworkSource() {
        return this.mNetworkSource;
    }

    @NonNull
    public String getSsid() {
        return this.mSsid;
    }

    @NonNull
    public Set<Integer> getSecurityTypes() {
        return this.mSecurityTypes;
    }

    @Nullable
    public NetworkProviderInfo getNetworkProviderInfo() {
        return this.mNetworkProviderInfo;
    }

    @NonNull
    public Bundle getExtras() {
        return this.mExtras;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KnownNetwork)) {
            return false;
        }
        KnownNetwork other = (KnownNetwork)obj;
        return this.mNetworkSource == other.getNetworkSource() && Objects.equals(this.mSsid, other.getSsid()) && Objects.equals(this.mSecurityTypes, other.getSecurityTypes()) && Objects.equals(this.mNetworkProviderInfo, other.getNetworkProviderInfo());
    }

    public int hashCode() {
        return Objects.hash(this.mNetworkSource, this.mSsid, this.mSecurityTypes, this.mNetworkProviderInfo);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mNetworkSource);
        dest.writeString(this.mSsid);
        dest.writeArraySet(this.mSecurityTypes);
        if (this.mNetworkProviderInfo != null) {
            dest.writeBoolean(true);
            this.mNetworkProviderInfo.writeToParcel(dest, flags);
        } else {
            dest.writeBoolean(false);
        }
        dest.writeBundle(this.mExtras);
    }

    @NonNull
    public static KnownNetwork readFromParcel(@NonNull Parcel in) {
        int networkSource = in.readInt();
        String mSsid = in.readString();
        ArraySet<? extends Object> securityTypes = in.readArraySet(null);
        if (in.readBoolean()) {
            return new KnownNetwork(networkSource, mSsid, securityTypes, NetworkProviderInfo.readFromParcel(in), in.readBundle());
        }
        return new KnownNetwork(networkSource, mSsid, securityTypes, null, in.readBundle());
    }

    public String toString() {
        return "KnownNetwork[" + "NetworkSource=" + this.mNetworkSource + ", ssid=" + this.mSsid + ", securityTypes=" + this.mSecurityTypes.toString() + ", networkProviderInfo=" + this.mNetworkProviderInfo.toString() + ", extras=" + this.mExtras.toString() + "]";
    }

    public static class Builder {
        private int mNetworkSource = -1;
        private String mSsid;
        private final ArraySet<Integer> mSecurityTypes = new ArraySet();
        private NetworkProviderInfo mNetworkProviderInfo;
        private Bundle mExtras = Bundle.EMPTY;

        @NonNull
        public Builder setNetworkSource(int networkSource) {
            this.mNetworkSource = networkSource;
            return this;
        }

        @NonNull
        public Builder setSsid(@NonNull String ssid) {
            this.mSsid = ssid;
            return this;
        }

        @NonNull
        public Builder addSecurityType(int securityType) {
            this.mSecurityTypes.add(securityType);
            return this;
        }

        @NonNull
        public Builder setNetworkProviderInfo(@Nullable NetworkProviderInfo networkProviderInfo) {
            this.mNetworkProviderInfo = networkProviderInfo;
            return this;
        }

        @NonNull
        public Builder setExtras(@NonNull Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        @NonNull
        public KnownNetwork build() {
            return new KnownNetwork(this.mNetworkSource, this.mSsid, this.mSecurityTypes, this.mNetworkProviderInfo, this.mExtras);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NetworkSource {
    }
}

