/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.sharedconnectivity.app;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.net.wifi.sharedconnectivity.app.HotspotNetwork;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class HotspotNetworkConnectionStatus
implements Parcelable {
    public static final int CONNECTION_STATUS_UNKNOWN = 0;
    public static final int CONNECTION_STATUS_ENABLING_HOTSPOT = 1;
    public static final int CONNECTION_STATUS_UNKNOWN_ERROR = 2;
    public static final int CONNECTION_STATUS_PROVISIONING_FAILED = 3;
    public static final int CONNECTION_STATUS_TETHERING_TIMEOUT = 4;
    public static final int CONNECTION_STATUS_TETHERING_UNSUPPORTED = 5;
    public static final int CONNECTION_STATUS_NO_CELL_DATA = 6;
    public static final int CONNECTION_STATUS_ENABLING_HOTSPOT_FAILED = 7;
    public static final int CONNECTION_STATUS_ENABLING_HOTSPOT_TIMEOUT = 8;
    public static final int CONNECTION_STATUS_CONNECT_TO_HOTSPOT_FAILED = 9;
    private final int mStatus;
    private final HotspotNetwork mHotspotNetwork;
    private final Bundle mExtras;
    @NonNull
    public static final Parcelable.Creator<HotspotNetworkConnectionStatus> CREATOR = new Parcelable.Creator<HotspotNetworkConnectionStatus>(){

        @Override
        public HotspotNetworkConnectionStatus createFromParcel(Parcel in) {
            return HotspotNetworkConnectionStatus.readFromParcel(in);
        }

        public HotspotNetworkConnectionStatus[] newArray(int size) {
            return new HotspotNetworkConnectionStatus[size];
        }
    };

    private static void validate(int status) {
        if (status != 0 && status != 1 && status != 2 && status != 3 && status != 4 && status != 5 && status != 6 && status != 7 && status != 8 && status != 9) {
            throw new IllegalArgumentException("Illegal connection status");
        }
    }

    private HotspotNetworkConnectionStatus(int status, HotspotNetwork hotspotNetwork, @NonNull Bundle extras) {
        HotspotNetworkConnectionStatus.validate(status);
        this.mStatus = status;
        this.mHotspotNetwork = hotspotNetwork;
        this.mExtras = extras;
    }

    public int getStatus() {
        return this.mStatus;
    }

    @NonNull
    public HotspotNetwork getHotspotNetwork() {
        return this.mHotspotNetwork;
    }

    @NonNull
    public Bundle getExtras() {
        return this.mExtras;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HotspotNetworkConnectionStatus)) {
            return false;
        }
        HotspotNetworkConnectionStatus other = (HotspotNetworkConnectionStatus)obj;
        return this.mStatus == other.getStatus() && Objects.equals(this.mHotspotNetwork, other.getHotspotNetwork());
    }

    public int hashCode() {
        return Objects.hash(this.mStatus, this.mHotspotNetwork);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mStatus);
        this.mHotspotNetwork.writeToParcel(dest, flags);
        dest.writeBundle(this.mExtras);
    }

    @NonNull
    public static HotspotNetworkConnectionStatus readFromParcel(@NonNull Parcel in) {
        return new HotspotNetworkConnectionStatus(in.readInt(), HotspotNetwork.readFromParcel(in), in.readBundle());
    }

    public String toString() {
        return "HotspotNetworkConnectionStatus[" + "status=" + this.mStatus + "hotspot network=" + this.mHotspotNetwork.toString() + "extras=" + this.mExtras.toString() + "]";
    }

    public static class Builder {
        private int mStatus;
        private HotspotNetwork mHotspotNetwork;
        private Bundle mExtras = Bundle.EMPTY;

        @NonNull
        public Builder setStatus(int status) {
            this.mStatus = status;
            return this;
        }

        @NonNull
        public Builder setHotspotNetwork(@NonNull HotspotNetwork hotspotNetwork) {
            this.mHotspotNetwork = hotspotNetwork;
            return this;
        }

        @NonNull
        public Builder setExtras(@NonNull Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        @NonNull
        public HotspotNetworkConnectionStatus build() {
            return new HotspotNetworkConnectionStatus(this.mStatus, this.mHotspotNetwork, this.mExtras);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectionStatus {
    }
}

