/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.rtt;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.net.wifi.rtt.IRttCallback;
import android.net.wifi.rtt.IWifiRttManager;
import android.net.wifi.rtt.RangingRequest;
import android.net.wifi.rtt.RangingResult;
import android.net.wifi.rtt.RangingResultCallback;
import android.os.Binder;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.WorkSource;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.concurrent.Executor;

public class WifiRttManager {
    private static final String TAG = "WifiRttManager";
    private static final boolean VDBG = false;
    private final Context mContext;
    private final IWifiRttManager mService;
    public static final String ACTION_WIFI_RTT_STATE_CHANGED = "android.net.wifi.rtt.action.WIFI_RTT_STATE_CHANGED";
    public static final String CHARACTERISTICS_KEY_BOOLEAN_ONE_SIDED_RTT = "key_one_sided_rtt";
    public static final String CHARACTERISTICS_KEY_BOOLEAN_LCI = "key_lci";
    public static final String CHARACTERISTICS_KEY_BOOLEAN_LCR = "key_lcr";
    public static final String CHARACTERISTICS_KEY_BOOLEAN_STA_RESPONDER = "key_sta_responder";
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final String CHARACTERISTICS_KEY_BOOLEAN_NTB_INITIATOR = "key_ntb_initiator";
    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    public static final String CHARACTERISTICS_KEY_BOOLEAN_SECURE_HE_LTF_SUPPORTED = "key_secure_he_ltf_supported";
    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    public static final String CHARACTERISTICS_KEY_BOOLEAN_RANGING_FRAME_PROTECTION_SUPPORTED = "key_rnm_mfp_supported";
    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    public static final String CHARACTERISTICS_KEY_INT_MAX_SUPPORTED_SECURE_HE_LTF_PROTO_VERSION = "key_max_supported_secure_he_ltf_proto_ver";

    public WifiRttManager(@NonNull Context context, @NonNull IWifiRttManager service) {
        this.mContext = context;
        this.mService = service;
    }

    public boolean isAvailable() {
        try {
            return this.mService.isAvailable();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.CHANGE_WIFI_STATE", "android.permission.ACCESS_WIFI_STATE", "android.permission.NEARBY_WIFI_DEVICES"})
    public void startRanging(@NonNull RangingRequest request, @NonNull Executor executor, @NonNull RangingResultCallback callback) {
        this.startRanging(null, request, executor, callback);
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.LOCATION_HARDWARE", "android.permission.ACCESS_FINE_LOCATION", "android.permission.CHANGE_WIFI_STATE", "android.permission.ACCESS_WIFI_STATE", "android.permission.NEARBY_WIFI_DEVICES"}, conditional=true)
    public void startRanging(@Nullable WorkSource workSource, @NonNull RangingRequest request, final @NonNull Executor executor, final @NonNull RangingResultCallback callback) {
        if (executor == null) {
            throw new IllegalArgumentException("Null executor provided");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Null callback provided");
        }
        Binder binder = new Binder();
        try {
            Bundle extras = new Bundle();
            if (SdkLevel.isAtLeastS()) {
                extras.putParcelable("EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE", this.mContext.getAttributionSource());
            }
            this.mService.startRanging(binder, this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), workSource, request, new IRttCallback.Stub(this){

                @Override
                public void onRangingFailure(int status) throws RemoteException {
                    1.clearCallingIdentity();
                    executor.execute(() -> callback.onRangingFailure(status));
                }

                @Override
                public void onRangingResults(List<RangingResult> results) throws RemoteException {
                    1.clearCallingIdentity();
                    executor.execute(() -> callback.onRangingResults(results));
                }
            }, extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.LOCATION_HARDWARE"})
    public void cancelRanging(@Nullable WorkSource workSource) {
        try {
            this.mService.cancelRanging(workSource);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    @NonNull
    public Bundle getRttCharacteristics() {
        try {
            return this.mService.getRttCharacteristics();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RttCharacteristicsKey {
    }
}

