/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p.nsd;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;

@RequiresApi(value=36)
@FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
public class WifiP2pUsdBasedServiceResponse
implements Parcelable {
    private int mServiceProtocolType = -1;
    private byte[] mServiceSpecificInfo;
    @NonNull
    public static final Parcelable.Creator<WifiP2pUsdBasedServiceResponse> CREATOR = new Parcelable.Creator<WifiP2pUsdBasedServiceResponse>(){

        @Override
        public WifiP2pUsdBasedServiceResponse createFromParcel(Parcel in) {
            int serviceProtocolType = in.readInt();
            byte[] ssi = in.createByteArray();
            return new WifiP2pUsdBasedServiceResponse(serviceProtocolType, ssi);
        }

        public WifiP2pUsdBasedServiceResponse[] newArray(int size) {
            return new WifiP2pUsdBasedServiceResponse[size];
        }
    };

    public WifiP2pUsdBasedServiceResponse(int serviceProtocolType, @Nullable byte[] serviceSpecificInfo) {
        this.mServiceProtocolType = serviceProtocolType;
        this.mServiceSpecificInfo = serviceSpecificInfo;
    }

    public int getServiceProtocolType() {
        return this.mServiceProtocolType;
    }

    @Nullable
    public byte[] getServiceSpecificInfo() {
        return this.mServiceSpecificInfo;
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder("WifiP2pUsdBasedServiceResponse:");
        sbuf.append("\n Protocol type: ").append(this.mServiceProtocolType);
        sbuf.append("\n Service specific info : ").append(this.mServiceSpecificInfo == null ? "<null>" : Arrays.toString(this.mServiceSpecificInfo));
        return sbuf.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mServiceProtocolType);
        dest.writeByteArray(this.mServiceSpecificInfo);
    }
}

