/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p.nsd;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.nsd.WifiP2pDnsSdServiceResponse;
import android.net.wifi.p2p.nsd.WifiP2pUpnpServiceResponse;
import android.net.wifi.p2p.nsd.WifiP2pUsdBasedServiceResponse;
import android.net.wifi.util.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.wifi.x.com.android.wifi.flags.Flags;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class WifiP2pServiceResponse
implements Parcelable {
    private static int MAX_BUF_SIZE = 1024;
    protected int mServiceType;
    protected int mStatus;
    protected int mTransId;
    protected WifiP2pDevice mDevice;
    protected byte[] mData;
    private WifiP2pUsdBasedServiceResponse mUsdBasedServiceResponse;
    private int mUsdSessionId;
    @NonNull
    public static final Parcelable.Creator<WifiP2pServiceResponse> CREATOR = new Parcelable.Creator<WifiP2pServiceResponse>(){

        @Override
        public WifiP2pServiceResponse createFromParcel(Parcel in) {
            int type = in.readInt();
            int status = in.readInt();
            int transId = in.readInt();
            WifiP2pDevice dev = (WifiP2pDevice)in.readParcelable(WifiP2pDevice.class.getClassLoader());
            int len = in.readInt();
            byte[] data = null;
            if (len > 0) {
                data = new byte[len];
                in.readByteArray(data);
            }
            WifiP2pUsdBasedServiceResponse usdServResponse = null;
            int usdSessionId = 0;
            if (Environment.isSdkAtLeastB() && Flags.wifiDirectR2()) {
                usdServResponse = (WifiP2pUsdBasedServiceResponse)in.readParcelable(WifiP2pUsdBasedServiceResponse.class.getClassLoader());
                usdSessionId = in.readInt();
            }
            if (type == 1) {
                return WifiP2pDnsSdServiceResponse.newInstance(status, transId, dev, data);
            }
            if (type == 2) {
                return WifiP2pUpnpServiceResponse.newInstance(status, transId, dev, data);
            }
            if (usdServResponse != null) {
                return new WifiP2pServiceResponse(dev, usdServResponse, usdSessionId);
            }
            return new WifiP2pServiceResponse(type, status, transId, dev, data);
        }

        public WifiP2pServiceResponse[] newArray(int size) {
            return new WifiP2pServiceResponse[size];
        }
    };

    protected WifiP2pServiceResponse(int serviceType, int status, int transId, WifiP2pDevice device, byte[] data) {
        this.mServiceType = serviceType;
        this.mStatus = status;
        this.mTransId = transId;
        this.mDevice = device;
        this.mData = data;
    }

    public WifiP2pServiceResponse(WifiP2pDevice device, @NonNull WifiP2pUsdBasedServiceResponse usdResponseData, int usdSessionId) {
        this.mServiceType = 0;
        this.mStatus = 0;
        this.mTransId = 0;
        this.mDevice = device;
        this.mData = null;
        this.mUsdBasedServiceResponse = usdResponseData;
        this.mUsdSessionId = usdSessionId;
    }

    public int getUsdSessionId() {
        return this.mUsdSessionId;
    }

    public void setUsdSessionId(int sessionId) {
        this.mUsdSessionId = sessionId;
    }

    public int getServiceType() {
        return this.mServiceType;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public int getTransactionId() {
        return this.mTransId;
    }

    public byte[] getRawData() {
        return this.mData;
    }

    public WifiP2pDevice getSrcDevice() {
        return this.mDevice;
    }

    public void setSrcDevice(WifiP2pDevice dev) {
        if (dev == null) {
            return;
        }
        this.mDevice = dev;
    }

    @Nullable
    public WifiP2pUsdBasedServiceResponse getWifiP2pUsdBasedServiceResponse() {
        return this.mUsdBasedServiceResponse;
    }

    public static List<WifiP2pServiceResponse> newInstance(String srcAddr, byte[] tlvsBin) {
        ArrayList<WifiP2pServiceResponse> respList = new ArrayList<WifiP2pServiceResponse>();
        WifiP2pDevice dev = new WifiP2pDevice();
        dev.deviceAddress = srcAddr;
        if (tlvsBin == null) {
            return null;
        }
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(tlvsBin));
        try {
            while (dis.available() > 0) {
                int length = dis.readUnsignedByte() + (dis.readUnsignedByte() << 8) - 3;
                int type = dis.readUnsignedByte();
                int transId = dis.readUnsignedByte();
                int status = dis.readUnsignedByte();
                if (length < 0) {
                    return null;
                }
                if (length == 0) {
                    if (status != 0) continue;
                    respList.add(new WifiP2pServiceResponse(type, status, transId, dev, null));
                    continue;
                }
                if (length > MAX_BUF_SIZE) {
                    dis.skip(length);
                    continue;
                }
                byte[] data = new byte[length];
                dis.readFully(data);
                WifiP2pServiceResponse resp = type == 1 ? WifiP2pDnsSdServiceResponse.newInstance(status, transId, dev, data) : (type == 2 ? WifiP2pUpnpServiceResponse.newInstance(status, transId, dev, data) : new WifiP2pServiceResponse(type, status, transId, dev, data));
                if (resp == null || resp.getStatus() != 0) continue;
                respList.add(resp);
            }
            return respList;
        }
        catch (IOException e) {
            e.printStackTrace();
            if (respList.size() > 0) {
                return respList;
            }
            return null;
        }
    }

    private static byte[] hexStr2Bin(String hex) {
        int sz = hex.length() / 2;
        byte[] b = new byte[hex.length() / 2];
        for (int i = 0; i < sz; ++i) {
            try {
                b[i] = (byte)Integer.parseInt(hex.substring(i * 2, i * 2 + 2), 16);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return b;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("serviceType:").append(this.mServiceType);
        sbuf.append(" status:").append(Status.toString(this.mStatus));
        sbuf.append(" srcAddr:").append(this.mDevice.deviceAddress);
        sbuf.append(" data:").append(Arrays.toString(this.mData));
        if (Environment.isSdkAtLeastB() && Flags.wifiDirectR2()) {
            sbuf.append(" USD based service response:").append(this.mUsdBasedServiceResponse == null ? "<null>" : this.mUsdBasedServiceResponse.toString());
        }
        return sbuf.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WifiP2pServiceResponse)) {
            return false;
        }
        WifiP2pServiceResponse req = (WifiP2pServiceResponse)o;
        return this.mServiceType == req.mServiceType && this.mStatus == req.mStatus && Objects.equals(this.mDevice.deviceAddress, req.mDevice.deviceAddress) && Arrays.equals(this.mData, req.mData) && Objects.equals(this.mUsdBasedServiceResponse, req.mUsdBasedServiceResponse);
    }

    private boolean equals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null) {
            return a.equals(b);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.mServiceType;
        result = 31 * result + this.mStatus;
        result = 31 * result + this.mTransId;
        result = 31 * result + (this.mDevice.deviceAddress == null ? 0 : this.mDevice.deviceAddress.hashCode());
        result = 31 * result + (this.mData == null ? 0 : Arrays.hashCode(this.mData));
        result = 31 * result + (this.mUsdBasedServiceResponse == null ? 0 : this.mUsdBasedServiceResponse.hashCode());
        return result;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mServiceType);
        dest.writeInt(this.mStatus);
        dest.writeInt(this.mTransId);
        dest.writeParcelable(this.mDevice, flags);
        if (this.mData == null || this.mData.length == 0) {
            dest.writeInt(0);
        } else {
            dest.writeInt(this.mData.length);
            dest.writeByteArray(this.mData);
        }
        if (Environment.isSdkAtLeastB() && Flags.wifiDirectR2()) {
            dest.writeParcelable(this.mUsdBasedServiceResponse, flags);
            dest.writeInt(this.mUsdSessionId);
        }
    }

    public static class Status {
        public static final int SUCCESS = 0;
        public static final int SERVICE_PROTOCOL_NOT_AVAILABLE = 1;
        public static final int REQUESTED_INFORMATION_NOT_AVAILABLE = 2;
        public static final int BAD_REQUEST = 3;

        public static String toString(int status) {
            switch (status) {
                case 0: {
                    return "SUCCESS";
                }
                case 1: {
                    return "SERVICE_PROTOCOL_NOT_AVAILABLE";
                }
                case 2: {
                    return "REQUESTED_INFORMATION_NOT_AVAILABLE";
                }
                case 3: {
                    return "BAD_REQUEST";
                }
            }
            return "UNKNOWN";
        }

        private Status() {
        }
    }
}

