/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.RequiresApi;
import android.net.MacAddress;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;

@RequiresApi(value=36)
@FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
public class WifiP2pDirInfo
implements Parcelable {
    private MacAddress mMacAddress;
    private byte[] mNonce;
    private byte[] mDirTag;
    @NonNull
    public static final Parcelable.Creator<WifiP2pDirInfo> CREATOR = new Parcelable.Creator<WifiP2pDirInfo>(){

        @Override
        public WifiP2pDirInfo createFromParcel(Parcel in) {
            return new WifiP2pDirInfo(MacAddress.CREATOR.createFromParcel(in), in.createByteArray(), in.createByteArray());
        }

        public WifiP2pDirInfo[] newArray(int size) {
            return new WifiP2pDirInfo[size];
        }
    };

    @NonNull
    public MacAddress getMacAddress() {
        return this.mMacAddress;
    }

    @NonNull
    public byte[] getNonce() {
        return this.mNonce;
    }

    @NonNull
    public byte[] getDirTag() {
        return this.mDirTag;
    }

    public WifiP2pDirInfo(@NonNull MacAddress macAddress, @NonNull byte[] nonce, @NonNull byte[] dirTag) {
        this.mMacAddress = macAddress;
        this.mNonce = nonce;
        this.mDirTag = dirTag;
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder("WifiP2pDirInfo:");
        sbuf.append("\n Mac Address: ").append(this.mMacAddress);
        sbuf.append("\n Nonce : ").append(this.mNonce == null ? "<null>" : Arrays.toString(this.mNonce));
        sbuf.append("\n DIR Tag : ").append(this.mDirTag == null ? "<null>" : Arrays.toString(this.mDirTag));
        return sbuf.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        this.mMacAddress.writeToParcel(dest, flags);
        dest.writeByteArray(this.mNonce);
        dest.writeByteArray(this.mDirTag);
    }
}

