/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.net.NetworkSpecifier;
import android.net.wifi.aware.DiscoverySessionCallback;
import android.net.wifi.aware.PublishConfig;
import android.net.wifi.aware.SubscribeConfig;
import android.net.wifi.aware.WifiAwareManager;
import android.net.wifi.aware.WifiAwareUtils;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.util.CloseGuard;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class WifiAwareSession
implements AutoCloseable {
    private static final String TAG = "WifiAwareSession";
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    private final WeakReference<WifiAwareManager> mMgr;
    private final Binder mBinder;
    private final int mClientId;
    private boolean mTerminated = true;
    private final CloseGuard mCloseGuard = new CloseGuard();

    public WifiAwareSession(WifiAwareManager manager, Binder binder, int clientId) {
        this.mMgr = new WeakReference<WifiAwareManager>(manager);
        this.mBinder = binder;
        this.mClientId = clientId;
        this.mTerminated = false;
        this.mCloseGuard.open("close");
    }

    @Override
    public void close() {
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.w(TAG, "destroy: called post GC on WifiAwareManager");
            return;
        }
        mgr.disconnect(this.mClientId, this.mBinder);
        this.mTerminated = true;
        this.mMgr.clear();
        this.mCloseGuard.close();
        Reference.reachabilityFence(this);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            if (!this.mTerminated) {
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    @VisibleForTesting
    public int getClientId() {
        return this.mClientId;
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.CHANGE_WIFI_STATE", "android.permission.ACCESS_FINE_LOCATION", "android.permission.NEARBY_WIFI_DEVICES"}, conditional=true)
    public void publish(@NonNull PublishConfig publishConfig, @NonNull DiscoverySessionCallback callback, @Nullable Handler handler) {
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.e(TAG, "publish: called post GC on WifiAwareManager");
            return;
        }
        if (this.mTerminated) {
            Log.e(TAG, "publish: called after termination");
            return;
        }
        mgr.publish(this.mClientId, handler == null ? Looper.getMainLooper() : handler.getLooper(), publishConfig, callback);
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.CHANGE_WIFI_STATE", "android.permission.ACCESS_FINE_LOCATION", "android.permission.NEARBY_WIFI_DEVICES"}, conditional=true)
    public void subscribe(@NonNull SubscribeConfig subscribeConfig, @NonNull DiscoverySessionCallback callback, @Nullable Handler handler) {
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.e(TAG, "publish: called post GC on WifiAwareManager");
            return;
        }
        if (this.mTerminated) {
            Log.e(TAG, "publish: called after termination");
            return;
        }
        mgr.subscribe(this.mClientId, handler == null ? Looper.getMainLooper() : handler.getLooper(), subscribeConfig, callback);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.OVERRIDE_WIFI_CONFIG")
    public void setMasterPreference(int masterPreference) {
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.e(TAG, "publish: called post GC on WifiAwareManager");
            return;
        }
        if (this.mTerminated) {
            Log.e(TAG, "publish: called after termination");
            return;
        }
        mgr.setMasterPreference(this.mClientId, this.mBinder, masterPreference);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.OVERRIDE_WIFI_CONFIG")
    public void getMasterPreference(@NonNull Executor executor, @NonNull Consumer<Integer> resultsCallback) {
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.e(TAG, "publish: called post GC on WifiAwareManager");
            return;
        }
        if (this.mTerminated) {
            Log.e(TAG, "publish: called after termination");
            return;
        }
        mgr.getMasterPreference(this.mClientId, this.mBinder, executor, resultsCallback);
    }

    @Deprecated
    public NetworkSpecifier createNetworkSpecifierOpen(int role, @NonNull byte[] peer) {
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.e(TAG, "createNetworkSpecifierOpen: called post GC on WifiAwareManager");
            return null;
        }
        if (this.mTerminated) {
            Log.e(TAG, "createNetworkSpecifierOpen: called after termination");
            return null;
        }
        return mgr.createNetworkSpecifier(this.mClientId, role, peer, null, null);
    }

    @Deprecated
    public NetworkSpecifier createNetworkSpecifierPassphrase(int role, @NonNull byte[] peer, @NonNull String passphrase) {
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.e(TAG, "createNetworkSpecifierPassphrase: called post GC on WifiAwareManager");
            return null;
        }
        if (this.mTerminated) {
            Log.e(TAG, "createNetworkSpecifierPassphrase: called after termination");
            return null;
        }
        if (!WifiAwareUtils.validatePassphrase(passphrase)) {
            throw new IllegalArgumentException("Passphrase must meet length requirements");
        }
        return mgr.createNetworkSpecifier(this.mClientId, role, peer, null, passphrase);
    }

    @Deprecated
    @SystemApi
    public NetworkSpecifier createNetworkSpecifierPmk(int role, @NonNull byte[] peer, @NonNull byte[] pmk) {
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.e(TAG, "createNetworkSpecifierPmk: called post GC on WifiAwareManager");
            return null;
        }
        if (this.mTerminated) {
            Log.e(TAG, "createNetworkSpecifierPmk: called after termination");
            return null;
        }
        if (!WifiAwareUtils.validatePmk(pmk)) {
            throw new IllegalArgumentException("PMK must 32 bytes");
        }
        return mgr.createNetworkSpecifier(this.mClientId, role, peer, pmk, null);
    }
}

