/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.RequiresApi;
import android.annotation.SystemApi;
import android.net.wifi.OuiKeyedData;
import android.net.wifi.ParcelUtil;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
public class ConfigRequest
implements Parcelable {
    public static final int CLUSTER_ID_MIN = 0;
    public static final int CLUSTER_ID_MAX = 65535;
    public static final int NAN_BAND_24GHZ = 0;
    public static final int NAN_BAND_5GHZ = 1;
    public static final int NAN_BAND_6GHZ = 2;
    public static final int DW_INTERVAL_NOT_INIT = -1;
    public static final int DW_DISABLE = 0;
    public final boolean mSupport5gBand;
    public final boolean mSupport6gBand;
    public int mMasterPreference;
    public final int mClusterLow;
    public final int mClusterHigh;
    public final int[] mDiscoveryWindowInterval;
    private final List<OuiKeyedData> mVendorData;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @NonNull
    public static final Parcelable.Creator<ConfigRequest> CREATOR = new Parcelable.Creator<ConfigRequest>(){

        public ConfigRequest[] newArray(int size) {
            return new ConfigRequest[size];
        }

        @Override
        public ConfigRequest createFromParcel(Parcel in) {
            boolean support5gBand = in.readInt() != 0;
            boolean support6gBand = in.readInt() != 0;
            int masterPreference = in.readInt();
            int clusterLow = in.readInt();
            int clusterHigh = in.readInt();
            int[] discoveryWindowInterval = in.createIntArray();
            List<OuiKeyedData> vendorData = ParcelUtil.readOuiKeyedDataList(in);
            return new ConfigRequest(support5gBand, support6gBand, masterPreference, clusterLow, clusterHigh, discoveryWindowInterval, vendorData);
        }
    };

    private ConfigRequest(boolean support5gBand, boolean support6gBand, int masterPreference, int clusterLow, int clusterHigh, int[] discoveryWindowInterval, @NonNull List<OuiKeyedData> vendorData) {
        this.mSupport5gBand = support5gBand;
        this.mSupport6gBand = support6gBand;
        this.mMasterPreference = masterPreference;
        this.mClusterLow = clusterLow;
        this.mClusterHigh = clusterHigh;
        this.mDiscoveryWindowInterval = discoveryWindowInterval;
        this.mVendorData = vendorData;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public String toString() {
        return "ConfigRequest [mSupport5gBand=" + this.mSupport5gBand + ", mSupport6gBand=" + this.mSupport6gBand + ", mMasterPreference=" + this.mMasterPreference + ", mClusterLow=" + this.mClusterLow + ", mClusterHigh=" + this.mClusterHigh + ", mDiscoveryWindowInterval=" + Arrays.toString(this.mDiscoveryWindowInterval) + ", mVendorData=" + this.mVendorData + "]";
    }

    @Override
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int describeContents() {
        return 0;
    }

    @Override
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mSupport5gBand ? 1 : 0);
        dest.writeInt(this.mSupport6gBand ? 1 : 0);
        dest.writeInt(this.mMasterPreference);
        dest.writeInt(this.mClusterLow);
        dest.writeInt(this.mClusterHigh);
        dest.writeIntArray(this.mDiscoveryWindowInterval);
        dest.writeList(this.mVendorData);
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigRequest)) {
            return false;
        }
        ConfigRequest lhs = (ConfigRequest)o;
        return this.mSupport5gBand == lhs.mSupport5gBand && this.mSupport6gBand == lhs.mSupport6gBand && this.mMasterPreference == lhs.mMasterPreference && this.mClusterLow == lhs.mClusterLow && this.mClusterHigh == lhs.mClusterHigh && Arrays.equals(this.mDiscoveryWindowInterval, lhs.mDiscoveryWindowInterval) && Objects.equals(this.mVendorData, lhs.mVendorData);
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.mSupport5gBand ? 1 : 0);
        result = 31 * result + (this.mSupport6gBand ? 1 : 0);
        result = 31 * result + this.mMasterPreference;
        result = 31 * result + this.mClusterLow;
        result = 31 * result + this.mClusterHigh;
        result = 31 * result + Arrays.hashCode(this.mDiscoveryWindowInterval);
        result = 31 * result + this.mVendorData.hashCode();
        return result;
    }

    public void validate() throws IllegalArgumentException {
        if (this.mMasterPreference < 0) {
            throw new IllegalArgumentException("Master Preference specification must be non-negative");
        }
        if (this.mMasterPreference == 1 || this.mMasterPreference == 255 || this.mMasterPreference > 255) {
            throw new IllegalArgumentException("Master Preference specification must not exceed 255 or use 1 or 255 (reserved values)");
        }
        if (this.mClusterLow < 0) {
            throw new IllegalArgumentException("Cluster specification must be non-negative");
        }
        if (this.mClusterLow > 65535) {
            throw new IllegalArgumentException("Cluster specification must not exceed 0xFFFF");
        }
        if (this.mClusterHigh < 0) {
            throw new IllegalArgumentException("Cluster specification must be non-negative");
        }
        if (this.mClusterHigh > 65535) {
            throw new IllegalArgumentException("Cluster specification must not exceed 0xFFFF");
        }
        if (this.mClusterLow > this.mClusterHigh) {
            throw new IllegalArgumentException("Invalid argument combination - must have Cluster Low <= Cluster High");
        }
        if (this.mDiscoveryWindowInterval.length != 3) {
            throw new IllegalArgumentException("Invalid discovery window interval: must have 3 elements (2.4 & 5 & 6");
        }
        if (this.mDiscoveryWindowInterval[0] != -1 && (this.mDiscoveryWindowInterval[0] < 1 || this.mDiscoveryWindowInterval[0] > 5)) {
            throw new IllegalArgumentException("Invalid discovery window interval for 2.4GHz: valid is UNSET or [1,5]");
        }
        if (this.mDiscoveryWindowInterval[1] != -1 && (this.mDiscoveryWindowInterval[1] < 0 || this.mDiscoveryWindowInterval[1] > 5)) {
            throw new IllegalArgumentException("Invalid discovery window interval for 5GHz: valid is UNSET or [0,5]");
        }
        if (this.mDiscoveryWindowInterval[2] != -1 && (this.mDiscoveryWindowInterval[2] < 0 || this.mDiscoveryWindowInterval[2] > 5)) {
            throw new IllegalArgumentException("Invalid discovery window interval for 6GHz: valid is UNSET or [0,5]");
        }
        if (this.mVendorData == null) {
            throw new IllegalArgumentException("Vendor data list must be non-null");
        }
    }

    @SystemApi
    @RequiresApi(value=35)
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @NonNull
    public List<OuiKeyedData> getVendorData() {
        if (!SdkLevel.isAtLeastV()) {
            throw new UnsupportedOperationException();
        }
        return this.mVendorData != null ? this.mVendorData : Collections.emptyList();
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static class Builder {
        private boolean mSupport5gBand = true;
        private boolean mSupport6gBand = false;
        private int mMasterPreference = 0;
        private int mClusterLow = 0;
        private int mClusterHigh = 65535;
        private int[] mDiscoveryWindowInterval = new int[]{-1, -1, -1};
        private List<OuiKeyedData> mVendorData = Collections.emptyList();

        public Builder setSupport5gBand(boolean support5gBand) {
            this.mSupport5gBand = support5gBand;
            return this;
        }

        public Builder setSupport6gBand(boolean support6gBand) {
            this.mSupport6gBand = support6gBand;
            return this;
        }

        public Builder setMasterPreference(int masterPreference) {
            if (masterPreference < 0) {
                throw new IllegalArgumentException("Master Preference specification must be non-negative");
            }
            if (masterPreference == 1 || masterPreference == 255 || masterPreference > 255) {
                throw new IllegalArgumentException("Master Preference specification must not exceed 255 or use 1 or 255 (reserved values)");
            }
            this.mMasterPreference = masterPreference;
            return this;
        }

        public Builder setClusterLow(int clusterLow) {
            if (clusterLow < 0) {
                throw new IllegalArgumentException("Cluster specification must be non-negative");
            }
            if (clusterLow > 65535) {
                throw new IllegalArgumentException("Cluster specification must not exceed 0xFFFF");
            }
            this.mClusterLow = clusterLow;
            return this;
        }

        public Builder setClusterHigh(int clusterHigh) {
            if (clusterHigh < 0) {
                throw new IllegalArgumentException("Cluster specification must be non-negative");
            }
            if (clusterHigh > 65535) {
                throw new IllegalArgumentException("Cluster specification must not exceed 0xFFFF");
            }
            this.mClusterHigh = clusterHigh;
            return this;
        }

        public Builder setDiscoveryWindowInterval(int band, int interval) {
            if (band != 0 && band != 1 && band != 2) {
                throw new IllegalArgumentException("Invalid band value");
            }
            if (band == 0 && (interval < 1 || interval > 5) || band == 1 && (interval < 0 || interval > 5) || band == 2 && (interval < 0 || interval > 5)) {
                throw new IllegalArgumentException("Invalid interval value: 2.4 GHz [1,5] or 5GHz/6GHz [0,5]");
            }
            this.mDiscoveryWindowInterval[band] = interval;
            return this;
        }

        @SystemApi
        @RequiresApi(value=35)
        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setVendorData(@NonNull List<OuiKeyedData> vendorData) {
            if (!SdkLevel.isAtLeastV()) {
                throw new UnsupportedOperationException();
            }
            if (vendorData == null) {
                throw new IllegalArgumentException("setVendorData received a null value");
            }
            this.mVendorData = vendorData;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public ConfigRequest build() {
            if (this.mClusterLow > this.mClusterHigh) {
                throw new IllegalArgumentException("Invalid argument combination - must have Cluster Low <= Cluster High");
            }
            return new ConfigRequest(this.mSupport5gBand, this.mSupport6gBand, this.mMasterPreference, this.mClusterLow, this.mClusterHigh, this.mDiscoveryWindowInterval, this.mVendorData);
        }
    }
}

