/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.SystemApi;
import android.app.SystemServiceRegistry;
import android.net.wifi.IWifiManager;
import android.net.wifi.IWifiScanner;
import android.net.wifi.RttManager;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiScanner;
import android.net.wifi.aware.IWifiAwareManager;
import android.net.wifi.aware.WifiAwareManager;
import android.net.wifi.p2p.IWifiP2pManager;
import android.net.wifi.p2p.WifiP2pManager;
import android.net.wifi.rtt.IWifiRttManager;
import android.net.wifi.rtt.WifiRttManager;
import android.net.wifi.usd.IUsdManager;
import android.net.wifi.usd.UsdManager;
import android.net.wifi.util.Environment;
import com.android.wifi.x.android.net.wifi.flags.Flags;

@SystemApi
public class WifiFrameworkInitializer {
    private WifiFrameworkInitializer() {
    }

    public static void registerServiceWrappers() {
        SystemServiceRegistry.registerContextAwareService("wifi", WifiManager.class, (context, serviceBinder) -> {
            if (!context.getPackageManager().hasSystemFeature("android.hardware.wifi")) {
                return null;
            }
            IWifiManager service = IWifiManager.Stub.asInterface(serviceBinder);
            return new WifiManager(context, service);
        });
        SystemServiceRegistry.registerContextAwareService("wifip2p", WifiP2pManager.class, (context, serviceBinder) -> {
            if (!context.getPackageManager().hasSystemFeature("android.hardware.wifi.direct")) {
                return null;
            }
            IWifiP2pManager service = IWifiP2pManager.Stub.asInterface(serviceBinder);
            return new WifiP2pManager(service);
        });
        SystemServiceRegistry.registerContextAwareService("wifiaware", WifiAwareManager.class, (context, serviceBinder) -> {
            if (!context.getPackageManager().hasSystemFeature("android.hardware.wifi.aware")) {
                return null;
            }
            IWifiAwareManager service = IWifiAwareManager.Stub.asInterface(serviceBinder);
            return new WifiAwareManager(context, service);
        });
        SystemServiceRegistry.registerContextAwareService("wifiscanner", WifiScanner.class, (context, serviceBinder) -> {
            if (!context.getPackageManager().hasSystemFeature("android.hardware.wifi")) {
                return null;
            }
            IWifiScanner service = IWifiScanner.Stub.asInterface(serviceBinder);
            return new WifiScanner(context, service);
        });
        SystemServiceRegistry.registerContextAwareService("wifirtt", WifiRttManager.class, (context, serviceBinder) -> {
            if (!context.getPackageManager().hasSystemFeature("android.hardware.wifi.rtt")) {
                return null;
            }
            IWifiRttManager service = IWifiRttManager.Stub.asInterface(serviceBinder);
            return new WifiRttManager(context, service);
        });
        SystemServiceRegistry.registerContextAwareService("rttmanager", RttManager.class, context -> {
            if (!context.getPackageManager().hasSystemFeature("android.hardware.wifi.rtt")) {
                return null;
            }
            WifiRttManager wifiRttManager = context.getSystemService(WifiRttManager.class);
            return new RttManager(context, wifiRttManager);
        });
        if (Flags.usd() && Environment.isSdkAtLeastB()) {
            SystemServiceRegistry.registerContextAwareService("wifi_usd", UsdManager.class, (context, serviceBinder) -> {
                if (!context.getResources().getBoolean(context.getResources().getIdentifier("config_deviceSupportsWifiUsd", "bool", "android"))) {
                    return null;
                }
                IUsdManager service = IUsdManager.Stub.asInterface(serviceBinder);
                return new UsdManager(context, service);
            });
        }
    }
}

