/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.wifi.ParcelUtil;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WifiEnterpriseConfig
implements Parcelable {
    public static final String WAPI_AS_CERTIFICATE = "WAPIAS_";
    public static final String WAPI_USER_CERTIFICATE = "WAPIUSR_";
    public static final String EXTRA_WAPI_AS_CERTIFICATE_NAME = "android.net.wifi.extra.WAPI_AS_CERTIFICATE_NAME";
    public static final String EXTRA_WAPI_AS_CERTIFICATE_DATA = "android.net.wifi.extra.WAPI_AS_CERTIFICATE_DATA";
    public static final String EXTRA_WAPI_USER_CERTIFICATE_NAME = "android.net.wifi.extra.WAPI_USER_CERTIFICATE_NAME";
    public static final String EXTRA_WAPI_USER_CERTIFICATE_DATA = "android.net.wifi.extra.WAPI_USER_CERTIFICATE_DATA";
    public static final String EMPTY_VALUE = "NULL";
    public static final String EAP_KEY = "eap";
    public static final String PHASE2_KEY = "phase2";
    public static final String IDENTITY_KEY = "identity";
    public static final String ANON_IDENTITY_KEY = "anonymous_identity";
    public static final String PASSWORD_KEY = "password";
    public static final String SUBJECT_MATCH_KEY = "subject_match";
    public static final String ALTSUBJECT_MATCH_KEY = "altsubject_match";
    public static final String DOM_SUFFIX_MATCH_KEY = "domain_suffix_match";
    public static final String OPP_KEY_CACHING = "proactive_key_caching";
    public static final String EAP_ERP = "eap_erp";
    public static final String OCSP = "ocsp";
    public static final String DECORATED_IDENTITY_PREFIX_KEY = "decorated_username_prefix";
    public static final String ENGINE_ID_KEYSTORE = "keystore";
    public static final String KEYSTORE_URI = "keystore://";
    public static final String KEYSTORES_URI = "keystores://";
    private static final String CERT_HASH_PREFIX = "hash://server/sha256/";
    public static final String ENGINE_ENABLE = "1";
    public static final String ENGINE_DISABLE = "0";
    private static final String CA_CERTIFICATE = "CACERT_";
    private static final String USER_CERTIFICATE = "USRCERT_";
    private static final String USER_PRIVATE_KEY = "USRPKEY_";
    public static final String CA_CERT_PREFIX = "keystore://CACERT_";
    public static final String CLIENT_CERT_PREFIX = "keystore://USRCERT_";
    public static final String CLIENT_CERT_KEY = "client_cert";
    public static final String CA_CERT_KEY = "ca_cert";
    public static final String CA_PATH_KEY = "ca_path";
    public static final String ENGINE_KEY = "engine";
    public static final String ENGINE_ID_KEY = "engine_id";
    public static final String PRIVATE_KEY_ID_KEY = "key_id";
    public static final String REALM_KEY = "realm";
    public static final String PLMN_KEY = "plmn";
    public static final String CA_CERT_ALIAS_DELIMITER = " ";
    public static final String WAPI_CERT_SUITE_KEY = "wapi_cert_suite";
    @SystemApi
    public static final int OCSP_NONE = 0;
    @SystemApi
    public static final int OCSP_REQUEST_CERT_STATUS = 1;
    @SystemApi
    public static final int OCSP_REQUIRE_CERT_STATUS = 2;
    @SystemApi
    public static final int OCSP_REQUIRE_ALL_NON_TRUSTED_CERTS_STATUS = 3;
    private int mOcsp = 0;
    private static final String[] SUPPLICANT_CONFIG_KEYS = new String[]{"identity", "anonymous_identity", "password", "client_cert", "ca_cert", "subject_match", "engine", "engine_id", "key_id", "altsubject_match", "domain_suffix_match", "ca_path"};
    private static final int CERTIFICATE_MAX_LENGTH = 8192;
    private static final int KEYCHAIN_ALIAS_MAX_LENGTH = 256;
    private static final int CLIENT_CERTIFICATE_CHAIN_MAX_ELEMENTS = 5;
    private static final int CA_CERTIFICATES_MAX_ELEMENTS = 100;
    private static final Map<String, Integer> SUPPORTED_FIELDS = Map.ofEntries(Map.entry("altsubject_match", 1024), Map.entry("anonymous_identity", 1024), Map.entry("ca_cert", 8192), Map.entry("ca_path", 4096), Map.entry("client_cert", 8192), Map.entry("decorated_username_prefix", 256), Map.entry("domain_suffix_match", 256), Map.entry("eap_erp", 1), Map.entry("engine", 1), Map.entry("engine_id", 64), Map.entry("identity", 256), Map.entry("proactive_key_caching", 1), Map.entry("password", 256), Map.entry("plmn", 16), Map.entry("key_id", 256), Map.entry("realm", 256), Map.entry("subject_match", 256), Map.entry("wapi_cert_suite", 8192));
    private static final List<String> UNQUOTED_KEYS = Arrays.asList("engine", "proactive_key_caching", "eap_erp");
    public static final int TLS_V1_0 = 0;
    public static final int TLS_V1_1 = 1;
    public static final int TLS_V1_2 = 2;
    public static final int TLS_V1_3 = 3;
    public static final int TLS_VERSION_MIN = 0;
    public static final int TLS_VERSION_MAX = 3;
    public static final int TOFU_STATE_NOT_ENABLED = 0;
    public static final int TOFU_STATE_ENABLED_PRE_CONNECTION = 1;
    public static final int TOFU_STATE_CONFIGURE_ROOT_CA = 2;
    public static final int TOFU_STATE_CERT_PINNING = 3;
    public static final int TOFU_DIALOG_STATE_UNSPECIFIED = 0;
    public static final int TOFU_DIALOG_STATE_REJECTED = 1;
    public static final int TOFU_DIALOG_STATE_ACCEPTED = 2;
    @UnsupportedAppUsage
    private HashMap<String, String> mFields = new HashMap();
    private X509Certificate[] mCaCerts;
    private PrivateKey mClientPrivateKey;
    private X509Certificate[] mClientCertificateChain;
    private int mEapMethod = -1;
    private int mPhase2Method = 0;
    private boolean mIsAppInstalledDeviceKeyAndCert = false;
    private boolean mIsAppInstalledCaCert = false;
    private String mKeyChainAlias;
    private boolean mIsTrustOnFirstUseEnabled = false;
    private boolean mUserApproveNoCaCert = false;
    private int mMinimumTlsVersion = 0;
    private int mTofuDialogState = 0;
    private int mTofuConnectionState = 0;
    private long mSelectedRcoi = 0L;
    private boolean mIsStrictConservativePeerMode = false;
    private static final String TAG = "WifiEnterpriseConfig";
    @NonNull
    public static final Parcelable.Creator<WifiEnterpriseConfig> CREATOR = new Parcelable.Creator<WifiEnterpriseConfig>(){

        @Override
        public WifiEnterpriseConfig createFromParcel(Parcel in) {
            WifiEnterpriseConfig enterpriseConfig = new WifiEnterpriseConfig();
            enterpriseConfig.mFields = WifiEnterpriseConfig.bundleToFieldMap(in.readBundle());
            enterpriseConfig.mEapMethod = in.readInt();
            enterpriseConfig.mPhase2Method = in.readInt();
            X509Certificate[] caCerts = ParcelUtil.readCertificates(in);
            if (caCerts != null && caCerts.length > 100) {
                Log.e(WifiEnterpriseConfig.TAG, "List of CA certificates with size " + caCerts.length + " received during unparceling");
                enterpriseConfig.mCaCerts = null;
            } else {
                enterpriseConfig.mCaCerts = caCerts;
            }
            PrivateKey privateKey = ParcelUtil.readPrivateKey(in);
            if (privateKey != null && privateKey.getEncoded() != null && privateKey.getEncoded().length > 8192) {
                Log.e(WifiEnterpriseConfig.TAG, "Invalid private key with size " + privateKey.getEncoded().length + " received during unparceling");
                enterpriseConfig.mClientPrivateKey = null;
            } else {
                enterpriseConfig.mClientPrivateKey = privateKey;
            }
            X509Certificate[] clientCertificateChain = ParcelUtil.readCertificates(in);
            if (clientCertificateChain != null && clientCertificateChain.length > 5) {
                Log.e(WifiEnterpriseConfig.TAG, "Client certificate chain with size " + clientCertificateChain.length + " received during unparceling");
                enterpriseConfig.mClientCertificateChain = null;
            } else {
                enterpriseConfig.mClientCertificateChain = clientCertificateChain;
            }
            String keyChainAlias = in.readString();
            enterpriseConfig.mKeyChainAlias = WifiEnterpriseConfig.isFieldLengthValid(keyChainAlias, 256) ? keyChainAlias : "";
            enterpriseConfig.mIsAppInstalledDeviceKeyAndCert = in.readBoolean();
            enterpriseConfig.mIsAppInstalledCaCert = in.readBoolean();
            enterpriseConfig.mOcsp = in.readInt();
            enterpriseConfig.mIsTrustOnFirstUseEnabled = in.readBoolean();
            enterpriseConfig.mUserApproveNoCaCert = in.readBoolean();
            enterpriseConfig.mMinimumTlsVersion = in.readInt();
            enterpriseConfig.mTofuDialogState = in.readInt();
            enterpriseConfig.mTofuConnectionState = in.readInt();
            return enterpriseConfig;
        }

        public WifiEnterpriseConfig[] newArray(int size) {
            return new WifiEnterpriseConfig[size];
        }
    };

    public WifiEnterpriseConfig() {
    }

    private static boolean isKeySupported(String key) {
        return SUPPORTED_FIELDS.containsKey(key);
    }

    private static boolean isFieldLengthValid(String key, String value) {
        int maxLength = SUPPORTED_FIELDS.getOrDefault(key, 0);
        return WifiEnterpriseConfig.isFieldLengthValid(value, maxLength);
    }

    private static boolean isFieldLengthValid(String value, int maxLength) {
        if (value == null) {
            return true;
        }
        return value.length() <= maxLength;
    }

    private static boolean isFieldValid(String key, String value) {
        return WifiEnterpriseConfig.isKeySupported(key) && WifiEnterpriseConfig.isFieldLengthValid(key, value);
    }

    private Bundle fieldMapToBundle() {
        Bundle bundle = new Bundle();
        for (Map.Entry<String, String> entry : this.mFields.entrySet()) {
            if (!WifiEnterpriseConfig.isFieldValid(entry.getKey(), entry.getValue())) continue;
            bundle.putString(entry.getKey(), entry.getValue());
        }
        return bundle;
    }

    private static HashMap<String, String> bundleToFieldMap(Bundle bundle) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        if (bundle == null) {
            return fieldMap;
        }
        for (String key : bundle.keySet()) {
            String value;
            if (!WifiEnterpriseConfig.isFieldValid(key, value = bundle.getString(key))) continue;
            fieldMap.put(key, value);
        }
        return fieldMap;
    }

    private void copyFrom(WifiEnterpriseConfig source, boolean ignoreMaskedPassword, String mask) {
        for (String key : source.mFields.keySet()) {
            String value = source.mFields.get(key);
            if (ignoreMaskedPassword && key.equals(PASSWORD_KEY) && TextUtils.equals(value, mask) || !WifiEnterpriseConfig.isFieldValid(key, value)) continue;
            this.mFields.put(key, source.mFields.get(key));
        }
        this.mCaCerts = source.mCaCerts != null ? Arrays.copyOf(source.mCaCerts, source.mCaCerts.length) : null;
        this.mClientPrivateKey = source.mClientPrivateKey;
        this.mClientCertificateChain = source.mClientCertificateChain != null ? Arrays.copyOf(source.mClientCertificateChain, source.mClientCertificateChain.length) : null;
        this.mKeyChainAlias = source.mKeyChainAlias;
        this.mEapMethod = source.mEapMethod;
        this.mPhase2Method = source.mPhase2Method;
        this.mIsAppInstalledDeviceKeyAndCert = source.mIsAppInstalledDeviceKeyAndCert;
        this.mIsAppInstalledCaCert = source.mIsAppInstalledCaCert;
        this.mOcsp = source.mOcsp;
        this.mIsTrustOnFirstUseEnabled = source.mIsTrustOnFirstUseEnabled;
        this.mUserApproveNoCaCert = source.mUserApproveNoCaCert;
        this.mSelectedRcoi = source.mSelectedRcoi;
        this.mMinimumTlsVersion = source.mMinimumTlsVersion;
        this.mIsStrictConservativePeerMode = source.mIsStrictConservativePeerMode;
        this.mTofuDialogState = source.mTofuDialogState;
        this.mTofuConnectionState = source.mTofuConnectionState;
    }

    public WifiEnterpriseConfig(WifiEnterpriseConfig source) {
        this.copyFrom(source, false, "");
    }

    public void copyFromExternal(WifiEnterpriseConfig externalConfig, String mask) {
        this.copyFrom(externalConfig, true, this.convertToQuotedString(mask));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeBundle(this.fieldMapToBundle());
        dest.writeInt(this.mEapMethod);
        dest.writeInt(this.mPhase2Method);
        ParcelUtil.writeCertificates(dest, this.mCaCerts);
        ParcelUtil.writePrivateKey(dest, this.mClientPrivateKey);
        ParcelUtil.writeCertificates(dest, this.mClientCertificateChain);
        dest.writeString(this.mKeyChainAlias);
        dest.writeBoolean(this.mIsAppInstalledDeviceKeyAndCert);
        dest.writeBoolean(this.mIsAppInstalledCaCert);
        dest.writeInt(this.mOcsp);
        dest.writeBoolean(this.mIsTrustOnFirstUseEnabled);
        dest.writeBoolean(this.mUserApproveNoCaCert);
        dest.writeInt(this.mMinimumTlsVersion);
        dest.writeInt(this.mTofuDialogState);
        dest.writeInt(this.mTofuConnectionState);
    }

    public boolean saveToSupplicant(SupplicantSaver saver) {
        String value;
        if (!this.isEapMethodValid()) {
            return false;
        }
        boolean shouldNotWriteAnonIdentity = this.mEapMethod == 4 || this.mEapMethod == 5 || this.mEapMethod == 6;
        for (String key : this.mFields.keySet()) {
            if (!WifiEnterpriseConfig.isFieldValid(key, value = this.mFields.get(key)) || shouldNotWriteAnonIdentity && ANON_IDENTITY_KEY.equals(key) || saver.saveValue(key, value)) continue;
            return false;
        }
        if (!saver.saveValue(EAP_KEY, Eap.strings[this.mEapMethod])) {
            return false;
        }
        if (this.mEapMethod != 1 && this.mEapMethod != 7 && this.mPhase2Method != 0) {
            boolean is_autheap = this.mEapMethod == 2 && this.mPhase2Method == 4;
            String prefix = is_autheap ? "autheap=" : "auth=";
            value = this.convertToQuotedString(prefix + Phase2.strings[this.mPhase2Method]);
            return saver.saveValue(PHASE2_KEY, value);
        }
        if (this.mPhase2Method == 0) {
            return saver.saveValue(PHASE2_KEY, null);
        }
        Log.e(TAG, "WiFi enterprise configuration is invalid as it supplies a phase 2 method but the phase1 method does not support it.");
        return false;
    }

    public void loadFromSupplicant(SupplicantLoader loader) {
        for (String key : SUPPLICANT_CONFIG_KEYS) {
            String value = loader.loadValue(key);
            if (!WifiEnterpriseConfig.isFieldValid(key, value)) continue;
            if (value == null) {
                this.mFields.put(key, EMPTY_VALUE);
                continue;
            }
            this.mFields.put(key, value);
        }
        String eapMethod = loader.loadValue(EAP_KEY);
        this.mEapMethod = this.getStringIndex(Eap.strings, eapMethod, -1);
        String phase2Method = this.removeDoubleQuotes(loader.loadValue(PHASE2_KEY));
        if (phase2Method.startsWith("auth=")) {
            phase2Method = phase2Method.substring("auth=".length());
        } else if (phase2Method.startsWith("autheap=")) {
            phase2Method = phase2Method.substring("autheap=".length());
        }
        this.mPhase2Method = this.getStringIndex(Phase2.strings, phase2Method, 0);
    }

    public void setEapMethod(int eapMethod) {
        switch (eapMethod) {
            case 8: {
                this.mEapMethod = eapMethod;
                this.setPhase2Method(0);
                break;
            }
            case 1: 
            case 7: {
                this.setPhase2Method(0);
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.mEapMethod = eapMethod;
                this.setFieldValue(OPP_KEY_CACHING, ENGINE_ENABLE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown EAP method");
            }
        }
    }

    public int getEapMethod() {
        return this.mEapMethod;
    }

    public void setPhase2Method(int phase2Method) {
        switch (phase2Method) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.mPhase2Method = phase2Method;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Phase 2 method");
            }
        }
    }

    public int getPhase2Method() {
        return this.mPhase2Method;
    }

    public void setIdentity(String identity) {
        this.setFieldValue(IDENTITY_KEY, identity, "");
    }

    public String getIdentity() {
        return this.getFieldValue(IDENTITY_KEY);
    }

    public void setAnonymousIdentity(String anonymousIdentity) {
        this.setFieldValue(ANON_IDENTITY_KEY, anonymousIdentity);
    }

    public String getAnonymousIdentity() {
        return this.getFieldValue(ANON_IDENTITY_KEY);
    }

    public void setPassword(String password) {
        this.setFieldValue(PASSWORD_KEY, password);
    }

    public String getPassword() {
        return this.getFieldValue(PASSWORD_KEY);
    }

    public static String encodeCaCertificateAlias(String alias) {
        byte[] bytes = alias.getBytes(StandardCharsets.UTF_8);
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte o : bytes) {
            sb.append(String.format("%02x", o & 0xFF));
        }
        return sb.toString();
    }

    public static String decodeCaCertificateAlias(String alias) {
        byte[] data = new byte[alias.length() >> 1];
        int n = 0;
        int position = 0;
        while (n < alias.length()) {
            data[position] = (byte)Integer.parseInt(alias.substring(n, n + 2), 16);
            n += 2;
            ++position;
        }
        try {
            return new String(data, StandardCharsets.UTF_8);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return alias;
        }
    }

    public void setServerCertificateHash(String certHash) {
        this.setFieldValue(CA_CERT_KEY, certHash, CERT_HASH_PREFIX);
    }

    @UnsupportedAppUsage
    public void setCaCertificateAlias(String alias) {
        this.setFieldValue(CA_CERT_KEY, alias, CA_CERT_PREFIX);
    }

    @SystemApi
    public void setCaCertificateAliases(@Nullable String[] aliases) {
        if (aliases == null) {
            this.setFieldValue(CA_CERT_KEY, null, CA_CERT_PREFIX);
        } else if (aliases.length == 1) {
            this.setCaCertificateAlias(aliases[0]);
        } else {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < aliases.length; ++i) {
                if (i > 0) {
                    sb.append(CA_CERT_ALIAS_DELIMITER);
                }
                sb.append(WifiEnterpriseConfig.encodeCaCertificateAlias(CA_CERTIFICATE + aliases[i]));
            }
            this.setFieldValue(CA_CERT_KEY, sb.toString(), KEYSTORES_URI);
        }
    }

    public boolean hasCaCertificate() {
        if (this.getCaCertificateAliases() != null) {
            return true;
        }
        if (this.getCaCertificates() != null) {
            return true;
        }
        return !TextUtils.isEmpty(this.getCaPath());
    }

    @UnsupportedAppUsage
    public String getCaCertificateAlias() {
        return this.getFieldValue(CA_CERT_KEY, CA_CERT_PREFIX);
    }

    @SystemApi
    @Nullable
    public String[] getCaCertificateAliases() {
        String[] stringArray;
        String value = this.getFieldValue(CA_CERT_KEY);
        if (value.startsWith(CA_CERT_PREFIX)) {
            return new String[]{this.getFieldValue(CA_CERT_KEY, CA_CERT_PREFIX)};
        }
        if (value.startsWith(KEYSTORES_URI)) {
            String values = value.substring(KEYSTORES_URI.length());
            String[] aliases = TextUtils.split(values, CA_CERT_ALIAS_DELIMITER);
            for (int i = 0; i < aliases.length; ++i) {
                aliases[i] = WifiEnterpriseConfig.decodeCaCertificateAlias(aliases[i]);
                if (!aliases[i].startsWith(CA_CERTIFICATE)) continue;
                aliases[i] = aliases[i].substring(CA_CERTIFICATE.length());
            }
            return aliases.length != 0 ? aliases : null;
        }
        if (TextUtils.isEmpty(value)) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = value;
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCaCertificate(@Nullable X509Certificate cert) {
        if (cert == null) {
            this.mCaCerts = null;
            return;
        }
        if (cert.getBasicConstraints() >= 0) {
            this.mIsAppInstalledCaCert = true;
            this.mCaCerts = new X509Certificate[]{cert};
            return;
        }
        this.mCaCerts = null;
        throw new IllegalArgumentException("Not a CA certificate");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCaCertificateForTrustOnFirstUse(@Nullable X509Certificate cert) {
        if (cert == null) {
            this.mCaCerts = null;
            return;
        }
        if (this.isTrustOnFirstUseEnabled()) {
            this.mIsAppInstalledCaCert = true;
            this.mCaCerts = new X509Certificate[]{cert};
            return;
        }
        this.mCaCerts = null;
        throw new IllegalArgumentException("Trust on First Use is not enabled.");
    }

    @Nullable
    public X509Certificate getCaCertificate() {
        if (this.mCaCerts != null && this.mCaCerts.length > 0) {
            return this.mCaCerts[0];
        }
        return null;
    }

    public void setCaCertificates(@Nullable X509Certificate[] certs) {
        if (certs != null) {
            if (certs.length > 100) {
                this.mCaCerts = null;
                throw new IllegalArgumentException("List of CA certificates contains more than the allowed number of elements");
            }
            X509Certificate[] newCerts = new X509Certificate[certs.length];
            for (int i = 0; i < certs.length; ++i) {
                if (certs[i].getBasicConstraints() < 0) {
                    this.mCaCerts = null;
                    throw new IllegalArgumentException("Not a CA certificate");
                }
                newCerts[i] = certs[i];
            }
            this.mCaCerts = newCerts;
            this.mIsAppInstalledCaCert = true;
        } else {
            this.mCaCerts = null;
        }
    }

    @Nullable
    public X509Certificate[] getCaCertificates() {
        if (this.mCaCerts != null && this.mCaCerts.length > 0) {
            return this.mCaCerts;
        }
        return null;
    }

    public void resetCaCertificate() {
        this.mCaCerts = null;
    }

    @SystemApi
    public void setCaPath(@NonNull String path) {
        this.setFieldValue(CA_PATH_KEY, path);
    }

    @SystemApi
    @NonNull
    public String getCaPath() {
        return this.getFieldValue(CA_PATH_KEY);
    }

    @SystemApi
    public void setClientCertificateAlias(@NonNull String alias) {
        this.setFieldValue(CLIENT_CERT_KEY, alias, CLIENT_CERT_PREFIX);
        this.setFieldValue(PRIVATE_KEY_ID_KEY, alias, USER_PRIVATE_KEY);
        if (TextUtils.isEmpty(alias)) {
            this.setFieldValue(ENGINE_KEY, ENGINE_DISABLE);
            this.setFieldValue(ENGINE_ID_KEY, "");
        } else {
            this.setFieldValue(ENGINE_KEY, ENGINE_ENABLE);
            this.setFieldValue(ENGINE_ID_KEY, ENGINE_ID_KEYSTORE);
        }
    }

    @SystemApi
    @NonNull
    public String getClientCertificateAlias() {
        return this.getFieldValue(CLIENT_CERT_KEY, CLIENT_CERT_PREFIX);
    }

    public void setClientKeyEntry(PrivateKey privateKey, X509Certificate clientCertificate) {
        X509Certificate[] clientCertificates = null;
        if (clientCertificate != null) {
            clientCertificates = new X509Certificate[]{clientCertificate};
        }
        this.setClientKeyEntryWithCertificateChain(privateKey, clientCertificates);
    }

    public void setClientKeyEntryWithCertificateChain(PrivateKey privateKey, X509Certificate[] clientCertificateChain) {
        X509Certificate[] newCerts = null;
        if (clientCertificateChain != null && clientCertificateChain.length > 0) {
            if (clientCertificateChain.length > 5) {
                throw new IllegalArgumentException("Certificate chain contains more than the allowed number of elements");
            }
            if (clientCertificateChain[0].getBasicConstraints() != -1) {
                throw new IllegalArgumentException("First certificate in the chain must be a client end certificate");
            }
            for (int i = 1; i < clientCertificateChain.length; ++i) {
                if (clientCertificateChain[i].getBasicConstraints() != -1) continue;
                throw new IllegalArgumentException("All certificates following the first must be CA certificates");
            }
            newCerts = Arrays.copyOf(clientCertificateChain, clientCertificateChain.length);
            if (privateKey == null) {
                throw new IllegalArgumentException("Client cert without a private key");
            }
            byte[] encodedKey = privateKey.getEncoded();
            if (encodedKey == null) {
                throw new IllegalArgumentException("Private key cannot be encoded");
            }
            if (encodedKey.length > 8192) {
                throw new IllegalArgumentException("Private key exceeds the maximum allowed length");
            }
        }
        this.mClientPrivateKey = privateKey;
        this.mClientCertificateChain = newCerts;
        this.mIsAppInstalledDeviceKeyAndCert = true;
    }

    @RequiresApi(value=31)
    public void setClientKeyPairAlias(@NonNull String alias) {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        if (!WifiEnterpriseConfig.isFieldLengthValid(alias, 256)) {
            throw new IllegalArgumentException();
        }
        this.mKeyChainAlias = alias;
    }

    @RequiresApi(value=31)
    @Nullable
    public String getClientKeyPairAlias() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        return this.mKeyChainAlias;
    }

    @Nullable
    public String getClientKeyPairAliasInternal() {
        return this.mKeyChainAlias;
    }

    public X509Certificate getClientCertificate() {
        if (this.mClientCertificateChain != null && this.mClientCertificateChain.length > 0) {
            return this.mClientCertificateChain[0];
        }
        return null;
    }

    @Nullable
    public X509Certificate[] getClientCertificateChain() {
        if (this.mClientCertificateChain != null && this.mClientCertificateChain.length > 0) {
            return this.mClientCertificateChain;
        }
        return null;
    }

    public void resetClientKeyEntry() {
        this.mClientPrivateKey = null;
        this.mClientCertificateChain = null;
    }

    @Nullable
    public PrivateKey getClientPrivateKey() {
        return this.mClientPrivateKey;
    }

    public void setSubjectMatch(String subjectMatch) {
        this.setFieldValue(SUBJECT_MATCH_KEY, subjectMatch);
    }

    public String getSubjectMatch() {
        return this.getFieldValue(SUBJECT_MATCH_KEY);
    }

    public void setAltSubjectMatch(String altSubjectMatch) {
        this.setFieldValue(ALTSUBJECT_MATCH_KEY, altSubjectMatch);
    }

    public String getAltSubjectMatch() {
        return this.getFieldValue(ALTSUBJECT_MATCH_KEY);
    }

    public void setDomainSuffixMatch(String domain) {
        this.setFieldValue(DOM_SUFFIX_MATCH_KEY, domain);
    }

    public String getDomainSuffixMatch() {
        return this.getFieldValue(DOM_SUFFIX_MATCH_KEY);
    }

    public void setRealm(String realm) {
        this.setFieldValue(REALM_KEY, realm);
    }

    public String getRealm() {
        return this.getFieldValue(REALM_KEY);
    }

    public void setSelectedRcoi(long selectedRcoi) {
        this.mSelectedRcoi = selectedRcoi;
    }

    public long getSelectedRcoi() {
        return this.mSelectedRcoi;
    }

    public void setStrictConservativePeerMode(boolean enable) {
        this.mIsStrictConservativePeerMode = enable;
    }

    public boolean getStrictConservativePeerMode() {
        return this.mIsStrictConservativePeerMode;
    }

    public void setPlmn(String plmn) {
        this.setFieldValue(PLMN_KEY, plmn);
    }

    public String getPlmn() {
        return this.getFieldValue(PLMN_KEY);
    }

    public String getKeyId(WifiEnterpriseConfig current) {
        if (this.mEapMethod == -1) {
            return current != null ? current.getKeyId(null) : EMPTY_VALUE;
        }
        if (!this.isEapMethodValid()) {
            return EMPTY_VALUE;
        }
        return Eap.strings[this.mEapMethod] + "_" + Phase2.strings[this.mPhase2Method];
    }

    private String removeDoubleQuotes(String string2) {
        if (TextUtils.isEmpty(string2)) {
            return "";
        }
        int length = string2.length();
        if (length > 1 && string2.charAt(0) == '\"' && string2.charAt(length - 1) == '\"') {
            return string2.substring(1, length - 1);
        }
        return string2;
    }

    private String convertToQuotedString(String string2) {
        return "\"" + string2 + "\"";
    }

    private int getStringIndex(String[] arr, String toBeFound, int defaultIndex) {
        if (TextUtils.isEmpty(toBeFound)) {
            return defaultIndex;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (!toBeFound.equals(arr[i])) continue;
            return i;
        }
        return defaultIndex;
    }

    private String getFieldValue(String key, String prefix) {
        if (!WifiEnterpriseConfig.isKeySupported(key)) {
            return "";
        }
        String value = this.mFields.get(key);
        if (TextUtils.isEmpty(value) || EMPTY_VALUE.equals(value)) {
            return "";
        }
        if ((value = this.removeDoubleQuotes(value)).startsWith(prefix)) {
            return value.substring(prefix.length());
        }
        return value;
    }

    public String getFieldValue(String key) {
        return this.getFieldValue(key, "");
    }

    private void setFieldValue(String key, String value, String prefix) {
        if (!WifiEnterpriseConfig.isFieldValid(key, value)) {
            return;
        }
        if (TextUtils.isEmpty(value)) {
            this.mFields.put(key, EMPTY_VALUE);
        } else {
            String valueToSet = !UNQUOTED_KEYS.contains(key) ? this.convertToQuotedString(prefix + value) : prefix + value;
            this.mFields.put(key, valueToSet);
        }
    }

    public void setFieldValue(String key, String value) {
        this.setFieldValue(key, value, "");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String key : this.mFields.keySet()) {
            String value = PASSWORD_KEY.equals(key) ? "<removed>" : this.mFields.get(key);
            sb.append(key).append(CA_CERT_ALIAS_DELIMITER).append(value).append("\n");
        }
        if (this.mEapMethod >= 0 && this.mEapMethod < Eap.strings.length) {
            sb.append("eap_method: ").append(Eap.strings[this.mEapMethod]).append("\n");
        }
        if (this.mPhase2Method > 0 && this.mPhase2Method < Phase2.strings.length) {
            sb.append("phase2_method: ").append(Phase2.strings[this.mPhase2Method]).append("\n");
        }
        sb.append(" ocsp: ").append(this.mOcsp).append("\n");
        sb.append(" trust_on_first_use: ").append(this.mIsTrustOnFirstUseEnabled).append("\n");
        sb.append(" user_approve_no_ca_cert: ").append(this.mUserApproveNoCaCert).append("\n");
        sb.append(" selected_rcoi: ").append(this.mSelectedRcoi).append("\n");
        sb.append(" minimum_tls_version: ").append(this.mMinimumTlsVersion).append("\n");
        sb.append(" enable_conservative_peer_mode: ").append(this.mIsStrictConservativePeerMode).append("\n");
        sb.append(" tofu_dialog_state: ").append(this.mTofuDialogState).append("\n");
        sb.append(" tofu_connection_state: ").append(this.mTofuConnectionState).append("\n");
        return sb.toString();
    }

    private boolean isEapMethodValid() {
        if (this.mEapMethod == -1) {
            Log.e(TAG, "WiFi enterprise configuration is invalid as it supplies no EAP method.");
            return false;
        }
        if (this.mEapMethod < 0 || this.mEapMethod >= Eap.strings.length) {
            Log.e(TAG, "mEapMethod is invald for WiFi enterprise configuration: " + this.mEapMethod);
            return false;
        }
        if (this.mPhase2Method < 0 || this.mPhase2Method >= Phase2.strings.length) {
            Log.e(TAG, "mPhase2Method is invald for WiFi enterprise configuration: " + this.mPhase2Method);
            return false;
        }
        return true;
    }

    public boolean isAppInstalledDeviceKeyAndCert() {
        return this.mIsAppInstalledDeviceKeyAndCert;
    }

    public void initIsAppInstalledDeviceKeyAndCert(boolean isAppInstalledDeviceKeyAndCert) {
        this.mIsAppInstalledDeviceKeyAndCert = isAppInstalledDeviceKeyAndCert;
    }

    public boolean isAppInstalledCaCert() {
        return this.mIsAppInstalledCaCert;
    }

    public void initIsAppInstalledCaCert(boolean isAppInstalledCaCert) {
        this.mIsAppInstalledCaCert = isAppInstalledCaCert;
    }

    @SystemApi
    public void setOcsp(int ocsp) {
        if (ocsp < 0 || ocsp > 3) {
            throw new IllegalArgumentException("Invalid OCSP type.");
        }
        this.mOcsp = ocsp;
    }

    @SystemApi
    public int getOcsp() {
        return this.mOcsp;
    }

    public boolean isAuthenticationSimBased() {
        if (this.mEapMethod == 4 || this.mEapMethod == 5 || this.mEapMethod == 6) {
            return true;
        }
        if (this.mEapMethod == 0) {
            return this.mPhase2Method == 5 || this.mPhase2Method == 6 || this.mPhase2Method == 7;
        }
        return false;
    }

    @SystemApi
    public void setWapiCertSuite(@NonNull String wapiCertSuite) {
        this.setFieldValue(WAPI_CERT_SUITE_KEY, wapiCertSuite);
    }

    @SystemApi
    @NonNull
    public String getWapiCertSuite() {
        return this.getFieldValue(WAPI_CERT_SUITE_KEY);
    }

    public boolean isEapMethodServerCertUsed() {
        return this.mEapMethod == 0 || this.mEapMethod == 1 || this.mEapMethod == 2 || this.mEapMethod == 7;
    }

    public boolean isServerCertValidationEnabled() {
        if (!this.isEapMethodServerCertUsed()) {
            throw new IllegalStateException("Configuration doesn't use server certificates for authentication");
        }
        return this.isMandatoryParameterSetForServerCertValidation();
    }

    public boolean isMandatoryParameterSetForServerCertValidation() {
        if (TextUtils.isEmpty(this.getAltSubjectMatch()) && TextUtils.isEmpty(this.getDomainSuffixMatch())) {
            return false;
        }
        if (this.mIsAppInstalledCaCert) {
            return true;
        }
        if (this.getCaCertificateAliases() != null) {
            return true;
        }
        return !TextUtils.isEmpty(this.getCaPath());
    }

    public static boolean isSuiteBCipherCert(@Nullable X509Certificate x509Certificate) {
        ECPublicKey ecPublicKey;
        ECParameterSpec ecParameterSpec;
        RSAPublicKey rsaPublicKey;
        if (x509Certificate == null) {
            return false;
        }
        String sigAlgOid = x509Certificate.getSigAlgOID();
        return sigAlgOid.equals("1.2.840.113549.1.1.12") ? x509Certificate.getPublicKey() instanceof RSAPublicKey && (rsaPublicKey = (RSAPublicKey)x509Certificate.getPublicKey()).getModulus() != null && rsaPublicKey.getModulus().bitLength() >= 3072 : sigAlgOid.equals("1.2.840.10045.4.3.3") && x509Certificate.getPublicKey() instanceof ECPublicKey && (ecParameterSpec = (ecPublicKey = (ECPublicKey)x509Certificate.getPublicKey()).getParams()) != null && ecParameterSpec.getOrder() != null && ecParameterSpec.getOrder().bitLength() >= 384;
    }

    @RequiresApi(value=31)
    public void setDecoratedIdentityPrefix(@Nullable String decoratedIdentityPrefix) {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        if (!TextUtils.isEmpty(decoratedIdentityPrefix) && !decoratedIdentityPrefix.endsWith("!")) {
            throw new IllegalArgumentException("Decorated identity prefix must be delimited by '!'");
        }
        this.setFieldValue(DECORATED_IDENTITY_PREFIX_KEY, decoratedIdentityPrefix);
    }

    @RequiresApi(value=31)
    @Nullable
    public String getDecoratedIdentityPrefix() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        String decoratedId = this.getFieldValue(DECORATED_IDENTITY_PREFIX_KEY);
        return decoratedId.isEmpty() ? null : decoratedId;
    }

    public void enableTrustOnFirstUse(boolean enable) {
        this.mIsTrustOnFirstUseEnabled = enable;
        if (this.mTofuConnectionState != 2 && this.mTofuConnectionState != 3) {
            this.mTofuConnectionState = enable ? 1 : 0;
        }
    }

    public boolean isTrustOnFirstUseEnabled() {
        return this.mIsTrustOnFirstUseEnabled;
    }

    public void setTofuConnectionState(int state) {
        if (state < 0 || state > 3) {
            Log.e(TAG, "Invalid TOFU connection state received. state=" + state);
            return;
        }
        this.mTofuConnectionState = state;
    }

    public int getTofuConnectionState() {
        return this.mTofuConnectionState;
    }

    public void setTofuDialogApproved(boolean approved) {
        this.mTofuDialogState = approved ? 2 : 1;
    }

    public void setTofuDialogState(int state) {
        if (state < 0 || state > 2) {
            Log.e(TAG, "Invalid TOFU dialog state received. state=" + state);
            return;
        }
        this.mTofuDialogState = state;
    }

    public int getTofuDialogState() {
        return this.mTofuDialogState;
    }

    public void setUserApproveNoCaCert(boolean approved) {
        this.mUserApproveNoCaCert = approved;
    }

    public boolean isUserApproveNoCaCert() {
        return this.mUserApproveNoCaCert;
    }

    public void setMinimumTlsVersion(int tlsVersion) throws IllegalArgumentException {
        if (tlsVersion < 0 || tlsVersion > 3) {
            throw new IllegalArgumentException("Invalid TLS version: " + tlsVersion);
        }
        this.mMinimumTlsVersion = tlsVersion;
    }

    public int getMinimumTlsVersion() {
        return this.mMinimumTlsVersion;
    }

    public static class Eap {
        public static final int NONE = -1;
        public static final int PEAP = 0;
        public static final int TLS = 1;
        public static final int TTLS = 2;
        public static final int PWD = 3;
        public static final int SIM = 4;
        public static final int AKA = 5;
        public static final int AKA_PRIME = 6;
        public static final int UNAUTH_TLS = 7;
        public static final int WAPI_CERT = 8;
        public static final String[] strings = new String[]{"PEAP", "TLS", "TTLS", "PWD", "SIM", "AKA", "AKA'", "WFA-UNAUTH-TLS", "WAPI_CERT"};

        private Eap() {
        }
    }

    public static class Phase2 {
        public static final int NONE = 0;
        public static final int PAP = 1;
        public static final int MSCHAP = 2;
        public static final int MSCHAPV2 = 3;
        public static final int GTC = 4;
        public static final int SIM = 5;
        public static final int AKA = 6;
        public static final int AKA_PRIME = 7;
        private static final String AUTH_PREFIX = "auth=";
        private static final String AUTHEAP_PREFIX = "autheap=";
        public static final String[] strings = new String[]{"NULL", "PAP", "MSCHAP", "MSCHAPV2", "GTC", "SIM", "AKA", "AKA'"};

        private Phase2() {
        }
    }

    public static interface SupplicantSaver {
        public boolean saveValue(String var1, String var2);
    }

    public static interface SupplicantLoader {
        public String loadValue(String var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TofuDialogState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TofuConnectionState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TlsVersion {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Ocsp {
    }
}

