/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.wifi.QosCharacteristics;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
public class QosPolicyParams
implements Parcelable {
    private static final String TAG = "QosPolicyParams";
    public static final int DSCP_ANY = -1;
    public static final int PROTOCOL_ANY = -1;
    public static final int PROTOCOL_TCP = 6;
    public static final int PROTOCOL_UDP = 17;
    public static final int PROTOCOL_ESP = 50;
    public static final int DIRECTION_UPLINK = 0;
    public static final int DIRECTION_DOWNLINK = 1;
    public static final int USER_PRIORITY_ANY = -1;
    public static final int USER_PRIORITY_BACKGROUND_LOW = 1;
    public static final int USER_PRIORITY_BACKGROUND_HIGH = 2;
    public static final int USER_PRIORITY_BEST_EFFORT_LOW = 0;
    public static final int USER_PRIORITY_BEST_EFFORT_HIGH = 3;
    public static final int USER_PRIORITY_VIDEO_LOW = 4;
    public static final int USER_PRIORITY_VIDEO_HIGH = 5;
    public static final int USER_PRIORITY_VOICE_LOW = 6;
    public static final int USER_PRIORITY_VOICE_HIGH = 7;
    public static final int IP_VERSION_ANY = -1;
    public static final int IP_VERSION_4 = 4;
    public static final int IP_VERSION_6 = 6;
    public static final int DESTINATION_PORT_ANY = -1;
    private final int mPolicyId;
    private int mTranslatedPolicyId;
    private final int mDscp;
    private final int mUserPriority;
    @Nullable
    private final InetAddress mSrcIp;
    @Nullable
    private final InetAddress mDstIp;
    private final int mSrcPort;
    private final int mProtocol;
    private final int mDstPort;
    @Nullable
    private final int[] mDstPortRange;
    private final int mDirection;
    private final int mIpVersion;
    @Nullable
    private final byte[] mFlowLabel;
    @Nullable
    private final QosCharacteristics mQosCharacteristics;
    @NonNull
    public static final Parcelable.Creator<QosPolicyParams> CREATOR = new Parcelable.Creator<QosPolicyParams>(){

        @Override
        public QosPolicyParams createFromParcel(Parcel in) {
            return new QosPolicyParams(in);
        }

        public QosPolicyParams[] newArray(int size) {
            return new QosPolicyParams[size];
        }
    };

    private QosPolicyParams(int policyId, int dscp, int userPriority, @Nullable InetAddress srcIp, @Nullable InetAddress dstIp, int srcPort, int protocol, @Nullable int[] dstPortRange, int direction, int ipVersion, int dstPort, @Nullable byte[] flowLabel, @Nullable QosCharacteristics qosCharacteristics) {
        this.mPolicyId = policyId;
        this.mDscp = dscp;
        this.mUserPriority = userPriority;
        this.mSrcIp = srcIp;
        this.mDstIp = dstIp;
        this.mSrcPort = srcPort;
        this.mProtocol = protocol;
        this.mDstPort = dstPort;
        this.mDstPortRange = dstPortRange;
        this.mDirection = direction;
        this.mIpVersion = ipVersion;
        this.mFlowLabel = flowLabel;
        this.mQosCharacteristics = qosCharacteristics;
    }

    public boolean validate() {
        if (this.mPolicyId < 1 || this.mPolicyId > 255) {
            Log.e(TAG, "Policy ID not in valid range: " + this.mPolicyId);
            return false;
        }
        if (this.mDscp < -1 || this.mDscp > 63) {
            Log.e(TAG, "DSCP value not in valid range: " + this.mDscp);
            return false;
        }
        if (this.mUserPriority < -1 || this.mUserPriority > 7) {
            Log.e(TAG, "User priority not in valid range: " + this.mUserPriority);
            return false;
        }
        if (this.mSrcPort < -1 || this.mSrcPort > 65535) {
            Log.e(TAG, "Source port not in valid range: " + this.mSrcPort);
            return false;
        }
        if (this.mDstPort < -1 || this.mDstPort > 65535) {
            Log.e(TAG, "Destination port not in valid range: " + this.mDstPort);
            return false;
        }
        if (this.mDstPortRange != null && (this.mDstPortRange[0] < 0 || this.mDstPortRange[0] > 65535 || this.mDstPortRange[1] < 0 || this.mDstPortRange[1] > 65535)) {
            Log.e(TAG, "Dst port range value not valid. start=" + this.mDstPortRange[0] + ", end=" + this.mDstPortRange[1]);
            return false;
        }
        if (this.mDirection != 0 && this.mDirection != 1) {
            Log.e(TAG, "Invalid direction enum: " + this.mDirection);
            return false;
        }
        if (this.mIpVersion != -1 && this.mIpVersion != 4 && this.mIpVersion != 6) {
            Log.e(TAG, "Invalid ipVersion enum: " + this.mIpVersion);
            return false;
        }
        if (this.mIpVersion == 4) {
            if (this.mSrcIp != null && !(this.mSrcIp instanceof Inet4Address)) {
                Log.e(TAG, "Src address does not match IP version " + this.mIpVersion);
                return false;
            }
            if (this.mDstIp != null && !(this.mDstIp instanceof Inet4Address)) {
                Log.e(TAG, "Dst address does not match IP version " + this.mIpVersion);
                return false;
            }
        }
        if (this.mIpVersion == 6) {
            if (this.mSrcIp != null && !(this.mSrcIp instanceof Inet6Address)) {
                Log.e(TAG, "Src address does not match IP version " + this.mIpVersion);
                return false;
            }
            if (this.mDstIp != null && !(this.mDstIp instanceof Inet6Address)) {
                Log.e(TAG, "Dst address does not match IP version " + this.mIpVersion);
                return false;
            }
        }
        if (this.mQosCharacteristics != null && !this.mQosCharacteristics.validate()) {
            Log.e(TAG, "Invalid QoS characteristics provided");
            return false;
        }
        if (this.mDirection == 0) {
            if (this.mQosCharacteristics == null) {
                Log.e(TAG, "QoS characteristics must be provided for uplink requests");
                return false;
            }
            if (this.mIpVersion != -1) {
                Log.e(TAG, "IP Version should not be set for uplink requests");
                return false;
            }
            if (this.mDstPort != -1) {
                Log.e(TAG, "Single destination port should not be set for uplink requests");
                return false;
            }
            if (this.mFlowLabel != null) {
                Log.e(TAG, "Flow label should not be set for uplink requests");
                return false;
            }
        } else {
            if (this.mUserPriority == -1) {
                Log.e(TAG, "User priority must be provided for downlink requests");
                return false;
            }
            if (this.mIpVersion == -1) {
                Log.e(TAG, "IP version must be provided for downlink requests");
                return false;
            }
            if (this.mDstPortRange != null) {
                Log.e(TAG, "Destination port range should not be set for downlink requests");
                return false;
            }
            if (this.mFlowLabel != null) {
                if (this.mIpVersion != 6) {
                    Log.e(TAG, "Flow label can only be used with IP version 6");
                    return false;
                }
                if (this.mFlowLabel.length != 3) {
                    Log.e(TAG, "Flow label must be of size 3, provided size is " + this.mFlowLabel.length);
                    return false;
                }
            }
        }
        return true;
    }

    public void setTranslatedPolicyId(int translatedPolicyId) {
        this.mTranslatedPolicyId = translatedPolicyId;
    }

    public int getPolicyId() {
        return this.mPolicyId;
    }

    public int getTranslatedPolicyId() {
        return this.mTranslatedPolicyId;
    }

    public int getDscp() {
        return this.mDscp;
    }

    public int getUserPriority() {
        return this.mUserPriority;
    }

    @Nullable
    public InetAddress getSourceAddress() {
        return this.mSrcIp;
    }

    @Nullable
    public InetAddress getDestinationAddress() {
        return this.mDstIp;
    }

    public int getSourcePort() {
        return this.mSrcPort;
    }

    public int getProtocol() {
        return this.mProtocol;
    }

    public int getDestinationPort() {
        return this.mDstPort;
    }

    @Nullable
    public int[] getDestinationPortRange() {
        return this.mDstPortRange;
    }

    public int getDirection() {
        return this.mDirection;
    }

    public int getIpVersion() {
        return this.mIpVersion;
    }

    @Nullable
    public byte[] getFlowLabel() {
        return this.mFlowLabel;
    }

    @RequiresApi(value=35)
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @Nullable
    public QosCharacteristics getQosCharacteristics() {
        if (!SdkLevel.isAtLeastV()) {
            throw new UnsupportedOperationException();
        }
        return this.mQosCharacteristics;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QosPolicyParams that = (QosPolicyParams)o;
        return this.mPolicyId == that.mPolicyId && this.mDscp == that.mDscp && this.mUserPriority == that.mUserPriority && ((Object)this.mSrcIp).equals(that.mSrcIp) && ((Object)this.mDstIp).equals(that.mDstIp) && this.mSrcPort == that.mSrcPort && this.mProtocol == that.mProtocol && this.mDstPort == that.mDstPort && Arrays.equals(this.mDstPortRange, that.mDstPortRange) && this.mDirection == that.mDirection && this.mIpVersion == that.mIpVersion && this.mFlowLabel == that.mFlowLabel && Objects.equals(this.mQosCharacteristics, that.mQosCharacteristics);
    }

    public int hashCode() {
        return Objects.hash(this.mPolicyId, this.mDscp, this.mUserPriority, this.mSrcIp, this.mDstIp, this.mSrcPort, this.mProtocol, Arrays.hashCode(this.mDstPortRange), this.mDirection, this.mIpVersion, this.mDstPort, Arrays.hashCode(this.mFlowLabel), this.mQosCharacteristics);
    }

    public String toString() {
        return "{policyId=" + this.mPolicyId + ", dscp=" + this.mDscp + ", userPriority=" + this.mUserPriority + ", srcIp=" + this.mSrcIp + ", dstIp=" + this.mDstIp + ", srcPort=" + this.mSrcPort + ", protocol=" + this.mProtocol + ", dstPort=" + this.mDstPort + ", dstPortRange=" + Arrays.toString(this.mDstPortRange) + ", direction=" + this.mDirection + ", ipVersion=" + this.mIpVersion + ", flowLabel=" + Arrays.toString(this.mFlowLabel) + ", qosCharacteristics=" + this.mQosCharacteristics + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private InetAddress getInetAddrOrNull(byte[] byteAddr) {
        if (byteAddr == null) {
            return null;
        }
        try {
            return InetAddress.getByAddress(byteAddr);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mPolicyId);
        dest.writeInt(this.mDscp);
        dest.writeInt(this.mUserPriority);
        dest.writeByteArray(this.mSrcIp != null ? this.mSrcIp.getAddress() : null);
        dest.writeByteArray(this.mDstIp != null ? this.mDstIp.getAddress() : null);
        dest.writeInt(this.mSrcPort);
        dest.writeInt(this.mProtocol);
        dest.writeInt(this.mDstPort);
        dest.writeIntArray(this.mDstPortRange);
        dest.writeInt(this.mDirection);
        dest.writeInt(this.mIpVersion);
        dest.writeByteArray(this.mFlowLabel);
        if (SdkLevel.isAtLeastV()) {
            dest.writeParcelable(this.mQosCharacteristics, 0);
        }
    }

    QosPolicyParams(@NonNull Parcel in) {
        this.mPolicyId = in.readInt();
        this.mDscp = in.readInt();
        this.mUserPriority = in.readInt();
        this.mSrcIp = this.getInetAddrOrNull(in.createByteArray());
        this.mDstIp = this.getInetAddrOrNull(in.createByteArray());
        this.mSrcPort = in.readInt();
        this.mProtocol = in.readInt();
        this.mDstPort = in.readInt();
        this.mDstPortRange = in.createIntArray();
        this.mDirection = in.readInt();
        this.mIpVersion = in.readInt();
        this.mFlowLabel = in.createByteArray();
        this.mQosCharacteristics = SdkLevel.isAtLeastV() ? in.readParcelable(QosCharacteristics.class.getClassLoader(), QosCharacteristics.class) : null;
    }

    public static class Builder {
        private final int mPolicyId;
        private final int mDirection;
        @Nullable
        private InetAddress mSrcIp;
        @Nullable
        private InetAddress mDstIp;
        private int mDscp = -1;
        private int mUserPriority = -1;
        private int mSrcPort = -1;
        private int mProtocol = -1;
        private int mDstPort = -1;
        @Nullable
        private int[] mDstPortRange;
        private int mIpVersion = -1;
        private byte[] mFlowLabel;
        @Nullable
        private QosCharacteristics mQosCharacteristics;

        public Builder(int policyId, int direction) {
            this.mPolicyId = policyId;
            this.mDirection = direction;
        }

        @NonNull
        public Builder setSourceAddress(@Nullable InetAddress value) {
            this.mSrcIp = value;
            return this;
        }

        @NonNull
        public Builder setDestinationAddress(@Nullable InetAddress value) {
            this.mDstIp = value;
            return this;
        }

        @NonNull
        public Builder setDscp(int value) {
            this.mDscp = value;
            return this;
        }

        @NonNull
        public Builder setUserPriority(int value) {
            this.mUserPriority = value;
            return this;
        }

        @NonNull
        public Builder setSourcePort(int value) {
            this.mSrcPort = value;
            return this;
        }

        @NonNull
        public Builder setProtocol(int value) {
            this.mProtocol = value;
            return this;
        }

        @NonNull
        public Builder setDestinationPort(int value) {
            this.mDstPort = value;
            return this;
        }

        @NonNull
        public Builder setDestinationPortRange(int start, int end) {
            this.mDstPortRange = new int[]{start, end};
            return this;
        }

        @NonNull
        public Builder setIpVersion(int value) {
            this.mIpVersion = value;
            return this;
        }

        @NonNull
        public Builder setFlowLabel(@Nullable byte[] value) {
            this.mFlowLabel = value;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @RequiresApi(value=35)
        @NonNull
        public Builder setQosCharacteristics(@Nullable QosCharacteristics qosCharacteristics) {
            if (!SdkLevel.isAtLeastV()) {
                throw new UnsupportedOperationException();
            }
            this.mQosCharacteristics = qosCharacteristics;
            return this;
        }

        @NonNull
        public QosPolicyParams build() {
            QosPolicyParams params = new QosPolicyParams(this.mPolicyId, this.mDscp, this.mUserPriority, this.mSrcIp, this.mDstIp, this.mSrcPort, this.mProtocol, this.mDstPortRange, this.mDirection, this.mIpVersion, this.mDstPort, this.mFlowLabel, this.mQosCharacteristics);
            if (!params.validate()) {
                throw new IllegalArgumentException("Provided parameters are invalid");
            }
            return params;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IpVersion {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UserPriority {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Direction {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Protocol {
    }
}

