/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ISubsystemRestartCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.ISubsystemRestartCallback";

    public void onSubsystemRestarting() throws RemoteException;

    public void onSubsystemRestarted() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISubsystemRestartCallback {
        static final int TRANSACTION_onSubsystemRestarting = 1;
        static final int TRANSACTION_onSubsystemRestarted = 2;

        public Stub() {
            this.attachInterface(this, ISubsystemRestartCallback.DESCRIPTOR);
        }

        public static ISubsystemRestartCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISubsystemRestartCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ISubsystemRestartCallback) {
                return (ISubsystemRestartCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onSubsystemRestarting";
                }
                case 2: {
                    return "onSubsystemRestarted";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISubsystemRestartCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    this.onSubsystemRestarting();
                    break;
                }
                case 2: {
                    this.onSubsystemRestarted();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements ISubsystemRestartCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISubsystemRestartCallback.DESCRIPTOR;
            }

            @Override
            public void onSubsystemRestarting() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISubsystemRestartCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onSubsystemRestarted() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISubsystemRestartCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISubsystemRestartCallback {
        @Override
        public void onSubsystemRestarting() throws RemoteException {
        }

        @Override
        public void onSubsystemRestarted() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

