/*
 * Decompiled with CFR 0.152.
 */
package android.net.vcn.persistablebundleutils;

import android.annotation.NonNull;
import android.net.ipsec.ike.IkeSessionParams;
import android.net.ipsec.ike.IkeTunnelConnectionParams;
import android.net.ipsec.ike.TunnelModeChildSessionParams;
import android.net.vcn.persistablebundleutils.IkeSessionParamsUtils;
import android.net.vcn.persistablebundleutils.TunnelModeChildSessionParamsUtils;
import android.os.PersistableBundle;
import java.util.Objects;

public class TunnelConnectionParamsUtils {
    private static final int EXPECTED_BUNDLE_KEY_CNT = 1;
    private static final String PARAMS_TYPE_IKE = "IKE";

    @NonNull
    public static PersistableBundle toPersistableBundle(@NonNull IkeTunnelConnectionParams params) {
        PersistableBundle result = new PersistableBundle();
        result.putPersistableBundle(PARAMS_TYPE_IKE, IkeTunnelConnectionParamsUtils.serializeIkeParams(params));
        return result;
    }

    @NonNull
    public static IkeTunnelConnectionParams fromPersistableBundle(@NonNull PersistableBundle in) {
        Objects.requireNonNull(in, "PersistableBundle was null");
        if (in.keySet().size() != 1) {
            throw new IllegalArgumentException(String.format("Expect PersistableBundle to have %d element but found: %s", 1, in.keySet()));
        }
        if (in.get(PARAMS_TYPE_IKE) != null) {
            return IkeTunnelConnectionParamsUtils.deserializeIkeParams(in.getPersistableBundle(PARAMS_TYPE_IKE));
        }
        throw new IllegalArgumentException("Invalid Tunnel Connection Params type " + in.keySet().iterator().next());
    }

    private static class IkeTunnelConnectionParamsUtils {
        private static final String IKE_PARAMS_KEY = "IKE_PARAMS_KEY";
        private static final String CHILD_PARAMS_KEY = "CHILD_PARAMS_KEY";

        private IkeTunnelConnectionParamsUtils() {
        }

        @NonNull
        public static PersistableBundle serializeIkeParams(@NonNull IkeTunnelConnectionParams ikeParams) {
            PersistableBundle result = new PersistableBundle();
            result.putPersistableBundle(IKE_PARAMS_KEY, IkeSessionParamsUtils.toPersistableBundle(ikeParams.getIkeSessionParams()));
            result.putPersistableBundle(CHILD_PARAMS_KEY, TunnelModeChildSessionParamsUtils.toPersistableBundle(ikeParams.getTunnelModeChildSessionParams()));
            return result;
        }

        @NonNull
        public static IkeTunnelConnectionParams deserializeIkeParams(@NonNull PersistableBundle in) {
            PersistableBundle ikeBundle = in.getPersistableBundle(IKE_PARAMS_KEY);
            PersistableBundle childBundle = in.getPersistableBundle(CHILD_PARAMS_KEY);
            Objects.requireNonNull(ikeBundle, "IkeSessionParams was null");
            Objects.requireNonNull(ikeBundle, "TunnelModeChildSessionParams was null");
            IkeSessionParams ikeParams = IkeSessionParamsUtils.fromPersistableBundle(ikeBundle);
            TunnelModeChildSessionParams childParams = TunnelModeChildSessionParamsUtils.fromPersistableBundle(childBundle);
            return new IkeTunnelConnectionParams(ikeParams, childParams);
        }
    }
}

