/*
 * Decompiled with CFR 0.152.
 */
package android.net.vcn;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.net.connectivity.android.net.vcn.util.PersistableBundleUtils;
import android.net.connectivity.android.util.IndentingPrintWriter;
import android.net.vcn.VcnUnderlyingNetworkTemplate;
import android.os.PersistableBundle;
import android.util.ArraySet;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class VcnCellUnderlyingNetworkTemplate
extends VcnUnderlyingNetworkTemplate {
    private static final String ALLOWED_NETWORK_PLMN_IDS_KEY = "mAllowedNetworkPlmnIds";
    @NonNull
    private final Set<String> mAllowedNetworkPlmnIds;
    private static final String ALLOWED_SPECIFIC_CARRIER_IDS_KEY = "mAllowedSpecificCarrierIds";
    @NonNull
    private final Set<Integer> mAllowedSpecificCarrierIds;
    private static final String ROAMING_MATCH_KEY = "mRoamingMatchCriteria";
    private static final int DEFAULT_ROAMING_MATCH_CRITERIA = 0;
    private final int mRoamingMatchCriteria;
    private static final String OPPORTUNISTIC_MATCH_KEY = "mOpportunisticMatchCriteria";
    private static final int DEFAULT_OPPORTUNISTIC_MATCH_CRITERIA = 0;
    private final int mOpportunisticMatchCriteria;
    private static final String CAPABILITIES_MATCH_CRITERIA_KEY = "mCapabilitiesMatchCriteria";
    @NonNull
    private final Map<Integer, Integer> mCapabilitiesMatchCriteria;
    private static final Map<Integer, Integer> CAPABILITIES_MATCH_CRITERIA_DEFAULT;

    private VcnCellUnderlyingNetworkTemplate(int meteredMatchCriteria, int minEntryUpstreamBandwidthKbps, int minExitUpstreamBandwidthKbps, int minEntryDownstreamBandwidthKbps, int minExitDownstreamBandwidthKbps, Set<String> allowedNetworkPlmnIds, Set<Integer> allowedSpecificCarrierIds, int roamingMatchCriteria, int opportunisticMatchCriteria, Map<Integer, Integer> capabilitiesMatchCriteria) {
        super(2, meteredMatchCriteria, minEntryUpstreamBandwidthKbps, minExitUpstreamBandwidthKbps, minEntryDownstreamBandwidthKbps, minExitDownstreamBandwidthKbps);
        this.mAllowedNetworkPlmnIds = new ArraySet<String>(allowedNetworkPlmnIds);
        this.mAllowedSpecificCarrierIds = new ArraySet<Integer>(allowedSpecificCarrierIds);
        this.mRoamingMatchCriteria = roamingMatchCriteria;
        this.mOpportunisticMatchCriteria = opportunisticMatchCriteria;
        this.mCapabilitiesMatchCriteria = new HashMap<Integer, Integer>(capabilitiesMatchCriteria);
        this.validate();
    }

    @Override
    protected void validate() {
        super.validate();
        VcnCellUnderlyingNetworkTemplate.validatePlmnIds(this.mAllowedNetworkPlmnIds);
        VcnCellUnderlyingNetworkTemplate.validateCapabilitiesMatchCriteria(this.mCapabilitiesMatchCriteria);
        Objects.requireNonNull(this.mAllowedSpecificCarrierIds, "matchingCarrierIds is null");
        VcnCellUnderlyingNetworkTemplate.validateMatchCriteria(this.mRoamingMatchCriteria, ROAMING_MATCH_KEY);
        VcnCellUnderlyingNetworkTemplate.validateMatchCriteria(this.mOpportunisticMatchCriteria, OPPORTUNISTIC_MATCH_KEY);
    }

    private static void validatePlmnIds(Set<String> matchingOperatorPlmnIds) {
        Objects.requireNonNull(matchingOperatorPlmnIds, "matchingOperatorPlmnIds is null");
        for (String id2 : matchingOperatorPlmnIds) {
            if ((id2.length() == 5 || id2.length() == 6) && id2.matches("[0-9]+")) continue;
            throw new IllegalArgumentException("Found invalid PLMN ID: " + id2);
        }
    }

    private static void validateCapabilitiesMatchCriteria(Map<Integer, Integer> capabilitiesMatchCriteria) {
        Objects.requireNonNull(capabilitiesMatchCriteria, "capabilitiesMatchCriteria is null");
        boolean requiredCapabilityFound = false;
        for (Map.Entry<Integer, Integer> entry : capabilitiesMatchCriteria.entrySet()) {
            int capability = entry.getKey();
            int matchCriteria = entry.getValue();
            Preconditions.checkArgument(CAPABILITIES_MATCH_CRITERIA_DEFAULT.containsKey(capability), "NetworkCapability " + capability + "out of range");
            VcnCellUnderlyingNetworkTemplate.validateMatchCriteria(matchCriteria, "capability " + capability);
            requiredCapabilityFound |= matchCriteria == 1;
        }
        if (!requiredCapabilityFound) {
            throw new IllegalArgumentException("No required capabilities found");
        }
    }

    @NonNull
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PROTECTED)
    public static VcnCellUnderlyingNetworkTemplate fromPersistableBundle(@NonNull PersistableBundle in) {
        Objects.requireNonNull(in, "PersistableBundle is null");
        int meteredMatchCriteria = in.getInt("mMeteredMatchCriteria");
        int minEntryUpstreamBandwidthKbps = in.getInt("mMinEntryUpstreamBandwidthKbps", 0);
        int minExitUpstreamBandwidthKbps = in.getInt("mMinExitUpstreamBandwidthKbps", 0);
        int minEntryDownstreamBandwidthKbps = in.getInt("mMinEntryDownstreamBandwidthKbps", 0);
        int minExitDownstreamBandwidthKbps = in.getInt("mMinExitDownstreamBandwidthKbps", 0);
        PersistableBundle plmnIdsBundle = in.getPersistableBundle(ALLOWED_NETWORK_PLMN_IDS_KEY);
        Objects.requireNonNull(plmnIdsBundle, "plmnIdsBundle is null");
        ArraySet<String> allowedNetworkPlmnIds = new ArraySet<String>(PersistableBundleUtils.toList(plmnIdsBundle, PersistableBundleUtils.STRING_DESERIALIZER));
        PersistableBundle specificCarrierIdsBundle = in.getPersistableBundle(ALLOWED_SPECIFIC_CARRIER_IDS_KEY);
        Objects.requireNonNull(specificCarrierIdsBundle, "specificCarrierIdsBundle is null");
        ArraySet<Integer> allowedSpecificCarrierIds = new ArraySet<Integer>(PersistableBundleUtils.toList(specificCarrierIdsBundle, PersistableBundleUtils.INTEGER_DESERIALIZER));
        PersistableBundle capabilitiesMatchCriteriaBundle = in.getPersistableBundle(CAPABILITIES_MATCH_CRITERIA_KEY);
        Map<Integer, Integer> capabilitiesMatchCriteria = capabilitiesMatchCriteriaBundle == null ? CAPABILITIES_MATCH_CRITERIA_DEFAULT : PersistableBundleUtils.toMap(capabilitiesMatchCriteriaBundle, PersistableBundleUtils.INTEGER_DESERIALIZER, PersistableBundleUtils.INTEGER_DESERIALIZER);
        int roamingMatchCriteria = in.getInt(ROAMING_MATCH_KEY);
        int opportunisticMatchCriteria = in.getInt(OPPORTUNISTIC_MATCH_KEY);
        return new VcnCellUnderlyingNetworkTemplate(meteredMatchCriteria, minEntryUpstreamBandwidthKbps, minExitUpstreamBandwidthKbps, minEntryDownstreamBandwidthKbps, minExitDownstreamBandwidthKbps, allowedNetworkPlmnIds, allowedSpecificCarrierIds, roamingMatchCriteria, opportunisticMatchCriteria, capabilitiesMatchCriteria);
    }

    @Override
    @NonNull
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PROTECTED)
    public PersistableBundle toPersistableBundle() {
        PersistableBundle result = super.toPersistableBundle();
        PersistableBundle plmnIdsBundle = PersistableBundleUtils.fromList(new ArrayList<String>(this.mAllowedNetworkPlmnIds), PersistableBundleUtils.STRING_SERIALIZER);
        result.putPersistableBundle(ALLOWED_NETWORK_PLMN_IDS_KEY, plmnIdsBundle);
        PersistableBundle specificCarrierIdsBundle = PersistableBundleUtils.fromList(new ArrayList<Integer>(this.mAllowedSpecificCarrierIds), PersistableBundleUtils.INTEGER_SERIALIZER);
        result.putPersistableBundle(ALLOWED_SPECIFIC_CARRIER_IDS_KEY, specificCarrierIdsBundle);
        PersistableBundle capabilitiesMatchCriteriaBundle = PersistableBundleUtils.fromMap(this.mCapabilitiesMatchCriteria, PersistableBundleUtils.INTEGER_SERIALIZER, PersistableBundleUtils.INTEGER_SERIALIZER);
        result.putPersistableBundle(CAPABILITIES_MATCH_CRITERIA_KEY, capabilitiesMatchCriteriaBundle);
        result.putInt(ROAMING_MATCH_KEY, this.mRoamingMatchCriteria);
        result.putInt(OPPORTUNISTIC_MATCH_KEY, this.mOpportunisticMatchCriteria);
        return result;
    }

    @NonNull
    public Set<String> getOperatorPlmnIds() {
        return Collections.unmodifiableSet(this.mAllowedNetworkPlmnIds);
    }

    @NonNull
    public Set<Integer> getSimSpecificCarrierIds() {
        return Collections.unmodifiableSet(this.mAllowedSpecificCarrierIds);
    }

    public int getRoaming() {
        return this.mRoamingMatchCriteria;
    }

    public int getOpportunistic() {
        return this.mOpportunisticMatchCriteria;
    }

    public int getCbs() {
        return this.mCapabilitiesMatchCriteria.get(5);
    }

    public int getDun() {
        return this.mCapabilitiesMatchCriteria.get(2);
    }

    public int getIms() {
        return this.mCapabilitiesMatchCriteria.get(4);
    }

    public int getInternet() {
        return this.mCapabilitiesMatchCriteria.get(12);
    }

    public int getMms() {
        return this.mCapabilitiesMatchCriteria.get(0);
    }

    public int getRcs() {
        return this.mCapabilitiesMatchCriteria.get(8);
    }

    @Override
    public Map<Integer, Integer> getCapabilitiesMatchCriteria() {
        return Collections.unmodifiableMap(new HashMap<Integer, Integer>(this.mCapabilitiesMatchCriteria));
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mAllowedNetworkPlmnIds, this.mAllowedSpecificCarrierIds, this.mCapabilitiesMatchCriteria, this.mRoamingMatchCriteria, this.mOpportunisticMatchCriteria);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof VcnCellUnderlyingNetworkTemplate)) {
            return false;
        }
        VcnCellUnderlyingNetworkTemplate rhs = (VcnCellUnderlyingNetworkTemplate)other;
        return Objects.equals(this.mAllowedNetworkPlmnIds, rhs.mAllowedNetworkPlmnIds) && Objects.equals(this.mAllowedSpecificCarrierIds, rhs.mAllowedSpecificCarrierIds) && Objects.equals(this.mCapabilitiesMatchCriteria, rhs.mCapabilitiesMatchCriteria) && this.mRoamingMatchCriteria == rhs.mRoamingMatchCriteria && this.mOpportunisticMatchCriteria == rhs.mOpportunisticMatchCriteria;
    }

    @Override
    void dumpTransportSpecificFields(IndentingPrintWriter pw) {
        if (!this.mAllowedNetworkPlmnIds.isEmpty()) {
            pw.println("mAllowedNetworkPlmnIds: " + this.mAllowedNetworkPlmnIds);
        }
        if (!this.mAllowedNetworkPlmnIds.isEmpty()) {
            pw.println("mAllowedSpecificCarrierIds: " + this.mAllowedSpecificCarrierIds);
        }
        pw.println("mCapabilitiesMatchCriteria: " + this.mCapabilitiesMatchCriteria);
        if (this.mRoamingMatchCriteria != 0) {
            pw.println("mRoamingMatchCriteria: " + VcnCellUnderlyingNetworkTemplate.getMatchCriteriaString(this.mRoamingMatchCriteria));
        }
        if (this.mOpportunisticMatchCriteria != 0) {
            pw.println("mOpportunisticMatchCriteria: " + VcnCellUnderlyingNetworkTemplate.getMatchCriteriaString(this.mOpportunisticMatchCriteria));
        }
    }

    static {
        HashMap<Integer, Integer> capsMatchCriteria = new HashMap<Integer, Integer>();
        capsMatchCriteria.put(5, 0);
        capsMatchCriteria.put(2, 0);
        capsMatchCriteria.put(4, 0);
        capsMatchCriteria.put(12, 1);
        capsMatchCriteria.put(0, 0);
        capsMatchCriteria.put(8, 0);
        CAPABILITIES_MATCH_CRITERIA_DEFAULT = Collections.unmodifiableMap(capsMatchCriteria);
    }

    public static class Builder {
        private int mMeteredMatchCriteria = 0;
        @NonNull
        private final Set<String> mAllowedNetworkPlmnIds = new ArraySet<String>();
        @NonNull
        private final Set<Integer> mAllowedSpecificCarrierIds = new ArraySet<Integer>();
        @NonNull
        private final Map<Integer, Integer> mCapabilitiesMatchCriteria = new HashMap<Integer, Integer>();
        private int mRoamingMatchCriteria = 0;
        private int mOpportunisticMatchCriteria = 0;
        private int mMinEntryUpstreamBandwidthKbps = 0;
        private int mMinExitUpstreamBandwidthKbps = 0;
        private int mMinEntryDownstreamBandwidthKbps = 0;
        private int mMinExitDownstreamBandwidthKbps = 0;

        public Builder() {
            this.mCapabilitiesMatchCriteria.putAll(CAPABILITIES_MATCH_CRITERIA_DEFAULT);
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @NonNull
        public Builder setMetered(int matchCriteria) {
            VcnUnderlyingNetworkTemplate.validateMatchCriteria(matchCriteria, "setMetered");
            this.mMeteredMatchCriteria = matchCriteria;
            return this;
        }

        @NonNull
        public Builder setOperatorPlmnIds(@NonNull Set<String> operatorPlmnIds) {
            VcnCellUnderlyingNetworkTemplate.validatePlmnIds(operatorPlmnIds);
            this.mAllowedNetworkPlmnIds.clear();
            this.mAllowedNetworkPlmnIds.addAll(operatorPlmnIds);
            return this;
        }

        @NonNull
        public Builder setSimSpecificCarrierIds(@NonNull Set<Integer> simSpecificCarrierIds) {
            Objects.requireNonNull(simSpecificCarrierIds, "simSpecificCarrierIds is null");
            this.mAllowedSpecificCarrierIds.clear();
            this.mAllowedSpecificCarrierIds.addAll(simSpecificCarrierIds);
            return this;
        }

        @NonNull
        public Builder setRoaming(int matchCriteria) {
            VcnUnderlyingNetworkTemplate.validateMatchCriteria(matchCriteria, "setRoaming");
            this.mRoamingMatchCriteria = matchCriteria;
            return this;
        }

        @NonNull
        public Builder setOpportunistic(int matchCriteria) {
            VcnUnderlyingNetworkTemplate.validateMatchCriteria(matchCriteria, "setOpportunistic");
            this.mOpportunisticMatchCriteria = matchCriteria;
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setMinUpstreamBandwidthKbps(int minEntryUpstreamBandwidthKbps, int minExitUpstreamBandwidthKbps) {
            VcnUnderlyingNetworkTemplate.validateMinBandwidthKbps(minEntryUpstreamBandwidthKbps, minExitUpstreamBandwidthKbps);
            this.mMinEntryUpstreamBandwidthKbps = minEntryUpstreamBandwidthKbps;
            this.mMinExitUpstreamBandwidthKbps = minExitUpstreamBandwidthKbps;
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setMinDownstreamBandwidthKbps(int minEntryDownstreamBandwidthKbps, int minExitDownstreamBandwidthKbps) {
            VcnUnderlyingNetworkTemplate.validateMinBandwidthKbps(minEntryDownstreamBandwidthKbps, minExitDownstreamBandwidthKbps);
            this.mMinEntryDownstreamBandwidthKbps = minEntryDownstreamBandwidthKbps;
            this.mMinExitDownstreamBandwidthKbps = minExitDownstreamBandwidthKbps;
            return this;
        }

        @NonNull
        public Builder setCbs(int matchCriteria) {
            VcnUnderlyingNetworkTemplate.validateMatchCriteria(matchCriteria, "setCbs");
            this.mCapabilitiesMatchCriteria.put(5, matchCriteria);
            return this;
        }

        @NonNull
        public Builder setDun(int matchCriteria) {
            VcnUnderlyingNetworkTemplate.validateMatchCriteria(matchCriteria, "setDun");
            this.mCapabilitiesMatchCriteria.put(2, matchCriteria);
            return this;
        }

        @NonNull
        public Builder setIms(int matchCriteria) {
            VcnUnderlyingNetworkTemplate.validateMatchCriteria(matchCriteria, "setIms");
            this.mCapabilitiesMatchCriteria.put(4, matchCriteria);
            return this;
        }

        @NonNull
        public Builder setInternet(int matchCriteria) {
            VcnUnderlyingNetworkTemplate.validateMatchCriteria(matchCriteria, "setInternet");
            this.mCapabilitiesMatchCriteria.put(12, matchCriteria);
            return this;
        }

        @NonNull
        public Builder setMms(int matchCriteria) {
            VcnUnderlyingNetworkTemplate.validateMatchCriteria(matchCriteria, "setMms");
            this.mCapabilitiesMatchCriteria.put(0, matchCriteria);
            return this;
        }

        @NonNull
        public Builder setRcs(int matchCriteria) {
            VcnUnderlyingNetworkTemplate.validateMatchCriteria(matchCriteria, "setRcs");
            this.mCapabilitiesMatchCriteria.put(8, matchCriteria);
            return this;
        }

        @NonNull
        public VcnCellUnderlyingNetworkTemplate build() {
            return new VcnCellUnderlyingNetworkTemplate(this.mMeteredMatchCriteria, this.mMinEntryUpstreamBandwidthKbps, this.mMinExitUpstreamBandwidthKbps, this.mMinEntryDownstreamBandwidthKbps, this.mMinExitDownstreamBandwidthKbps, this.mAllowedNetworkPlmnIds, this.mAllowedSpecificCarrierIds, this.mRoamingMatchCriteria, this.mOpportunisticMatchCriteria, this.mCapabilitiesMatchCriteria);
        }
    }
}

