/*
 * Decompiled with CFR 0.152.
 */
package android.net.ipsec.ike.exceptions;

import android.annotation.NonNull;
import android.net.ipsec.ike.exceptions.IkeProtocolException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class UnsupportedCriticalPayloadException
extends IkeProtocolException {
    private static final int EXPECTED_ERROR_DATA_LEN = 1;
    private final List<Integer> mPayloadTypeList;

    public UnsupportedCriticalPayloadException(@NonNull List<Integer> payloadList) {
        super(1, UnsupportedCriticalPayloadException.integerToByteArray(payloadList.get(0), 1));
        Objects.requireNonNull(payloadList, "payloadList is null");
        this.mPayloadTypeList = Collections.unmodifiableList(new ArrayList<Integer>(payloadList));
    }

    public UnsupportedCriticalPayloadException(byte[] notifyData) {
        super(1, notifyData);
        this.mPayloadTypeList = Collections.singletonList(UnsupportedCriticalPayloadException.byteArrayToInteger(notifyData));
    }

    @NonNull
    public List<Integer> getUnsupportedCriticalPayloadList() {
        return Collections.unmodifiableList(this.mPayloadTypeList);
    }

    @Override
    protected boolean isValidDataLength(int dataLen) {
        return 1 == dataLen;
    }

    @Override
    public int getMetricsErrorCode() {
        return 262145;
    }
}

