/*
 * Decompiled with CFR 0.152.
 */
package android.net.ipsec.ike;

import android.annotation.NonNull;
import android.net.ipsec.ike.IkeIdentification;
import android.net.ipsec.ike.exceptions.AuthenticationFailedException;
import android.os.PersistableBundle;
import java.nio.charset.Charset;
import java.security.cert.X509Certificate;
import java.util.Objects;

public class IkeRfc822AddrIdentification
extends IkeIdentification {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String RFC822_NAME_KEY = "rfc822Name";
    @NonNull
    public final String rfc822Name;

    public IkeRfc822AddrIdentification(byte[] rfc822NameBytes) {
        super(3);
        this.rfc822Name = new String(rfc822NameBytes, UTF8);
    }

    public IkeRfc822AddrIdentification(@NonNull String rfc822Name) {
        super(3);
        this.rfc822Name = rfc822Name;
    }

    @NonNull
    public static IkeRfc822AddrIdentification fromPersistableBundle(@NonNull PersistableBundle in) {
        Objects.requireNonNull(in, "PersistableBundle is null");
        return new IkeRfc822AddrIdentification(in.getString(RFC822_NAME_KEY));
    }

    @Override
    @NonNull
    public PersistableBundle toPersistableBundle() {
        PersistableBundle result = super.toPersistableBundle();
        result.putString(RFC822_NAME_KEY, this.rfc822Name);
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.idType, this.rfc822Name);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IkeRfc822AddrIdentification)) {
            return false;
        }
        return this.rfc822Name.equals(((IkeRfc822AddrIdentification)o).rfc822Name);
    }

    @Override
    public String getIdTypeString() {
        return "RFC822 Address";
    }

    @Override
    public void validateEndCertIdOrThrow(X509Certificate endCert) throws AuthenticationFailedException {
        this.validateEndCertSanOrThrow(endCert, 1, this.rfc822Name);
    }

    @Override
    public byte[] getEncodedIdData() {
        return this.rfc822Name.getBytes(UTF8);
    }
}

