/*
 * Decompiled with CFR 0.152.
 */
package android.net.ipsec.ike;

import android.annotation.NonNull;
import android.net.InetAddresses;
import android.net.ipsec.ike.IkeIdentification;
import android.net.ipsec.ike.exceptions.AuthenticationFailedException;
import android.os.PersistableBundle;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import java.util.Objects;

public class IkeIpv6AddrIdentification
extends IkeIdentification {
    private static final String IP_ADDRESS_KEY = "ipv6Address";
    @NonNull
    public final Inet6Address ipv6Address;

    public IkeIpv6AddrIdentification(byte[] ipv6AddrBytes) throws AuthenticationFailedException {
        super(5);
        try {
            this.ipv6Address = (Inet6Address)Inet6Address.getByAddress(ipv6AddrBytes);
        }
        catch (ClassCastException | UnknownHostException e) {
            throw new AuthenticationFailedException(e);
        }
    }

    public IkeIpv6AddrIdentification(@NonNull Inet6Address address) {
        super(5);
        this.ipv6Address = address;
    }

    @NonNull
    public static IkeIpv6AddrIdentification fromPersistableBundle(@NonNull PersistableBundle in) {
        Objects.requireNonNull(in, "PersistableBundle is null");
        return new IkeIpv6AddrIdentification((Inet6Address)InetAddresses.parseNumericAddress(in.getString(IP_ADDRESS_KEY)));
    }

    @Override
    @NonNull
    public PersistableBundle toPersistableBundle() {
        PersistableBundle result = super.toPersistableBundle();
        result.putString(IP_ADDRESS_KEY, this.ipv6Address.getHostAddress());
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.idType, this.ipv6Address);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IkeIpv6AddrIdentification)) {
            return false;
        }
        return ((Object)this.ipv6Address).equals(((IkeIpv6AddrIdentification)o).ipv6Address);
    }

    @Override
    public String getIdTypeString() {
        return "IPv6 Address";
    }

    @Override
    public void validateEndCertIdOrThrow(X509Certificate endCert) throws AuthenticationFailedException {
        this.validateEndCertSanOrThrow(endCert, 7, this.ipv6Address.getHostAddress());
    }

    @Override
    public byte[] getEncodedIdData() {
        return this.ipv6Address.getAddress();
    }
}

