/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.connectivity.org.chromium.net.CronetException;
import android.net.connectivity.org.chromium.net.UrlRequest;
import android.net.connectivity.org.chromium.net.UrlResponseInfo;
import android.net.http.CronetExceptionTranslationUtils;
import android.net.http.HttpException;
import android.net.http.UrlRequest;
import android.net.http.UrlRequestWrapper;
import android.net.http.UrlResponseInfoWrapper;
import java.nio.ByteBuffer;

class UrlRequestCallbackWrapper
extends UrlRequest.Callback {
    private final UrlRequest.Callback backend;
    private UrlRequestWrapper mOriginalWrapper;

    public UrlRequestCallbackWrapper(UrlRequest.Callback backend) {
        this.backend = backend;
    }

    public void setOriginalRequestWrapper(UrlRequestWrapper wrapper) {
        this.mOriginalWrapper = wrapper;
    }

    private UrlRequestWrapper createWrapperFromRequest(UrlRequest request) {
        return new UrlRequestWrapper(request, this.mOriginalWrapper.getHttpMethod(), this.mOriginalWrapper.hasTrafficStatsTag(), this.mOriginalWrapper.hasTrafficStatsTag() ? this.mOriginalWrapper.getTrafficStatsTag() : 0, this.mOriginalWrapper.hasTrafficStatsUid(), this.mOriginalWrapper.hasTrafficStatsUid() ? this.mOriginalWrapper.getTrafficStatsUid() : 0, this.mOriginalWrapper.getPriority(), this.mOriginalWrapper.getHeaders(), this.mOriginalWrapper.isCacheDisabled(), this.mOriginalWrapper.isDirectExecutorAllowed());
    }

    @Override
    public void onRedirectReceived(UrlRequest request, UrlResponseInfo info, String newLocationUrl) throws Exception {
        UrlRequestWrapper wrappedRequest = this.createWrapperFromRequest(request);
        UrlResponseInfoWrapper wrappedInfo = new UrlResponseInfoWrapper(info);
        this.backend.onRedirectReceived(wrappedRequest, wrappedInfo, newLocationUrl);
    }

    @Override
    public void onResponseStarted(UrlRequest request, UrlResponseInfo info) throws Exception {
        UrlRequestWrapper wrappedRequest = this.createWrapperFromRequest(request);
        UrlResponseInfoWrapper wrappedInfo = new UrlResponseInfoWrapper(info);
        this.backend.onResponseStarted(wrappedRequest, wrappedInfo);
    }

    @Override
    public void onReadCompleted(UrlRequest request, UrlResponseInfo info, ByteBuffer buffer) throws Exception {
        UrlRequestWrapper wrappedRequest = this.createWrapperFromRequest(request);
        UrlResponseInfoWrapper wrappedInfo = new UrlResponseInfoWrapper(info);
        this.backend.onReadCompleted(wrappedRequest, wrappedInfo, buffer);
    }

    @Override
    public void onSucceeded(UrlRequest request, UrlResponseInfo info) {
        UrlRequestWrapper wrappedRequest = this.createWrapperFromRequest(request);
        UrlResponseInfoWrapper wrappedInfo = new UrlResponseInfoWrapper(info);
        this.backend.onSucceeded(wrappedRequest, wrappedInfo);
    }

    @Override
    public void onFailed(UrlRequest request, UrlResponseInfo info, CronetException e) {
        UrlRequestWrapper wrappedRequest = this.createWrapperFromRequest(request);
        UrlResponseInfoWrapper wrappedInfo = new UrlResponseInfoWrapper(info);
        HttpException translatedException = CronetExceptionTranslationUtils.translateException(e);
        this.backend.onFailed(wrappedRequest, wrappedInfo, translatedException);
    }

    @Override
    public void onCanceled(UrlRequest request, UrlResponseInfo info) {
        UrlRequestWrapper wrappedRequest = this.createWrapperFromRequest(request);
        UrlResponseInfoWrapper wrappedInfo = new UrlResponseInfoWrapper(info);
        this.backend.onCanceled(wrappedRequest, wrappedInfo);
    }
}

