/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.annotation.SuppressLint;
import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.layoutlib.androidx.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Duration;

@SuppressLint(value={"UserHandleName"})
public class DnsOptions {
    private final int mUseHttpStackDnsResolver;
    private final int mPersistHostCache;
    private final int mEnableStaleDns;
    @Nullable
    private final Duration mPersistHostCachePeriod;
    private final int mPreestablishConnectionsToStaleDnsResults;
    @Nullable
    private final StaleDnsOptions mStaleDnsOptions;
    public static final int DNS_OPTION_UNSPECIFIED = 0;
    public static final int DNS_OPTION_ENABLED = 1;
    public static final int DNS_OPTION_DISABLED = 2;

    DnsOptions(Builder builder) {
        this.mEnableStaleDns = builder.mEnableStaleDns;
        this.mStaleDnsOptions = builder.mStaleDnsOptions;
        this.mPersistHostCachePeriod = builder.mPersistHostCachePeriod;
        this.mPreestablishConnectionsToStaleDnsResults = builder.mPreestablishConnectionsToStaleDnsResults;
        this.mUseHttpStackDnsResolver = builder.mUseHttpStackDnsResolver;
        this.mPersistHostCache = builder.mPersistHostCache;
    }

    public int getUseHttpStackDnsResolver() {
        return this.mUseHttpStackDnsResolver;
    }

    public int getPersistHostCache() {
        return this.mPersistHostCache;
    }

    public int getStaleDns() {
        return this.mEnableStaleDns;
    }

    @Nullable
    public Duration getPersistHostCachePeriod() {
        return this.mPersistHostCachePeriod;
    }

    public int getPreestablishConnectionsToStaleDnsResults() {
        return this.mPreestablishConnectionsToStaleDnsResults;
    }

    @Nullable
    public StaleDnsOptions getStaleDnsOptions() {
        return this.mStaleDnsOptions;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int mUseHttpStackDnsResolver;
        private int mEnableStaleDns;
        @Nullable
        private StaleDnsOptions mStaleDnsOptions;
        private int mPersistHostCache;
        @Nullable
        private Duration mPersistHostCachePeriod;
        private int mPreestablishConnectionsToStaleDnsResults;

        @NonNull
        public Builder setUseHttpStackDnsResolver(int state) {
            this.mUseHttpStackDnsResolver = state;
            return this;
        }

        @NonNull
        public Builder setStaleDns(int state) {
            this.mEnableStaleDns = state;
            return this;
        }

        @NonNull
        public Builder setStaleDnsOptions(@NonNull StaleDnsOptions staleDnsOptions) {
            this.mStaleDnsOptions = staleDnsOptions;
            return this;
        }

        @Experimental
        @NonNull
        public Builder setPreestablishConnectionsToStaleDnsResults(int state) {
            this.mPreestablishConnectionsToStaleDnsResults = state;
            return this;
        }

        @NonNull
        public Builder setPersistHostCache(int state) {
            this.mPersistHostCache = state;
            return this;
        }

        @NonNull
        public Builder setPersistHostCachePeriod(@NonNull Duration persistHostCachePeriod) {
            this.mPersistHostCachePeriod = persistHostCachePeriod;
            return this;
        }

        @NonNull
        public DnsOptions build() {
            return new DnsOptions(this);
        }
    }

    @SuppressLint(value={"UserHandleName"})
    public static class StaleDnsOptions {
        @Nullable
        private final Duration mFreshLookupTimeout;
        @Nullable
        private final Duration mMaxExpiredDelay;
        private final int mAllowCrossNetworkUsage;
        private final int mUseStaleOnNameNotResolved;

        @Nullable
        public Duration getFreshLookupTimeout() {
            return this.mFreshLookupTimeout;
        }

        @Nullable
        public Duration getMaxExpiredDelay() {
            return this.mMaxExpiredDelay;
        }

        public int getAllowCrossNetworkUsage() {
            return this.mAllowCrossNetworkUsage;
        }

        public int getUseStaleOnNameNotResolved() {
            return this.mUseStaleOnNameNotResolved;
        }

        @NonNull
        public static Builder builder() {
            return new Builder();
        }

        StaleDnsOptions(@NonNull Builder builder) {
            this.mFreshLookupTimeout = builder.mFreshLookupTimeout;
            this.mMaxExpiredDelay = builder.mMaxExpiredDelay;
            this.mAllowCrossNetworkUsage = builder.mAllowCrossNetworkUsage;
            this.mUseStaleOnNameNotResolved = builder.mUseStaleOnNameNotResolved;
        }

        public static class Builder {
            private Duration mFreshLookupTimeout;
            private Duration mMaxExpiredDelay;
            private int mAllowCrossNetworkUsage;
            private int mUseStaleOnNameNotResolved;

            @NonNull
            public Builder setFreshLookupTimeout(@NonNull Duration freshLookupTimeout) {
                this.mFreshLookupTimeout = freshLookupTimeout;
                return this;
            }

            @NonNull
            public Builder setMaxExpiredDelay(@NonNull Duration maxExpiredDelay) {
                this.mMaxExpiredDelay = maxExpiredDelay;
                return this;
            }

            @NonNull
            public Builder setAllowCrossNetworkUsage(int state) {
                this.mAllowCrossNetworkUsage = state;
                return this;
            }

            @NonNull
            public Builder setUseStaleOnNameNotResolved(int state) {
                this.mUseStaleOnNameNotResolved = state;
                return this;
            }

            @NonNull
            public StaleDnsOptions build() {
                return new StaleDnsOptions(this);
            }
        }
    }

    public static @interface Experimental {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DnsOptionState {
    }
}

