/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net.impl;

import android.net.connectivity.org.chromium.net.ExperimentalUrlRequest;
import android.net.connectivity.org.chromium.net.RequestFinishedInfo;
import android.net.connectivity.org.chromium.net.UploadDataProvider;
import android.net.connectivity.org.chromium.net.UrlRequest;
import android.net.connectivity.org.chromium.net.impl.CronetEngineBase;
import android.net.connectivity.org.chromium.net.impl.Preconditions;
import android.util.Log;
import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.layoutlib.androidx.annotation.OptIn;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

public class UrlRequestBuilderImpl
extends ExperimentalUrlRequest.Builder {
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String TAG = UrlRequestBuilderImpl.class.getSimpleName();
    private final CronetEngineBase mCronetEngine;
    private final String mUrl;
    private final UrlRequest.Callback mCallback;
    private final Executor mExecutor;
    private String mMethod;
    private final ArrayList<Map.Entry<String, String>> mRequestHeaders = new ArrayList();
    private boolean mDisableCache;
    private boolean mDisableConnectionMigration;
    private int mPriority = 3;
    private Collection<Object> mRequestAnnotations;
    private UploadDataProvider mUploadDataProvider;
    private Executor mUploadDataProviderExecutor;
    private boolean mAllowDirectExecutor;
    private boolean mTrafficStatsTagSet;
    private int mTrafficStatsTag;
    private boolean mTrafficStatsUidSet;
    private int mTrafficStatsUid;
    private RequestFinishedInfo.Listener mRequestFinishedListener;
    private byte[] mDictionarySha256Hash;
    private ByteBuffer mDictionary;
    @NonNull
    private String mDictionaryId = "";
    private long mNetworkHandle = -1L;
    private int mIdempotency = 0;

    UrlRequestBuilderImpl(String url, UrlRequest.Callback callback, Executor executor, CronetEngineBase cronetEngine) {
        this.mUrl = Objects.requireNonNull(url, "URL is required.");
        this.mCallback = Objects.requireNonNull(callback, "Callback is required.");
        this.mExecutor = Objects.requireNonNull(executor, "Executor is required.");
        this.mCronetEngine = Objects.requireNonNull(cronetEngine, "CronetEngine is required.");
    }

    @Override
    public ExperimentalUrlRequest.Builder setHttpMethod(String method) {
        this.mMethod = Objects.requireNonNull(method, "Method is required.");
        return this;
    }

    @Override
    public UrlRequestBuilderImpl addHeader(String header, String value) {
        Objects.requireNonNull(header, "Invalid header name.");
        Objects.requireNonNull(value, "Invalid header value.");
        if (ACCEPT_ENCODING.equalsIgnoreCase(header)) {
            if (Log.isLoggable(TAG, 3)) {
                Log.d(TAG, "It's not necessary to set Accept-Encoding on requests - cronet will do this automatically for you, and setting it yourself has no effect. See https://crbug.com/581399 for details.", new Exception());
            }
            return this;
        }
        this.mRequestHeaders.add(new AbstractMap.SimpleEntry<String, String>(header, value));
        return this;
    }

    @Override
    public UrlRequestBuilderImpl disableCache() {
        this.mDisableCache = true;
        return this;
    }

    @Override
    public UrlRequestBuilderImpl disableConnectionMigration() {
        this.mDisableConnectionMigration = true;
        return this;
    }

    @Override
    public UrlRequestBuilderImpl setPriority(int priority) {
        this.mPriority = priority;
        return this;
    }

    @Override
    public UrlRequestBuilderImpl setIdempotency(int idempotency) {
        this.mIdempotency = idempotency;
        return this;
    }

    @Override
    public UrlRequestBuilderImpl setUploadDataProvider(UploadDataProvider uploadDataProvider, Executor executor) {
        this.mUploadDataProvider = Objects.requireNonNull(uploadDataProvider, "Invalid UploadDataProvider.");
        this.mUploadDataProviderExecutor = Objects.requireNonNull(executor, "Invalid UploadDataProvider Executor.");
        if (this.mMethod == null) {
            this.mMethod = "POST";
        }
        return this;
    }

    @Override
    public UrlRequestBuilderImpl allowDirectExecutor() {
        this.mAllowDirectExecutor = true;
        return this;
    }

    @Override
    public UrlRequestBuilderImpl addRequestAnnotation(Object annotation) {
        Objects.requireNonNull(annotation, "Invalid metrics annotation.");
        if (this.mRequestAnnotations == null) {
            this.mRequestAnnotations = new ArrayList<Object>();
        }
        this.mRequestAnnotations.add(annotation);
        return this;
    }

    @Override
    public UrlRequestBuilderImpl setTrafficStatsTag(int tag) {
        this.mTrafficStatsTagSet = true;
        this.mTrafficStatsTag = tag;
        return this;
    }

    @Override
    public UrlRequestBuilderImpl setTrafficStatsUid(int uid) {
        this.mTrafficStatsUidSet = true;
        this.mTrafficStatsUid = uid;
        return this;
    }

    @Override
    public UrlRequestBuilderImpl setRequestFinishedListener(RequestFinishedInfo.Listener listener) {
        this.mRequestFinishedListener = listener;
        return this;
    }

    @Override
    @OptIn(markerClass={UrlRequest.Experimental.class})
    public UrlRequestBuilderImpl setRawCompressionDictionary(@NonNull byte[] dictionarySha256Hash, @NonNull ByteBuffer dictionary, @NonNull String dictionaryId) {
        this.mDictionarySha256Hash = Objects.requireNonNull(dictionarySha256Hash, "Hash is required");
        if (dictionarySha256Hash.length != 32) {
            throw new IllegalArgumentException("SHA-256 hashes are supposed to be 32 bytes");
        }
        this.mDictionary = Objects.requireNonNull(dictionary, "Dictionary is required");
        Preconditions.checkDirect(dictionary);
        this.mDictionaryId = Objects.requireNonNull(dictionaryId, "Dictionary ID cannot be null. If missing, pass an empty string");
        return this;
    }

    @Override
    public UrlRequestBuilderImpl bindToNetwork(long networkHandle) {
        this.mNetworkHandle = networkHandle;
        return this;
    }

    @Override
    public ExperimentalUrlRequest build() {
        return this.mCronetEngine.createRequest(this.mUrl, this.mCallback, this.mExecutor, this.mPriority, this.mRequestAnnotations, this.mDisableCache, this.mDisableConnectionMigration, this.mAllowDirectExecutor, this.mTrafficStatsTagSet, this.mTrafficStatsTag, this.mTrafficStatsUidSet, this.mTrafficStatsUid, this.mRequestFinishedListener, this.mIdempotency, this.mNetworkHandle, this.mMethod == null ? "GET" : this.mMethod, this.mRequestHeaders, this.mUploadDataProvider, this.mUploadDataProviderExecutor, this.mDictionarySha256Hash, this.mDictionary, this.mDictionaryId);
    }
}

