/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net.impl;

import android.content.Context;
import android.net.connectivity.org.chromium.net.ExperimentalCronetEngine;
import android.net.connectivity.org.chromium.net.impl.CronetEngineBuilderImpl;
import android.net.connectivity.org.chromium.net.impl.CronetLogger;
import android.net.connectivity.org.chromium.net.impl.CronetUrlRequestContext;
import android.os.SystemClock;
import java.util.concurrent.atomic.AtomicLong;

public class NativeCronetEngineBuilderImpl
extends CronetEngineBuilderImpl {
    private static final AtomicLong sLogCronetInitializationRef = new AtomicLong(0L);

    public NativeCronetEngineBuilderImpl(Context context) {
        super(context, NativeCronetEngineBuilderImpl.computeCronetSource());
    }

    private static CronetLogger.CronetSource computeCronetSource() {
        ClassLoader implClassLoader = CronetEngineBuilderImpl.class.getClassLoader();
        if (implClassLoader.toString().startsWith("java.lang.BootClassLoader")) {
            return CronetLogger.CronetSource.CRONET_SOURCE_PLATFORM;
        }
        ClassLoader apiClassLoader = ExperimentalCronetEngine.class.getClassLoader();
        if (!apiClassLoader.equals(implClassLoader)) {
            return CronetLogger.CronetSource.CRONET_SOURCE_PLAY_SERVICES;
        }
        return CronetLogger.CronetSource.CRONET_SOURCE_STATICALLY_LINKED;
    }

    @Override
    protected long getLogCronetInitializationRef() {
        sLogCronetInitializationRef.compareAndSet(0L, this.mLogger.generateId());
        return sLogCronetInitializationRef.get();
    }

    @Override
    public ExperimentalCronetEngine build() {
        long startUptimeMillis = SystemClock.uptimeMillis();
        if (this.getUserAgent() == null) {
            this.setUserAgent(this.getDefaultUserAgent());
        }
        CronetUrlRequestContext engine = new CronetUrlRequestContext(this, startUptimeMillis);
        this.mMockCertVerifier = 0L;
        return engine;
    }
}

