/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net;

import android.annotation.SuppressLint;
import android.net.connectivity.org.chromium.base.ObserverList;
import android.net.connectivity.org.chromium.base.metrics.ScopedSysTraceEvent;
import android.net.connectivity.org.chromium.build.annotations.NullMarked;
import android.net.connectivity.org.chromium.build.annotations.Nullable;
import android.net.connectivity.org.chromium.net.NetworkChangeNotifierAutoDetect;
import android.net.connectivity.org.chromium.net.NetworkChangeNotifierJni;
import android.net.connectivity.org.chromium.net.RegistrationPolicyAlwaysRegister;
import android.net.connectivity.org.chromium.net.RegistrationPolicyApplicationStatus;
import android.net.connectivity.org.jni_zero.CalledByNative;
import android.net.connectivity.org.jni_zero.JNINamespace;
import android.net.connectivity.org.jni_zero.NativeClassQualifiedName;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import java.util.ArrayList;

@JNINamespace(value="net")
@NullMarked
public class NetworkChangeNotifier {
    private final ArrayList<Long> mNativeChangeNotifiers = new ArrayList();
    private final ObserverList<ConnectionTypeObserver> mConnectionTypeObservers = new ObserverList();
    private @Nullable NetworkChangeNotifierAutoDetect mAutoDetector;
    private int mCurrentConnectionType = 0;
    private int mCurrentConnectionCost = 0;
    @SuppressLint(value={"StaticFieldLeak"})
    private static @Nullable NetworkChangeNotifier sInstance;

    @VisibleForTesting
    protected NetworkChangeNotifier() {
    }

    @CalledByNative
    public static NetworkChangeNotifier init() {
        if (sInstance == null) {
            sInstance = new NetworkChangeNotifier();
        }
        return sInstance;
    }

    public static boolean isInitialized() {
        return sInstance != null;
    }

    public static void resetInstanceForTests() {
        sInstance = new NetworkChangeNotifier();
    }

    public static void resetInstanceForTests(NetworkChangeNotifier notifier) {
        sInstance = notifier;
    }

    @CalledByNative
    public int getCurrentConnectionType() {
        return this.mCurrentConnectionType;
    }

    @CalledByNative
    public int getCurrentConnectionSubtype(boolean forceUpdateNetworkState) {
        try (ScopedSysTraceEvent event = ScopedSysTraceEvent.scoped("NetworkChangeNotifier.getCurrentConnectionSubtype");){
            if (this.mAutoDetector == null) {
                int n = 0;
                return n;
            }
            if (forceUpdateNetworkState) {
                this.mAutoDetector.updateCurrentNetworkState();
            }
            int n = this.mAutoDetector.getCurrentNetworkState().getConnectionSubtype();
            return n;
        }
    }

    @CalledByNative
    public int getCurrentConnectionCost() {
        return this.mCurrentConnectionCost;
    }

    @CalledByNative
    public long getCurrentDefaultNetId() {
        return this.mAutoDetector == null ? -1L : this.mAutoDetector.getDefaultNetId();
    }

    @CalledByNative
    public long[] getCurrentNetworksAndTypes() {
        try (ScopedSysTraceEvent event = ScopedSysTraceEvent.scoped("NetworkChangeNotifierAutoDetect.getCurrentNetworksAndTypes");){
            long[] lArray = this.mAutoDetector == null ? new long[]{} : this.mAutoDetector.getNetworksAndTypes();
            return lArray;
        }
    }

    @CalledByNative
    public void addNativeObserver(long nativeChangeNotifier) {
        this.mNativeChangeNotifiers.add(nativeChangeNotifier);
    }

    @CalledByNative
    public void removeNativeObserver(long nativeChangeNotifier) {
        this.mNativeChangeNotifiers.remove(nativeChangeNotifier);
    }

    @CalledByNative
    public boolean registerNetworkCallbackFailed() {
        return this.mAutoDetector == null ? false : this.mAutoDetector.registerNetworkCallbackFailed();
    }

    public static NetworkChangeNotifier getInstance() {
        assert (sInstance != null);
        return sInstance;
    }

    @CalledByNative
    public static void setAutoDetectConnectivityState(boolean shouldAutoDetect) {
        NetworkChangeNotifier.getInstance().setAutoDetectConnectivityStateInternal(shouldAutoDetect, new RegistrationPolicyApplicationStatus());
    }

    public static void registerToReceiveNotificationsAlways() {
        NetworkChangeNotifier.getInstance().setAutoDetectConnectivityStateInternal(true, new RegistrationPolicyAlwaysRegister());
    }

    public static void setAutoDetectConnectivityState(NetworkChangeNotifierAutoDetect.RegistrationPolicy policy, boolean forceUpdateNetworkState) {
        NetworkChangeNotifier.getInstance().setAutoDetectConnectivityStateInternal(true, policy, forceUpdateNetworkState);
    }

    private void destroyAutoDetector() {
        if (this.mAutoDetector != null) {
            this.mAutoDetector.destroy();
            this.mAutoDetector = null;
        }
    }

    private void setAutoDetectConnectivityStateInternal(boolean shouldAutoDetect, NetworkChangeNotifierAutoDetect.RegistrationPolicy policy) {
        this.setAutoDetectConnectivityStateInternal(shouldAutoDetect, policy, true);
    }

    private void setAutoDetectConnectivityStateInternal(boolean shouldAutoDetect, NetworkChangeNotifierAutoDetect.RegistrationPolicy policy, boolean forceUpdateNetworkState) {
        try (ScopedSysTraceEvent event = ScopedSysTraceEvent.scoped("NetworkChangeNotifier.setAutoDetectConnectivityStateInternal");){
            if (shouldAutoDetect) {
                if (this.mAutoDetector == null) {
                    this.mAutoDetector = new NetworkChangeNotifierAutoDetect(new NetworkChangeNotifierAutoDetect.Observer(){

                        @Override
                        public void onConnectionTypeChanged(int newConnectionType) {
                            NetworkChangeNotifier.this.updateCurrentConnectionType(newConnectionType);
                        }

                        @Override
                        public void onConnectionCostChanged(int newConnectionCost) {
                            NetworkChangeNotifier.this.notifyObserversOfConnectionCostChange(newConnectionCost);
                        }

                        @Override
                        public void onConnectionSubtypeChanged(int newConnectionSubtype) {
                            NetworkChangeNotifier.this.notifyObserversOfConnectionSubtypeChange(newConnectionSubtype);
                        }

                        @Override
                        public void onNetworkConnect(long netId, int connectionType) {
                            NetworkChangeNotifier.this.notifyObserversOfNetworkConnect(netId, connectionType);
                        }

                        @Override
                        public void onNetworkSoonToDisconnect(long netId) {
                            NetworkChangeNotifier.this.notifyObserversOfNetworkSoonToDisconnect(netId);
                        }

                        @Override
                        public void onNetworkDisconnect(long netId) {
                            NetworkChangeNotifier.this.notifyObserversOfNetworkDisconnect(netId);
                        }

                        @Override
                        public void purgeActiveNetworkList(long[] activeNetIds) {
                            NetworkChangeNotifier.this.notifyObserversToPurgeActiveNetworkList(activeNetIds);
                        }
                    }, policy);
                    if (forceUpdateNetworkState) {
                        this.mAutoDetector.updateCurrentNetworkState();
                    }
                    NetworkChangeNotifierAutoDetect.NetworkState networkState = this.mAutoDetector.getCurrentNetworkState();
                    this.updateCurrentConnectionType(networkState.getConnectionType());
                    this.updateCurrentConnectionCost(networkState.getConnectionCost());
                    this.notifyObserversOfConnectionSubtypeChange(networkState.getConnectionSubtype());
                }
            } else {
                this.destroyAutoDetector();
            }
        }
    }

    @CalledByNative
    public static void forceConnectivityState(boolean networkAvailable) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().forceConnectivityStateInternal(networkAvailable);
    }

    private void forceConnectivityStateInternal(boolean forceOnline) {
        boolean connectionCurrentlyExists;
        boolean bl = connectionCurrentlyExists = this.mCurrentConnectionType != 6;
        if (connectionCurrentlyExists != forceOnline) {
            this.updateCurrentConnectionType(forceOnline ? 0 : 6);
            this.notifyObserversOfConnectionSubtypeChange(forceOnline ? 0 : 1);
        }
    }

    @CalledByNative
    public static void fakeNetworkConnected(long netId, int connectionType) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfNetworkConnect(netId, connectionType);
    }

    @CalledByNative
    public static void fakeNetworkSoonToBeDisconnected(long netId) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfNetworkSoonToDisconnect(netId);
    }

    @CalledByNative
    public static void fakeNetworkDisconnected(long netId) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfNetworkDisconnect(netId);
    }

    @CalledByNative
    public static void fakePurgeActiveNetworkList(long[] activeNetIds) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversToPurgeActiveNetworkList(activeNetIds);
    }

    @CalledByNative
    public static void fakeDefaultNetwork(long netId, int connectionType) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfConnectionTypeChange(connectionType, netId);
    }

    @CalledByNative
    @VisibleForTesting
    public static void fakeConnectionCostChanged(int connectionCost) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfConnectionCostChange(connectionCost);
    }

    @CalledByNative
    public static void fakeConnectionSubtypeChanged(int connectionSubtype) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfConnectionSubtypeChange(connectionSubtype);
    }

    private void updateCurrentConnectionType(int newConnectionType) {
        this.mCurrentConnectionType = newConnectionType;
        this.notifyObserversOfConnectionTypeChange(newConnectionType);
    }

    void notifyObserversOfConnectionTypeChange(int newConnectionType) {
        this.notifyObserversOfConnectionTypeChange(newConnectionType, this.getCurrentDefaultNetId());
    }

    private void notifyObserversOfConnectionTypeChange(int newConnectionType, long defaultNetId) {
        for (Long nativeChangeNotifier : this.mNativeChangeNotifiers) {
            NetworkChangeNotifierJni.get().notifyConnectionTypeChanged(nativeChangeNotifier, this, newConnectionType, defaultNetId);
        }
        for (ConnectionTypeObserver observer : this.mConnectionTypeObservers) {
            observer.onConnectionTypeChanged(newConnectionType);
        }
    }

    private void updateCurrentConnectionCost(int newConnectionCost) {
        this.mCurrentConnectionCost = newConnectionCost;
        this.notifyObserversOfConnectionCostChange(newConnectionCost);
    }

    void notifyObserversOfConnectionCostChange(int newConnectionCost) {
        for (Long nativeChangeNotifier : this.mNativeChangeNotifiers) {
            NetworkChangeNotifierJni.get().notifyConnectionCostChanged(nativeChangeNotifier, this, newConnectionCost);
        }
    }

    void notifyObserversOfConnectionSubtypeChange(int connectionSubtype) {
        for (Long nativeChangeNotifier : this.mNativeChangeNotifiers) {
            NetworkChangeNotifierJni.get().notifyConnectionSubtypeChanged(nativeChangeNotifier, this, connectionSubtype);
        }
    }

    void notifyObserversOfNetworkConnect(long netId, int connectionType) {
        for (Long nativeChangeNotifier : this.mNativeChangeNotifiers) {
            NetworkChangeNotifierJni.get().notifyOfNetworkConnect(nativeChangeNotifier, this, netId, connectionType);
        }
    }

    void notifyObserversOfNetworkSoonToDisconnect(long netId) {
        for (Long nativeChangeNotifier : this.mNativeChangeNotifiers) {
            NetworkChangeNotifierJni.get().notifyOfNetworkSoonToDisconnect(nativeChangeNotifier, this, netId);
        }
    }

    void notifyObserversOfNetworkDisconnect(long netId) {
        for (Long nativeChangeNotifier : this.mNativeChangeNotifiers) {
            NetworkChangeNotifierJni.get().notifyOfNetworkDisconnect(nativeChangeNotifier, this, netId);
        }
    }

    void notifyObserversToPurgeActiveNetworkList(long[] activeNetIds) {
        for (Long nativeChangeNotifier : this.mNativeChangeNotifiers) {
            NetworkChangeNotifierJni.get().notifyPurgeActiveNetworkList(nativeChangeNotifier, this, activeNetIds);
        }
    }

    public static void addConnectionTypeObserver(ConnectionTypeObserver observer) {
        NetworkChangeNotifier.getInstance().addConnectionTypeObserverInternal(observer);
    }

    private void addConnectionTypeObserverInternal(ConnectionTypeObserver observer) {
        this.mConnectionTypeObservers.addObserver(observer);
    }

    public static void removeConnectionTypeObserver(ConnectionTypeObserver observer) {
        NetworkChangeNotifier.getInstance().removeConnectionTypeObserverInternal(observer);
    }

    private void removeConnectionTypeObserverInternal(ConnectionTypeObserver observer) {
        this.mConnectionTypeObservers.removeObserver(observer);
    }

    public static @Nullable NetworkChangeNotifierAutoDetect getAutoDetectorForTest() {
        return NetworkChangeNotifier.getInstance().mAutoDetector;
    }

    public static boolean isOnline() {
        int connectionType = NetworkChangeNotifier.getInstance().getCurrentConnectionType();
        return connectionType != 6;
    }

    static interface Natives {
        @NativeClassQualifiedName(value="NetworkChangeNotifierDelegateAndroid")
        public void notifyConnectionTypeChanged(long var1, NetworkChangeNotifier var3, int var4, long var5);

        @NativeClassQualifiedName(value="NetworkChangeNotifierDelegateAndroid")
        public void notifyConnectionCostChanged(long var1, NetworkChangeNotifier var3, int var4);

        @NativeClassQualifiedName(value="NetworkChangeNotifierDelegateAndroid")
        public void notifyConnectionSubtypeChanged(long var1, NetworkChangeNotifier var3, int var4);

        @NativeClassQualifiedName(value="NetworkChangeNotifierDelegateAndroid")
        public void notifyOfNetworkConnect(long var1, NetworkChangeNotifier var3, long var4, int var6);

        @NativeClassQualifiedName(value="NetworkChangeNotifierDelegateAndroid")
        public void notifyOfNetworkSoonToDisconnect(long var1, NetworkChangeNotifier var3, long var4);

        @NativeClassQualifiedName(value="NetworkChangeNotifierDelegateAndroid")
        public void notifyOfNetworkDisconnect(long var1, NetworkChangeNotifier var3, long var4);

        @NativeClassQualifiedName(value="NetworkChangeNotifierDelegateAndroid")
        public void notifyPurgeActiveNetworkList(long var1, NetworkChangeNotifier var3, long[] var4);
    }

    public static interface ConnectionTypeObserver {
        public void onConnectionTypeChanged(int var1);
    }
}

