/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base.task;

import android.net.connectivity.javax.annotation.concurrent.GuardedBy;
import android.net.connectivity.org.chromium.base.TraceEvent;
import android.net.connectivity.org.chromium.base.task.PostTask;
import android.net.connectivity.org.chromium.base.task.TaskOriginException;
import android.net.connectivity.org.chromium.base.task.TaskRunner;
import android.net.connectivity.org.chromium.base.task.TaskRunnerImplJni;
import android.net.connectivity.org.chromium.build.NullUtil;
import android.net.connectivity.org.chromium.build.annotations.NullMarked;
import android.net.connectivity.org.chromium.build.annotations.Nullable;
import android.net.connectivity.org.jni_zero.CalledByNative;
import android.net.connectivity.org.jni_zero.JNINamespace;
import android.util.Pair;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

@JNINamespace(value="base")
@NullMarked
public class TaskRunnerImpl
implements TaskRunner {
    private static final ReferenceQueue<Object> sQueue = new ReferenceQueue();
    private static Object sPendingTaskLock = new Object();
    @GuardedBy(value="sPendingTaskLock")
    private static final @Nullable Runnable[] sPendingTaskTable = new Runnable[50];
    @GuardedBy(value="sPendingTaskLock")
    private static int sPendingTaskMapNextIndex = sPendingTaskTable.length;
    @GuardedBy(value="sPendingTaskLock")
    private static final Map<Integer, Runnable> sPendingTaskMap = new HashMap<Integer, Runnable>();
    @GuardedBy(value="sCleaners")
    private static final Set<TaskRunnerCleaner> sCleaners = new HashSet<TaskRunnerCleaner>();
    private final int mTaskTraits;
    private final String mTraceEvent;
    private final int mTaskRunnerType;
    private volatile long mNativeTaskRunnerAndroid;
    protected final Runnable mRunPreNativeTaskClosure = this::runPreNativeTask;
    private final Object mPreNativeTaskLock = new Object();
    @GuardedBy(value="mPreNativeTaskLock")
    private boolean mDidOneTimeInitialization;
    @GuardedBy(value="mPreNativeTaskLock")
    private @Nullable Queue<Runnable> mPreNativeTasks;
    @GuardedBy(value="mPreNativeTaskLock")
    private @Nullable List<Pair<Runnable, Long>> mPreNativeDelayedTasks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int clearTaskQueueForTesting() {
        int taskCount = 0;
        Object object = this.mPreNativeTaskLock;
        synchronized (object) {
            if (this.mPreNativeTasks != null) {
                List<Pair<Runnable, Long>> preNativeDelayedTasks = NullUtil.assumeNonNull(this.mPreNativeDelayedTasks);
                taskCount = this.mPreNativeTasks.size() + preNativeDelayedTasks.size();
                this.mPreNativeTasks.clear();
                preNativeDelayedTasks.clear();
            }
        }
        return taskCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void destroyGarbageCollectedTaskRunners() {
        TaskRunnerCleaner cleaner;
        while ((cleaner = (TaskRunnerCleaner)sQueue.poll()) != null) {
            cleaner.destroy();
            Set<TaskRunnerCleaner> set = sCleaners;
            synchronized (set) {
                sCleaners.remove(cleaner);
            }
        }
        return;
    }

    TaskRunnerImpl(int traits) {
        this(traits, "TaskRunnerImpl", 0);
        TaskRunnerImpl.destroyGarbageCollectedTaskRunners();
    }

    protected TaskRunnerImpl(int traits, String traceCategory, int taskRunnerType) {
        this.mTaskTraits = traits;
        this.mTraceEvent = traceCategory + ".PreNativeTask.run";
        this.mTaskRunnerType = taskRunnerType;
    }

    @Override
    public void execute(Runnable task) {
        this.postDelayedTask(task, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postDelayedTask(Runnable task, long delay) {
        if (PostTask.ENABLE_TASK_ORIGINS) {
            task = PostTask.populateTaskOrigin(new TaskOriginException(), task);
        }
        if (this.mNativeTaskRunnerAndroid != 0L) {
            TaskRunnerImpl.queueDelayedTaskToNative(this.mNativeTaskRunnerAndroid, task, delay);
            return;
        }
        Object object = this.mPreNativeTaskLock;
        synchronized (object) {
            this.oneTimeInitialization();
            if (this.mNativeTaskRunnerAndroid != 0L) {
                TaskRunnerImpl.queueDelayedTaskToNative(this.mNativeTaskRunnerAndroid, task, delay);
                return;
            }
            if (delay == 0L) {
                NullUtil.assumeNonNull(this.mPreNativeTasks).add(task);
                this.schedulePreNativeTask();
            } else if (!this.schedulePreNativeDelayedTask(task, delay)) {
                Pair<Runnable, Long> preNativeDelayedTask = new Pair<Runnable, Long>(task, delay);
                NullUtil.assumeNonNull(this.mPreNativeDelayedTasks).add(preNativeDelayedTask);
            }
        }
    }

    @GuardedBy(value="mPreNativeTaskLock")
    private void oneTimeInitialization() {
        if (this.mDidOneTimeInitialization) {
            return;
        }
        this.mDidOneTimeInitialization = true;
        if (!PostTask.registerPreNativeTaskRunner(this)) {
            this.initNativeTaskRunner();
        } else {
            this.mPreNativeTasks = new ArrayDeque<Runnable>();
            this.mPreNativeDelayedTasks = new ArrayList<Pair<Runnable, Long>>();
        }
    }

    protected void schedulePreNativeTask() {
        PostTask.getPrenativeThreadPoolExecutor().execute(this.mRunPreNativeTaskClosure);
    }

    protected boolean schedulePreNativeDelayedTask(Runnable task, long delay) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runPreNativeTask() {
        try (TraceEvent te = TraceEvent.scoped(this.mTraceEvent);){
            Runnable task;
            Object object = this.mPreNativeTaskLock;
            synchronized (object) {
                block11: {
                    if (this.mPreNativeTasks != null) break block11;
                    return;
                }
                task = this.mPreNativeTasks.poll();
            }
            task.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initNativeTaskRunner() {
        long nativeTaskRunnerAndroid = TaskRunnerImplJni.get().init(this.mTaskRunnerType, this.mTaskTraits);
        Set<TaskRunnerCleaner> set = this.mPreNativeTaskLock;
        synchronized (set) {
            if (this.mPreNativeTasks != null) {
                for (Runnable runnable : this.mPreNativeTasks) {
                    TaskRunnerImpl.queueDelayedTaskToNative(nativeTaskRunnerAndroid, runnable, 0L);
                }
                this.mPreNativeTasks = null;
            }
            if (this.mPreNativeDelayedTasks != null) {
                for (Pair pair : this.mPreNativeDelayedTasks) {
                    TaskRunnerImpl.queueDelayedTaskToNative(nativeTaskRunnerAndroid, (Runnable)pair.first, (Long)pair.second);
                }
                this.mPreNativeDelayedTasks = null;
            }
            assert (this.mNativeTaskRunnerAndroid == 0L);
            this.mNativeTaskRunnerAndroid = nativeTaskRunnerAndroid;
        }
        set = sCleaners;
        synchronized (set) {
            sCleaners.add(new TaskRunnerCleaner(this));
        }
        TaskRunnerImpl.destroyGarbageCollectedTaskRunners();
    }

    private static void queueDelayedTaskToNative(long nativeTaskRunnerAndroid, Runnable task, long delay) {
        int taskIndex = TaskRunnerImpl.queueTask(task, delay == 0L);
        TaskRunnerImplJni.get().postDelayedTask(nativeTaskRunnerAndroid, delay, taskIndex);
    }

    @CalledByNative
    @VisibleForTesting
    static void runTask(int taskIndex) {
        Runnable task = TaskRunnerImpl.dequeueTask(taskIndex);
        task.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int queueTask(Runnable task, boolean useTable) {
        Object object = sPendingTaskLock;
        synchronized (object) {
            for (int i = 0; useTable && i < sPendingTaskTable.length; ++i) {
                if (sPendingTaskTable[i] != null) continue;
                TaskRunnerImpl.sPendingTaskTable[i] = task;
                return i;
            }
            int taskIndex = sPendingTaskMapNextIndex++;
            assert (taskIndex < Integer.MAX_VALUE);
            sPendingTaskMap.put(taskIndex, task);
            return taskIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Runnable dequeueTask(int taskIndex) {
        Object object = sPendingTaskLock;
        synchronized (object) {
            Runnable task;
            if (taskIndex < sPendingTaskTable.length) {
                task = sPendingTaskTable[taskIndex];
                TaskRunnerImpl.sPendingTaskTable[taskIndex] = null;
            } else {
                task = sPendingTaskMap.remove(taskIndex);
            }
            assert (task != null) : "Task at index " + taskIndex + " was null.";
            return task;
        }
    }

    private static class TaskRunnerCleaner
    extends WeakReference<TaskRunnerImpl> {
        final long mNativePtr;

        TaskRunnerCleaner(TaskRunnerImpl runner) {
            super(runner, sQueue);
            this.mNativePtr = runner.mNativeTaskRunnerAndroid;
        }

        void destroy() {
            TaskRunnerImplJni.get().destroy(this.mNativePtr);
        }
    }

    static interface Natives {
        public long init(int var1, int var2);

        public void destroy(long var1);

        public void postDelayedTask(long var1, long var3, int var5);
    }
}

