/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base.task;

import android.net.connectivity.org.chromium.base.task.AsyncTask;
import android.net.connectivity.org.chromium.build.annotations.NullMarked;
import android.net.connectivity.org.chromium.build.annotations.Nullable;
import java.util.ArrayDeque;
import java.util.concurrent.Executor;

@NullMarked
class SerialExecutor
implements Executor {
    final ArrayDeque<Runnable> mTasks = new ArrayDeque();
    @Nullable Runnable mActive;

    SerialExecutor() {
    }

    @Override
    public synchronized void execute(Runnable r) {
        this.mTasks.offer(() -> {
            try {
                r.run();
            }
            finally {
                this.scheduleNext();
            }
        });
        if (this.mActive == null) {
            this.scheduleNext();
        }
    }

    protected synchronized void scheduleNext() {
        this.mActive = this.mTasks.poll();
        if (this.mActive != null) {
            AsyncTask.THREAD_POOL_EXECUTOR.execute(this.mActive);
        }
    }
}

