/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base;

import android.app.Activity;
import android.content.res.Resources;
import android.net.connectivity.org.chromium.base.ApplicationStatus;
import android.net.connectivity.org.chromium.base.CommandLine;
import android.net.connectivity.org.chromium.base.EarlyTraceEvent;
import android.net.connectivity.org.chromium.base.ThreadUtils;
import android.net.connectivity.org.chromium.base.TimeUtils;
import android.net.connectivity.org.chromium.base.TraceEventJni;
import android.net.connectivity.org.chromium.base.task.PostTask;
import android.net.connectivity.org.chromium.build.annotations.NullMarked;
import android.net.connectivity.org.chromium.build.annotations.Nullable;
import android.net.connectivity.org.jni_zero.CalledByNative;
import android.net.connectivity.org.jni_zero.JNINamespace;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.SystemClock;
import android.util.Log;
import android.util.Printer;
import android.view.View;
import android.view.ViewGroup;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import java.util.ArrayList;

@JNINamespace(value="base::android")
@NullMarked
public class TraceEvent
implements AutoCloseable {
    private static volatile boolean sEnabled;
    private static volatile boolean sUiThreadReady;
    private static boolean sEventNameFilteringEnabled;
    private final String mName;

    private TraceEvent(String name, @Nullable String arg) {
        this.mName = name;
        TraceEvent.begin(name, arg);
    }

    private TraceEvent(String name, int arg) {
        this.mName = name;
        TraceEvent.begin(name, arg);
    }

    @Override
    public void close() {
        TraceEvent.end(this.mName);
    }

    public static @Nullable TraceEvent scoped(String name, @Nullable String arg) {
        if (!EarlyTraceEvent.enabled() && !TraceEvent.enabled()) {
            return null;
        }
        return new TraceEvent(name, arg);
    }

    public static @Nullable TraceEvent scoped(String name, int arg) {
        if (!EarlyTraceEvent.enabled() && !TraceEvent.enabled()) {
            return null;
        }
        return new TraceEvent(name, arg);
    }

    public static @Nullable TraceEvent scoped(String name) {
        return TraceEvent.scoped(name, null);
    }

    @CalledByNative
    public static void setEnabled(boolean enabled) {
        if (enabled) {
            EarlyTraceEvent.disable();
        }
        if (sEnabled != enabled) {
            sEnabled = enabled;
            ThreadUtils.getUiThreadLooper().setMessageLogging(enabled ? LooperMonitorHolder.sInstance : null);
        }
        if (sEnabled) {
            EarlyTraceEvent.dumpActivityStartupEvents();
        }
        if (sUiThreadReady) {
            ViewHierarchyDumper.updateEnabledState();
        }
    }

    @CalledByNative
    public static void setEventNameFilteringEnabled(boolean enabled) {
        sEventNameFilteringEnabled = enabled;
    }

    public static boolean eventNameFilteringEnabled() {
        return sEventNameFilteringEnabled;
    }

    public static void maybeEnableEarlyTracing(boolean readCommandLine) {
        if (readCommandLine) {
            EarlyTraceEvent.maybeEnableInBrowserProcess();
        }
        if (EarlyTraceEvent.enabled()) {
            ThreadUtils.getUiThreadLooper().setMessageLogging(LooperMonitorHolder.sInstance);
        }
    }

    public static void onNativeTracingReady() {
        TraceEventJni.get().registerEnabledObserver();
    }

    static void onUiThreadReady() {
        sUiThreadReady = true;
        if (sEnabled) {
            ViewHierarchyDumper.updateEnabledState();
        }
    }

    public static boolean enabled() {
        return sEnabled;
    }

    public static void instant(String name) {
        if (sEnabled) {
            TraceEventJni.get().instant(name, null);
        }
    }

    public static void instant(String name, String arg) {
        if (sEnabled) {
            TraceEventJni.get().instant(name, arg);
        }
    }

    public static void instantAndroidIPC(String name, long durMs) {
        if (sEnabled) {
            TraceEventJni.get().instantAndroidIPC(name, durMs);
        }
    }

    public static void instantAndroidToolbar(int blockReason, int allowReason, int snapshotDiff) {
        if (sEnabled) {
            TraceEventJni.get().instantAndroidToolbar(blockReason, allowReason, snapshotDiff);
        }
    }

    public static void webViewStartupTotalFactoryInit(long startTimeMs, long durationMs) {
        if (sEnabled) {
            TraceEventJni.get().webViewStartupTotalFactoryInit(startTimeMs, durationMs);
        }
    }

    public static void webViewStartupStage1(long startTimeMs, long durationMs) {
        if (sEnabled) {
            TraceEventJni.get().webViewStartupStage1(startTimeMs, durationMs);
        }
    }

    public static void webViewStartupFirstInstance(long startTimeMs, long durationMs, boolean includedGlobalStartup) {
        if (sEnabled) {
            TraceEventJni.get().webViewStartupFirstInstance(startTimeMs, durationMs, includedGlobalStartup);
        }
    }

    public static void webViewStartupNotFirstInstance(long startTimeMs, long durationMs) {
        if (sEnabled) {
            TraceEventJni.get().webViewStartupNotFirstInstance(startTimeMs, durationMs);
        }
    }

    public static void webViewStartupStartChromiumLocked(long startTimeMs, long durationMs, int callSite, boolean fromUIThread) {
        if (sEnabled) {
            TraceEventJni.get().webViewStartupStartChromiumLocked(startTimeMs, durationMs, callSite, fromUIThread);
        }
    }

    public static void startupActivityStart(long activityId, long startTimeMs) {
        if (sEnabled) {
            TraceEventJni.get().startupActivityStart(activityId, startTimeMs);
        } else {
            EarlyTraceEvent.startupActivityStart(activityId, startTimeMs);
        }
    }

    public static void startupLaunchCause(long activityId, int launchCause) {
        if (sEnabled) {
            TraceEventJni.get().startupLaunchCause(activityId, SystemClock.uptimeMillis(), launchCause);
        } else {
            EarlyTraceEvent.startupLaunchCause(activityId, launchCause);
        }
    }

    public static void startupTimeToFirstVisibleContent2(long activityId, long startTimeMs, long durationMs) {
        if (!sEnabled) {
            return;
        }
        TraceEventJni.get().startupTimeToFirstVisibleContent2(activityId, startTimeMs, durationMs);
    }

    public static void snapshotViewHierarchy() {
        if (sEnabled && TraceEventJni.get().viewHierarchyDumpEnabled()) {
            TraceEvent.begin("instantAndroidViewHierarchy");
            ArrayList<ActivityInfo> views = TraceEvent.snapshotViewHierarchyState();
            if (views.isEmpty()) {
                TraceEvent.end("instantAndroidViewHierarchy");
                return;
            }
            long flow = views.hashCode();
            PostTask.postTask(0, () -> TraceEventJni.get().initViewHierarchyDump(flow, views));
            TraceEvent.end("instantAndroidViewHierarchy", null, flow);
        }
    }

    public static void startAsync(String name, long id2) {
        EarlyTraceEvent.startAsync(name, id2);
        if (sEnabled) {
            TraceEventJni.get().startAsync(name, id2);
        }
    }

    public static void finishAsync(String name, long id2) {
        EarlyTraceEvent.finishAsync(name, id2);
        if (sEnabled) {
            TraceEventJni.get().finishAsync(id2);
        }
    }

    public static void begin(String name) {
        TraceEvent.begin(name, null);
    }

    public static void begin(String name, @Nullable String arg) {
        EarlyTraceEvent.begin(name, false);
        if (sEnabled) {
            TraceEventJni.get().begin(name, arg);
        }
    }

    public static void begin(String name, int arg) {
        EarlyTraceEvent.begin(name, false);
        if (sEnabled) {
            TraceEventJni.get().beginWithIntArg(name, arg);
        }
    }

    public static void end(String name) {
        TraceEvent.end(name, null);
    }

    public static void end(String name, @Nullable String arg) {
        TraceEvent.end(name, arg, 0L);
    }

    public static void end(String name, @Nullable String arg, long flow) {
        EarlyTraceEvent.end(name, false);
        if (sEnabled) {
            TraceEventJni.get().end(arg, flow);
        }
    }

    public static ArrayList<ActivityInfo> snapshotViewHierarchyState() {
        if (!ApplicationStatus.isInitialized()) {
            return new ArrayList<ActivityInfo>();
        }
        ArrayList<ActivityInfo> views = new ArrayList<ActivityInfo>(2);
        for (Activity a : ApplicationStatus.getRunningActivities()) {
            views.add(new ActivityInfo(a.getClass().getName()));
            ViewHierarchyDumper.dumpView(views.get(views.size() - 1), 0, a.getWindow().getDecorView().getRootView());
        }
        return views;
    }

    @CalledByNative
    public static void dumpViewHierarchy(long dumpProtoPtr, Object list) {
        if (!ApplicationStatus.isInitialized()) {
            return;
        }
        ArrayList activities = (ArrayList)list;
        for (ActivityInfo activity : activities) {
            long activityProtoPtr = TraceEventJni.get().startActivityDump(activity.mActivityName, dumpProtoPtr);
            for (ViewInfo view : activity.mViews) {
                String resource;
                try {
                    resource = view.mRes != null ? (view.mId == 0 || view.mId == -1 ? "__no_id__" : view.mRes.getResourceName(view.mId)) : "__no_resources__";
                }
                catch (Resources.NotFoundException e) {
                    resource = "__name_not_found__";
                }
                TraceEventJni.get().addViewDump(view.mId, view.mParentId, view.mIsShown, view.mIsDirty, view.mClassName, resource, activityProtoPtr);
            }
        }
    }

    private static class LooperMonitorHolder {
        private static final BasicLooperMonitor sInstance = CommandLine.getInstance().hasSwitch("enable-idle-tracing") ? new IdleTracingLooperMonitor() : new BasicLooperMonitor();

        private LooperMonitorHolder() {
        }
    }

    @VisibleForTesting(otherwise=2)
    static class BasicLooperMonitor
    implements Printer {
        @VisibleForTesting(otherwise=2)
        static final String LOOPER_TASK_PREFIX = "Looper.dispatch: ";
        @VisibleForTesting(otherwise=2)
        static final String FILTERED_EVENT_NAME = "Looper.dispatch: EVENT_NAME_FILTERED";
        private static final int SHORTEST_LOG_PREFIX_LENGTH = "<<<<< Finished to ".length();
        private @Nullable String mCurrentTarget;

        BasicLooperMonitor() {
        }

        @Override
        public void println(String line) {
            if (line.startsWith(">")) {
                this.beginHandling(line);
            } else {
                assert (line.startsWith("<"));
                this.endHandling(line);
            }
        }

        void beginHandling(String line) {
            boolean earlyTracingActive = EarlyTraceEvent.enabled();
            if (sEnabled || earlyTracingActive) {
                this.mCurrentTarget = BasicLooperMonitor.getTraceEventName(line);
                if (sEnabled) {
                    TraceEventJni.get().beginToplevel(this.mCurrentTarget);
                } else {
                    EarlyTraceEvent.begin(this.mCurrentTarget, true);
                }
            }
        }

        void endHandling(String line) {
            boolean earlyTracingActive = EarlyTraceEvent.enabled();
            if ((sEnabled || earlyTracingActive) && this.mCurrentTarget != null) {
                if (sEnabled) {
                    TraceEventJni.get().endToplevel();
                } else {
                    EarlyTraceEvent.end(this.mCurrentTarget, true);
                }
            }
            this.mCurrentTarget = null;
        }

        @VisibleForTesting(otherwise=2)
        static String getTraceEventName(String line) {
            if (sEventNameFilteringEnabled) {
                return FILTERED_EVENT_NAME;
            }
            return LOOPER_TASK_PREFIX + BasicLooperMonitor.getTarget(line) + "(" + BasicLooperMonitor.getTargetName(line) + ")";
        }

        private static String getTarget(String logLine) {
            int start = logLine.indexOf(40, SHORTEST_LOG_PREFIX_LENGTH);
            int end = start == -1 ? -1 : logLine.indexOf(41, start);
            return end != -1 ? logLine.substring(start + 1, end) : "";
        }

        private static String getTargetName(String logLine) {
            int end;
            int start = logLine.indexOf(125, SHORTEST_LOG_PREFIX_LENGTH);
            int n = end = start == -1 ? -1 : logLine.indexOf(58, start);
            if (end == -1) {
                end = logLine.length();
            }
            return start != -1 ? logLine.substring(start + 2, end) : "";
        }
    }

    private static class ViewHierarchyDumper
    implements MessageQueue.IdleHandler {
        private static final long MIN_VIEW_DUMP_INTERVAL_MILLIS = 1000L;
        private static @Nullable ViewHierarchyDumper sInstance;
        private long mLastDumpTs;

        private ViewHierarchyDumper() {
        }

        @Override
        public boolean queueIdle() {
            long now = TimeUtils.elapsedRealtimeMillis();
            if (this.mLastDumpTs == 0L || now - this.mLastDumpTs > 1000L) {
                this.mLastDumpTs = now;
                TraceEvent.snapshotViewHierarchy();
            }
            return true;
        }

        public static void updateEnabledState() {
            PostTask.runOrPostTask(7, () -> ViewHierarchyDumper.setEnabled(TraceEventJni.get().viewHierarchyDumpEnabled()));
        }

        private static void dumpView(ActivityInfo collection, int parentId, View v) {
            ThreadUtils.assertOnUiThread();
            int id2 = v.getId();
            collection.mViews.add(new ViewInfo(id2, parentId, v.isShown(), v.isDirty(), v.getClass().getSimpleName(), v.getResources()));
            if (v instanceof ViewGroup) {
                ViewGroup vg = (ViewGroup)v;
                for (int i = 0; i < vg.getChildCount(); ++i) {
                    ViewHierarchyDumper.dumpView(collection, id2, vg.getChildAt(i));
                }
            }
        }

        private static void setEnabled(boolean value) {
            ThreadUtils.assertOnUiThread();
            if (sInstance == null && value) {
                sInstance = new ViewHierarchyDumper();
                Looper.myQueue().addIdleHandler(sInstance);
            } else if (sInstance != null && !value) {
                Looper.myQueue().removeIdleHandler(sInstance);
                sInstance = null;
            }
        }
    }

    static interface Natives {
        public void registerEnabledObserver();

        public void instant(String var1, @Nullable String var2);

        public void begin(String var1, @Nullable String var2);

        public void beginWithIntArg(String var1, int var2);

        public void end(@Nullable String var1, long var2);

        public void beginToplevel(String var1);

        public void endToplevel();

        public void startAsync(String var1, long var2);

        public void finishAsync(long var1);

        public boolean viewHierarchyDumpEnabled();

        public void initViewHierarchyDump(long var1, Object var3);

        public long startActivityDump(String var1, long var2);

        public void addViewDump(int var1, int var2, boolean var3, boolean var4, String var5, String var6, long var7);

        public void instantAndroidIPC(String var1, long var2);

        public void instantAndroidToolbar(int var1, int var2, int var3);

        public void webViewStartupTotalFactoryInit(long var1, long var3);

        public void webViewStartupStage1(long var1, long var3);

        public void webViewStartupFirstInstance(long var1, long var3, boolean var5);

        public void webViewStartupNotFirstInstance(long var1, long var3);

        public void webViewStartupStartChromiumLocked(long var1, long var3, int var5, boolean var6);

        public void startupActivityStart(long var1, long var3);

        public void startupLaunchCause(long var1, long var3, int var5);

        public void startupTimeToFirstVisibleContent2(long var1, long var3, long var5);
    }

    public static class ActivityInfo {
        public String mActivityName;
        public ArrayList<ViewInfo> mViews;

        public ActivityInfo(String activityName) {
            this.mActivityName = activityName;
            this.mViews = new ArrayList(125);
        }
    }

    public static class ViewInfo {
        private int mId;
        private int mParentId;
        private boolean mIsShown;
        private boolean mIsDirty;
        private String mClassName;
        private Resources mRes;

        public ViewInfo(int id2, int parentId, boolean isShown, boolean isDirty, String className, Resources res) {
            this.mId = id2;
            this.mParentId = parentId;
            this.mIsShown = isShown;
            this.mIsDirty = isDirty;
            this.mClassName = className;
            this.mRes = res;
        }
    }

    private static class IdleTracingLooperMonitor
    extends BasicLooperMonitor
    implements MessageQueue.IdleHandler {
        private static final String TAG = "TraceEvt_LooperMonitor";
        private static final String IDLE_EVENT_NAME = "Looper.queueIdle";
        private static final long FRAME_DURATION_MILLIS = 16L;
        private static final long MIN_INTERESTING_DURATION_MILLIS = 16L;
        private static final long MIN_INTERESTING_BURST_DURATION_MILLIS = 48L;
        private long mLastIdleStartedAt;
        private long mLastWorkStartedAt;
        private int mNumTasksSeen;
        private int mNumIdlesSeen;
        private int mNumTasksSinceLastIdle;
        private boolean mIdleMonitorAttached;

        private IdleTracingLooperMonitor() {
        }

        private void syncIdleMonitoring() {
            if (sEnabled && !this.mIdleMonitorAttached) {
                this.mLastIdleStartedAt = TimeUtils.elapsedRealtimeMillis();
                Looper.myQueue().addIdleHandler(this);
                this.mIdleMonitorAttached = true;
                Log.v(TAG, "attached idle handler");
            } else if (this.mIdleMonitorAttached && !sEnabled) {
                Looper.myQueue().removeIdleHandler(this);
                this.mIdleMonitorAttached = false;
                Log.v(TAG, "detached idle handler");
            }
        }

        @Override
        void beginHandling(String line) {
            if (this.mNumTasksSinceLastIdle == 0) {
                TraceEvent.end(IDLE_EVENT_NAME);
            }
            this.mLastWorkStartedAt = TimeUtils.elapsedRealtimeMillis();
            this.syncIdleMonitoring();
            super.beginHandling(line);
        }

        @Override
        void endHandling(String line) {
            long elapsed = TimeUtils.elapsedRealtimeMillis() - this.mLastWorkStartedAt;
            if (elapsed > 16L) {
                IdleTracingLooperMonitor.traceAndLog(5, "observed a task that took " + elapsed + "ms: " + line);
            }
            super.endHandling(line);
            this.syncIdleMonitoring();
            ++this.mNumTasksSeen;
            ++this.mNumTasksSinceLastIdle;
        }

        private static void traceAndLog(int level, String message) {
            TraceEvent.instant("TraceEvent.LooperMonitor:IdleStats", message);
            Log.println(level, TAG, message);
        }

        @Override
        public boolean queueIdle() {
            long now = TimeUtils.elapsedRealtimeMillis();
            if (this.mLastIdleStartedAt == 0L) {
                this.mLastIdleStartedAt = now;
            }
            long elapsed = now - this.mLastIdleStartedAt;
            ++this.mNumIdlesSeen;
            TraceEvent.begin(IDLE_EVENT_NAME, this.mNumTasksSinceLastIdle + " tasks since last idle.");
            if (elapsed > 48L) {
                String statsString = this.mNumTasksSeen + " tasks and " + this.mNumIdlesSeen + " idles processed so far, " + this.mNumTasksSinceLastIdle + " tasks bursted and " + elapsed + "ms elapsed since last idle";
                IdleTracingLooperMonitor.traceAndLog(3, statsString);
            }
            this.mLastIdleStartedAt = now;
            this.mNumTasksSinceLastIdle = 0;
            return true;
        }
    }
}

