/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.SharedPreferences;
import android.net.connectivity.javax.annotation.concurrent.GuardedBy;
import android.net.connectivity.org.chromium.base.ActivityLifecycleCallbacksAdapter;
import android.net.connectivity.org.chromium.base.ApplicationStatusJni;
import android.net.connectivity.org.chromium.base.ContextUtils;
import android.net.connectivity.org.chromium.base.ObserverList;
import android.net.connectivity.org.chromium.base.StrictModeContext;
import android.net.connectivity.org.chromium.base.ThreadUtils;
import android.net.connectivity.org.chromium.build.NullUtil;
import android.net.connectivity.org.chromium.build.annotations.NullMarked;
import android.net.connectivity.org.chromium.build.annotations.Nullable;
import android.net.connectivity.org.jni_zero.CalledByNative;
import android.net.connectivity.org.jni_zero.JNINamespace;
import android.view.Window;
import com.android.layoutlib.androidx.annotation.AnyThread;
import com.android.layoutlib.androidx.annotation.MainThread;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@JNINamespace(value="base::android")
@NullMarked
public class ApplicationStatus {
    private static final String TOOLBAR_CALLBACK_WRAPPER_CLASS = "com.android.layoutlib.androidx.appcompat.app.ToolbarActionBar$ToolbarCallbackWrapper";
    private static final Map<Activity, ActivityInfo> sActivityInfo = Collections.synchronizedMap(new HashMap());
    public static final Map<Activity, Integer> sActivityTaskId = Collections.synchronizedMap(new HashMap());
    private static final String CACHE_ACTIVITY_TASKID_KEY = "cache_activity_taskid_enabled";
    @SuppressLint(value={"SupportAnnotationUsage"})
    @GuardedBy(value="sActivityInfo")
    private static int sCurrentApplicationState = 0;
    @SuppressLint(value={"StaticFieldLeak"})
    private static @Nullable Activity sActivity;
    private static @Nullable ApplicationStateListener sNativeApplicationStateListener;
    private static @Nullable ObserverList<ActivityStateListener> sGeneralActivityStateListeners;
    private static @Nullable ObserverList<ApplicationStateListener> sApplicationStateListeners;
    private static @Nullable ObserverList<WindowFocusChangedListener> sWindowFocusListeners;
    private static @Nullable ObserverList<TaskVisibilityListener> sTaskVisibilityListeners;

    private ApplicationStatus() {
    }

    @MainThread
    public static void registerWindowFocusChangedListener(WindowFocusChangedListener listener) {
        assert (ApplicationStatus.isInitialized());
        if (sWindowFocusListeners == null) {
            sWindowFocusListeners = new ObserverList();
        }
        sWindowFocusListeners.addObserver(listener);
    }

    @MainThread
    public static void unregisterWindowFocusChangedListener(WindowFocusChangedListener listener) {
        if (sWindowFocusListeners == null) {
            return;
        }
        sWindowFocusListeners.removeObserver(listener);
    }

    @MainThread
    public static void registerTaskVisibilityListener(TaskVisibilityListener listener) {
        assert (ApplicationStatus.isInitialized());
        if (sTaskVisibilityListeners == null) {
            sTaskVisibilityListeners = new ObserverList();
        }
        sTaskVisibilityListeners.addObserver(listener);
    }

    @MainThread
    public static void unregisterTaskVisibilityListener(TaskVisibilityListener listener) {
        if (sTaskVisibilityListeners == null) {
            return;
        }
        sTaskVisibilityListeners.removeObserver(listener);
    }

    public static void setCachingEnabled(boolean enabled) {
        SharedPreferences.Editor editor = ContextUtils.getAppSharedPreferences().edit();
        editor.putBoolean(CACHE_ACTIVITY_TASKID_KEY, enabled).apply();
    }

    public static boolean isCachingEnabled() {
        try (StrictModeContext ignored = StrictModeContext.allowDiskReads();){
            boolean bl = ContextUtils.getAppSharedPreferences().getBoolean(CACHE_ACTIVITY_TASKID_KEY, false);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTaskId(Activity activity) {
        if (!ApplicationStatus.isCachingEnabled()) {
            return activity.getTaskId();
        }
        if (!sActivityTaskId.containsKey(activity)) {
            Map<Activity, Integer> map = sActivityTaskId;
            synchronized (map) {
                sActivityTaskId.put(activity, activity.getTaskId());
            }
        }
        return sActivityTaskId.get(activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInitialized() {
        Map<Activity, ActivityInfo> map = sActivityInfo;
        synchronized (map) {
            return sCurrentApplicationState != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public static void initialize(Application application) {
        assert (!ApplicationStatus.isInitialized());
        Map<Activity, ActivityInfo> map = sActivityInfo;
        synchronized (map) {
            sCurrentApplicationState = 4;
        }
        ApplicationStatus.registerWindowFocusChangedListener(new WindowFocusChangedListener(){

            @Override
            public void onWindowFocusChanged(Activity activity, boolean hasFocus) {
                if (!hasFocus || activity == sActivity) {
                    return;
                }
                int state = ApplicationStatus.getStateForActivity(activity);
                if (state != 6 && state != 5) {
                    sActivity = activity;
                }
            }
        });
        application.registerActivityLifecycleCallbacks(new ActivityLifecycleCallbacksAdapter(){

            @Override
            public void onStateChanged(Activity activity, int newState) {
                if (newState == 1) {
                    Window.Callback callback = activity.getWindow().getCallback();
                    activity.getWindow().setCallback(ApplicationStatus.createWindowCallbackProxy(activity, callback));
                } else assert (ApplicationStatus.reachesWindowCallback(activity.getWindow().getCallback()));
                ApplicationStatus.onStateChange(activity, newState);
            }
        });
    }

    @VisibleForTesting
    static Window.Callback createWindowCallbackProxy(Activity activity, Window.Callback callback) {
        return (Window.Callback)Proxy.newProxyInstance(Window.Callback.class.getClassLoader(), new Class[]{Window.Callback.class}, (InvocationHandler)new WindowCallbackProxy(activity, callback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static boolean reachesWindowCallback( @Nullable Window.Callback callback) {
        if (callback == null) {
            return false;
        }
        if (callback.getClass().getName().equals(TOOLBAR_CALLBACK_WRAPPER_CLASS)) {
            return true;
        }
        if (Proxy.isProxyClass(callback.getClass())) {
            return Proxy.getInvocationHandler(callback) instanceof WindowCallbackProxy;
        }
        for (Class<?> c = callback.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                Window.Callback fieldCb;
                if (!f.getType().isAssignableFrom(Window.Callback.class)) continue;
                boolean isAccessible = f.isAccessible();
                f.setAccessible(true);
                try {
                    fieldCb = (Window.Callback)f.get(callback);
                }
                catch (IllegalAccessException ex) {
                    continue;
                }
                finally {
                    f.setAccessible(isAccessible);
                }
                if (!ApplicationStatus.reachesWindowCallback(fieldCb)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onStateChange(Activity activity, int newState) {
        int n;
        boolean taskVisibility;
        ActivityInfo info;
        if (sActivity == null || newState == 1 || newState == 3 || newState == 2) {
            sActivity = activity;
        }
        int oldApplicationState = ApplicationStatus.getStateForApplication();
        boolean oldTaskVisibility = ApplicationStatus.isTaskVisible(ApplicationStatus.getTaskId(activity));
        Iterator<ActivityStateListener> iterator = sActivityInfo;
        synchronized (iterator) {
            if (newState == 1) {
                assert (!sActivityInfo.containsKey(activity));
                sActivityInfo.put(activity, new ActivityInfo());
            }
            info = NullUtil.assumeNonNull(sActivityInfo.get(activity));
            info.setStatus(newState);
            if (newState == 6) {
                sActivityInfo.remove(activity);
                if (activity == sActivity) {
                    sActivity = null;
                }
            }
            sCurrentApplicationState = ApplicationStatus.determineApplicationStateLocked();
        }
        for (ActivityStateListener activityStateListener : info.getListeners()) {
            activityStateListener.onActivityStateChange(activity, newState);
        }
        if (sGeneralActivityStateListeners != null) {
            for (ActivityStateListener activityStateListener : sGeneralActivityStateListeners) {
                activityStateListener.onActivityStateChange(activity, newState);
            }
        }
        if ((taskVisibility = ApplicationStatus.isTaskVisible(ApplicationStatus.getTaskId(activity))) != oldTaskVisibility && sTaskVisibilityListeners != null) {
            for (TaskVisibilityListener listener : sTaskVisibilityListeners) {
                listener.onTaskVisibilityChanged(ApplicationStatus.getTaskId(activity), taskVisibility);
            }
        }
        if ((n = ApplicationStatus.getStateForApplication()) != oldApplicationState && sApplicationStateListeners != null) {
            for (ApplicationStateListener listener : sApplicationStateListeners) {
                listener.onApplicationStateChange(n);
            }
        }
        Map<Activity, Integer> map = sActivityTaskId;
        synchronized (map) {
            if (newState == 6) {
                sActivityTaskId.remove(activity);
            }
        }
    }

    @VisibleForTesting
    @MainThread
    public static void onStateChangeForTesting(Activity activity, int newState) {
        ApplicationStatus.onStateChange(activity, newState);
    }

    @MainThread
    public static @Nullable Activity getLastTrackedFocusedActivity() {
        return sActivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public static List<Activity> getRunningActivities() {
        assert (ApplicationStatus.isInitialized());
        Map<Activity, ActivityInfo> map = sActivityInfo;
        synchronized (map) {
            return new ArrayList<Activity>(sActivityInfo.keySet());
        }
    }

    @AnyThread
    public static int getStateForActivity(@Nullable Activity activity) {
        assert (ApplicationStatus.isInitialized());
        if (activity == null) {
            return 6;
        }
        ActivityInfo info = sActivityInfo.get(activity);
        return info != null ? info.getStatus() : 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    @CalledByNative
    public static int getStateForApplication() {
        Map<Activity, ActivityInfo> map = sActivityInfo;
        synchronized (map) {
            return sCurrentApplicationState;
        }
    }

    @AnyThread
    @CalledByNative
    public static boolean hasVisibleActivities() {
        assert (ApplicationStatus.isInitialized());
        int state = ApplicationStatus.getStateForApplication();
        return state == 1 || state == 2;
    }

    @AnyThread
    public static boolean isEveryActivityDestroyed() {
        assert (ApplicationStatus.isInitialized());
        return sActivityInfo.isEmpty();
    }

    @AnyThread
    public static boolean isTaskVisible(int taskId) {
        assert (ApplicationStatus.isInitialized());
        for (Map.Entry<Activity, ActivityInfo> entry : sActivityInfo.entrySet()) {
            int state;
            if (ApplicationStatus.getTaskId(entry.getKey()) != taskId || (state = entry.getValue().getStatus()) != 3 && state != 4) continue;
            return true;
        }
        return false;
    }

    public static boolean cleanupInvalidTask(int taskId) {
        ArrayList<Activity> inaccessibleActivities = new ArrayList<Activity>();
        for (Map.Entry<Activity, Integer> activityTaskInfo : sActivityTaskId.entrySet()) {
            if (taskId != activityTaskInfo.getValue()) continue;
            inaccessibleActivities.add(activityTaskInfo.getKey());
        }
        for (Activity activity : inaccessibleActivities) {
            ApplicationStatus.onStateChange(activity, 6);
        }
        return !inaccessibleActivities.isEmpty();
    }

    @MainThread
    public static void registerStateListenerForAllActivities(ActivityStateListener listener) {
        assert (ApplicationStatus.isInitialized());
        if (sGeneralActivityStateListeners == null) {
            sGeneralActivityStateListeners = new ObserverList();
        }
        sGeneralActivityStateListeners.addObserver(listener);
    }

    @MainThread
    @SuppressLint(value={"NewApi"})
    public static void registerStateListenerForActivity(ActivityStateListener listener, Activity activity) {
        assert (ApplicationStatus.isInitialized());
        assert (activity != null);
        ActivityInfo info = sActivityInfo.get(activity);
        assert (info != null) : String.format("Found untracked Activity: %s isDestroyed=%s isFinishing=%s", activity, activity.isDestroyed(), activity.isFinishing());
        assert (info.getStatus() != 6) : activity.toString();
        info.getListeners().addObserver(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public static void unregisterActivityStateListener(ActivityStateListener listener) {
        if (sGeneralActivityStateListeners != null) {
            sGeneralActivityStateListeners.removeObserver(listener);
        }
        Map<Activity, ActivityInfo> map = sActivityInfo;
        synchronized (map) {
            for (ActivityInfo info : sActivityInfo.values()) {
                info.getListeners().removeObserver(listener);
            }
        }
    }

    @MainThread
    public static void registerApplicationStateListener(ApplicationStateListener listener) {
        if (sApplicationStateListeners == null) {
            sApplicationStateListeners = new ObserverList();
        }
        sApplicationStateListeners.addObserver(listener);
    }

    @MainThread
    public static void unregisterApplicationStateListener(ApplicationStateListener listener) {
        if (sApplicationStateListeners == null) {
            return;
        }
        sApplicationStateListeners.removeObserver(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public static void destroyForJUnitTests() {
        Map<Activity, ActivityInfo> map = sActivityInfo;
        synchronized (map) {
            if (sApplicationStateListeners != null) {
                sApplicationStateListeners.clear();
            }
            if (sGeneralActivityStateListeners != null) {
                sGeneralActivityStateListeners.clear();
            }
            if (sTaskVisibilityListeners != null) {
                sTaskVisibilityListeners.clear();
            }
            sActivityInfo.clear();
            sActivityTaskId.clear();
            if (sWindowFocusListeners != null) {
                sWindowFocusListeners.clear();
            }
            sCurrentApplicationState = 0;
            sActivity = null;
            sNativeApplicationStateListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public static void resetActivitiesForInstrumentationTests() {
        assert (ThreadUtils.runningOnUiThread());
        Map<Activity, ActivityInfo> map = sActivityInfo;
        synchronized (map) {
            for (Activity activity : new HashSet<Activity>(sActivityInfo.keySet())) {
                assert (activity.getApplication() == null) : "Real activities that are launched should be closed by test code and not rely on this cleanup of mocks.";
                ApplicationStatus.onStateChangeForTesting(activity, 6);
            }
        }
    }

    @CalledByNative
    private static void registerThreadSafeNativeApplicationStateListener() {
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (sNativeApplicationStateListener != null) {
                    return;
                }
                sNativeApplicationStateListener = new ApplicationStateListener(this){

                    @Override
                    public void onApplicationStateChange(int newState) {
                        ApplicationStatusJni.get().onApplicationStateChange(newState);
                    }
                };
                ApplicationStatus.registerApplicationStateListener(sNativeApplicationStateListener);
            }
        });
    }

    @GuardedBy(value="sActivityInfo")
    private static int determineApplicationStateLocked() {
        boolean hasPausedActivity = false;
        boolean hasStoppedActivity = false;
        for (ActivityInfo info : sActivityInfo.values()) {
            int state = info.getStatus();
            if (state != 4 && state != 5 && state != 6) {
                return 1;
            }
            if (state == 4) {
                hasPausedActivity = true;
                continue;
            }
            if (state != 5) continue;
            hasStoppedActivity = true;
        }
        if (hasPausedActivity) {
            return 2;
        }
        if (hasStoppedActivity) {
            return 3;
        }
        return 4;
    }

    public static int getApplicationStateListenerCountForTesting() {
        return sApplicationStateListeners == null ? 0 : sApplicationStateListeners.size();
    }

    public static interface WindowFocusChangedListener {
        public void onWindowFocusChanged(Activity var1, boolean var2);
    }

    @VisibleForTesting
    static class WindowCallbackProxy
    implements InvocationHandler {
        private final Window.Callback mCallback;
        private final Activity mActivity;

        public WindowCallbackProxy(Activity activity, Window.Callback callback) {
            this.mCallback = callback;
            this.mActivity = activity;
        }

        @Override
        public @Nullable Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("onWindowFocusChanged") && args.length == 1 && args[0] instanceof Boolean) {
                this.onWindowFocusChanged((Boolean)args[0]);
                return null;
            }
            try {
                return method.invoke((Object)this.mCallback, args);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof AbstractMethodError) {
                    throw e.getCause();
                }
                throw e;
            }
        }

        public void onWindowFocusChanged(boolean hasFocus) {
            this.mCallback.onWindowFocusChanged(hasFocus);
            if (sWindowFocusListeners != null) {
                for (WindowFocusChangedListener listener : sWindowFocusListeners) {
                    listener.onWindowFocusChanged(this.mActivity, hasFocus);
                }
            }
        }
    }

    private static class ActivityInfo {
        private int mStatus = 6;
        private ObserverList<ActivityStateListener> mListeners = new ObserverList();

        private ActivityInfo() {
        }

        public int getStatus() {
            return this.mStatus;
        }

        public void setStatus(int status) {
            this.mStatus = status;
        }

        public ObserverList<ActivityStateListener> getListeners() {
            return this.mListeners;
        }
    }

    public static interface ActivityStateListener {
        public void onActivityStateChange(Activity var1, int var2);
    }

    public static interface TaskVisibilityListener {
        public void onTaskVisibilityChanged(int var1, boolean var2);
    }

    public static interface ApplicationStateListener {
        public void onApplicationStateChange(int var1);
    }

    static interface Natives {
        public void onApplicationStateChange(int var1);
    }
}

