/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.connectivity.org.chromium.base.ApkInfoJni;
import android.net.connectivity.org.chromium.base.CommandLine;
import android.net.connectivity.org.chromium.base.ContextUtils;
import android.net.connectivity.org.chromium.base.PackageUtils;
import android.net.connectivity.org.chromium.base.version_info.VersionInfo;
import android.net.connectivity.org.chromium.build.BuildConfig;
import android.net.connectivity.org.chromium.build.NullUtil;
import android.net.connectivity.org.chromium.build.annotations.NullMarked;
import android.net.connectivity.org.chromium.build.annotations.Nullable;
import android.net.connectivity.org.jni_zero.CalledByNative;
import android.net.connectivity.org.jni_zero.JNINamespace;
import android.os.Process;

@JNINamespace(value="base::android::apk_info")
@NullMarked
public class ApkInfo {
    private static final String TAG = "ApkInfo";
    private static boolean sInitialized;
    private static @Nullable PackageInfo sBrowserPackageInfo;
    private final ApplicationInfo mBrowserApplicationInfo;
    private final String mHostPackageName;
    private final String mHostPackageLabel;
    private final long mHostVersionCode;
    private final String mVersionName;
    private final String mInstallerPackageName;
    private final String mPackageName;
    private final String mResourcesVersion;
    private static volatile @Nullable ApkInfo sInstance;
    private static final Object CREATION_LOCK;

    @CalledByNative
    private static void nativeReadyForFields() {
        ApkInfo instance = ApkInfo.getInstance();
        ApkInfoJni.get().fillFields(instance.mHostPackageName, String.valueOf(instance.mHostVersionCode), instance.mHostPackageLabel, String.valueOf(BuildConfig.VERSION_CODE), instance.mVersionName, instance.mPackageName, instance.mResourcesVersion, instance.mInstallerPackageName, ApkInfo.isDebugApp(), ApkInfo.targetsAtLeastU(), ContextUtils.getApplicationContext().getApplicationInfo().targetSdkVersion);
    }

    public static String getHostPackageName() {
        return ApkInfo.getInstance().mHostPackageName;
    }

    public static long getHostVersionCode() {
        return ApkInfo.getInstance().mHostVersionCode;
    }

    public static String getHostPackageLabel() {
        return ApkInfo.getInstance().mHostPackageLabel;
    }

    public static String getPackageName() {
        return ApkInfo.getInstance().mPackageName;
    }

    public static String getPackageVersionCode() {
        return String.valueOf(BuildConfig.VERSION_CODE);
    }

    public static String getPackageVersionName() {
        return ApkInfo.getInstance().mVersionName;
    }

    public static String getInstallerPackageName() {
        return ApkInfo.getInstance().mInstallerPackageName;
    }

    public static String getResourcesVersion() {
        return ApkInfo.getInstance().mResourcesVersion;
    }

    public static boolean targetsAtLeastU() {
        int target = ContextUtils.getApplicationContext().getApplicationInfo().targetSdkVersion;
        return target >= 34;
    }

    public static boolean targetAtLeastB() {
        int target = ContextUtils.getApplicationContext().getApplicationInfo().targetSdkVersion;
        return target >= 36;
    }

    public static boolean isInitializedForTesting() {
        return sInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApkInfo getInstance() {
        if (BuildConfig.IS_FOR_TEST) {
            return new ApkInfo();
        }
        if (sInstance == null) {
            Object object = CREATION_LOCK;
            synchronized (object) {
                if (sInstance == null) {
                    sInstance = new ApkInfo();
                }
            }
        }
        return sInstance;
    }

    public ApplicationInfo getBrowserApplicationInfo() {
        return this.mBrowserApplicationInfo;
    }

    public static void setBrowserPackageInfo(PackageInfo packageInfo) {
        assert (!sInitialized);
        sBrowserPackageInfo = packageInfo;
    }

    private static String nullToEmpty(@Nullable CharSequence seq) {
        return seq == null ? "" : seq.toString();
    }

    private ApkInfo() {
        sInitialized = true;
        Context appContext = ContextUtils.getApplicationContext();
        String appContextPackageName = appContext.getPackageName();
        PackageManager pm = appContext.getPackageManager();
        String providedHostPackageName = null;
        String providedHostPackageLabel = null;
        String providedPackageName = null;
        String providedPackageVersionName = null;
        Long providedHostVersionCode = null;
        if (CommandLine.isInitialized()) {
            CommandLine commandLine = CommandLine.getInstance();
            providedHostPackageName = commandLine.getSwitchValue("host-package-name");
            providedHostPackageLabel = commandLine.getSwitchValue("host-package-label");
            providedPackageName = commandLine.getSwitchValue("package-name");
            providedPackageVersionName = commandLine.getSwitchValue("package-version-name");
            String flagValue = commandLine.getSwitchValue("host-version-code");
            if (flagValue != null) {
                providedHostVersionCode = Long.parseLong(flagValue);
            }
        }
        boolean hostInformationProvided = providedHostPackageName != null && providedHostPackageLabel != null && providedHostVersionCode != null && providedPackageName != null && providedPackageVersionName != null;
        String appInstalledPackageName = appContextPackageName;
        ApplicationInfo appInfo = appContext.getApplicationInfo();
        if (hostInformationProvided) {
            this.mHostPackageName = NullUtil.assumeNonNull(providedHostPackageName);
            this.mHostPackageLabel = NullUtil.assumeNonNull(providedHostPackageLabel);
            this.mHostVersionCode = NullUtil.assumeNonNull(providedHostVersionCode);
            this.mVersionName = NullUtil.assumeNonNull(providedPackageVersionName);
            this.mPackageName = NullUtil.assumeNonNull(providedPackageName);
        } else {
            int hostId;
            String[] packageNames;
            String sdkQualifiedName = appInstalledPackageName;
            if (ContextUtils.isSdkSandboxProcess() && (packageNames = pm.getPackagesForUid(hostId = Process.myUid() - 10000)) != null && packageNames.length > 0) {
                appInstalledPackageName = packageNames[0];
                sdkQualifiedName = sdkQualifiedName + ":" + appInstalledPackageName;
            }
            this.mHostPackageName = sdkQualifiedName;
            this.mHostPackageLabel = ApkInfo.nullToEmpty(pm.getApplicationLabel(appInfo));
            if (sBrowserPackageInfo != null) {
                PackageInfo pi = NullUtil.assumeNonNull(PackageUtils.getPackageInfo(appInstalledPackageName, 0));
                this.mHostVersionCode = PackageUtils.packageVersionCode(pi);
                this.mPackageName = ApkInfo.sBrowserPackageInfo.packageName;
                this.mVersionName = ApkInfo.nullToEmpty(ApkInfo.sBrowserPackageInfo.versionName);
                appInfo = ApkInfo.sBrowserPackageInfo.applicationInfo;
                sBrowserPackageInfo = null;
            } else {
                this.mPackageName = appContextPackageName;
                this.mHostVersionCode = BuildConfig.VERSION_CODE;
                this.mVersionName = VersionInfo.getProductVersion();
            }
        }
        assert (appInfo != null);
        this.mBrowserApplicationInfo = appInfo;
        this.mInstallerPackageName = ApkInfo.nullToEmpty(pm.getInstallerPackageName(appInstalledPackageName));
        String currentResourcesVersion = "Not Enabled";
        if (BuildConfig.R_STRING_PRODUCT_VERSION != 0) {
            try {
                currentResourcesVersion = ContextUtils.getApplicationContext().getString(BuildConfig.R_STRING_PRODUCT_VERSION);
            }
            catch (Exception e) {
                currentResourcesVersion = "Not found";
            }
        }
        this.mResourcesVersion = currentResourcesVersion;
    }

    public static boolean isDebugApp() {
        int appFlags = ContextUtils.getApplicationContext().getApplicationInfo().flags;
        return (appFlags & 2) != 0;
    }

    static {
        CREATION_LOCK = new Object();
    }

    static interface Natives {
        public void fillFields(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, boolean var9, boolean var10, int var11);
    }
}

