/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.com.android.net.module.util;

import android.annotation.NonNull;
import android.net.NetworkCapabilities;
import android.net.connectivity.com.android.net.module.util.BitUtils;
import android.net.connectivity.com.android.net.module.util.CollectionUtils;
import com.android.internal.annotations.VisibleForTesting;

public class NetworkCapabilitiesUtils {
    public static final int TYPE_TEST = 18;
    private static final int[] DISPLAY_TRANSPORT_PRIORITIES = new int[]{4, 0, 5, 2, 1, 3, 8, 10};
    @VisibleForTesting
    public static final long RESTRICTED_CAPABILITIES = 12490639292L;
    private static final long FORCE_RESTRICTED_CAPABILITIES = 0x24400000L;
    @VisibleForTesting
    public static final long UNRESTRICTED_CAPABILITIES = 4163L;

    public static int getDisplayTransport(@NonNull int[] transports) {
        for (int transport : DISPLAY_TRANSPORT_PRIORITIES) {
            if (!CollectionUtils.contains(transports, transport)) continue;
            return transport;
        }
        if (transports.length < 1) {
            throw new IllegalArgumentException("No transport in the provided array");
        }
        return transports[0];
    }

    public static int deduceTransportTypeForLegacyNetworkType(int legacyNetworkType) {
        int n;
        switch (legacyNetworkType) {
            case 1: {
                n = 1;
                break;
            }
            case 0: {
                n = 0;
                break;
            }
            case 9: {
                n = 3;
                break;
            }
            case 17: {
                n = 4;
                break;
            }
            case 7: 
            case 16: {
                n = 2;
                break;
            }
            case 18: {
                n = 7;
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    public static boolean inferRestrictedCapability(NetworkCapabilities nc) {
        return NetworkCapabilitiesUtils.inferRestrictedCapability(BitUtils.packBits(nc.getCapabilities()));
    }

    public static boolean inferRestrictedCapability(long capabilities) {
        if ((capabilities & 0x24400000L) != 0L) {
            return true;
        }
        if ((capabilities & 0x1043L) != 0L) {
            return false;
        }
        return (capabilities & 0x2E88007BCL) != 0L;
    }
}

