/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.com.android.net.module.util;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.util.LruCache;
import com.android.internal.annotations.GuardedBy;
import java.util.Objects;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class LruCacheWithExpiry<K, V> {
    private final LongSupplier mTimeSupplier;
    private final long mExpiryDurationMs;
    @GuardedBy(value={"mMap"})
    private final LruCache<K, CacheValue<V>> mMap;
    private final Predicate<V> mShouldCacheValue;

    public LruCacheWithExpiry(@NonNull LongSupplier timeSupplier, long expiryDurationMs, int maxSize, Predicate<V> shouldCacheValue) {
        this.mTimeSupplier = timeSupplier;
        this.mExpiryDurationMs = expiryDurationMs;
        this.mMap = new LruCache(maxSize);
        this.mShouldCacheValue = shouldCacheValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public V get(@NonNull K key) {
        LruCache<K, CacheValue<V>> lruCache = this.mMap;
        synchronized (lruCache) {
            CacheValue<V> value = this.mMap.get(key);
            if (value != null && !this.isExpired(value.timestamp)) {
                return value.entry;
            }
            this.mMap.remove(key);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public V getOrCompute(@NonNull K key, @NonNull Supplier<V> supplier) {
        LruCache<K, CacheValue<V>> lruCache = this.mMap;
        synchronized (lruCache) {
            V cachedValue = this.get(key);
            if (cachedValue != null) {
                return cachedValue;
            }
            V computedValue = supplier.get();
            if (computedValue != null && this.mShouldCacheValue.test(computedValue)) {
                this.put(key, computedValue);
            }
            return computedValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(@NonNull K key, @NonNull V value) {
        Objects.requireNonNull(value);
        LruCache<K, CacheValue<V>> lruCache = this.mMap;
        synchronized (lruCache) {
            this.mMap.put(key, new CacheValue<V>(this.mTimeSupplier.getAsLong(), value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public V putIfAbsent(@NonNull K key, @NonNull V value) {
        Objects.requireNonNull(value);
        LruCache<K, CacheValue<V>> lruCache = this.mMap;
        synchronized (lruCache) {
            V existingValue = this.get(key);
            if (existingValue == null) {
                this.put(key, value);
            }
            return existingValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LruCache<K, CacheValue<V>> lruCache = this.mMap;
        synchronized (lruCache) {
            this.mMap.evictAll();
        }
    }

    private boolean isExpired(long timestamp) {
        return this.mTimeSupplier.getAsLong() > timestamp + this.mExpiryDurationMs;
    }

    private static class CacheValue<V> {
        public final long timestamp;
        @NonNull
        public final V entry;

        CacheValue(long timestamp, V entry) {
            this.timestamp = timestamp;
            this.entry = entry;
        }
    }
}

