/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.android.net.thread;

import android.net.connectivity.android.net.thread.ChannelMaxPower;
import android.net.connectivity.android.net.thread.IActiveOperationalDatasetReceiver;
import android.net.connectivity.android.net.thread.IConfigurationReceiver;
import android.net.connectivity.android.net.thread.IOperationReceiver;
import android.net.connectivity.android.net.thread.IOperationalDatasetCallback;
import android.net.connectivity.android.net.thread.IStateCallback;
import android.net.thread.ActiveOperationalDataset;
import android.net.thread.PendingOperationalDataset;
import android.net.thread.ThreadConfiguration;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IThreadNetworkController
extends IInterface {
    public static final String DESCRIPTOR = "android.net.connectivity.android.net.thread.IThreadNetworkController";

    public void registerStateCallback(IStateCallback var1) throws RemoteException;

    public void unregisterStateCallback(IStateCallback var1) throws RemoteException;

    public void registerOperationalDatasetCallback(IOperationalDatasetCallback var1) throws RemoteException;

    public void unregisterOperationalDatasetCallback(IOperationalDatasetCallback var1) throws RemoteException;

    public void join(ActiveOperationalDataset var1, IOperationReceiver var2) throws RemoteException;

    public void scheduleMigration(PendingOperationalDataset var1, IOperationReceiver var2) throws RemoteException;

    public void leave(IOperationReceiver var1) throws RemoteException;

    public void setTestNetworkAsUpstream(String var1, IOperationReceiver var2) throws RemoteException;

    public void setChannelMaxPowers(ChannelMaxPower[] var1, IOperationReceiver var2) throws RemoteException;

    public int getThreadVersion() throws RemoteException;

    public void createRandomizedDataset(String var1, IActiveOperationalDatasetReceiver var2) throws RemoteException;

    public void setEnabled(boolean var1, IOperationReceiver var2) throws RemoteException;

    public void setConfiguration(ThreadConfiguration var1, IOperationReceiver var2) throws RemoteException;

    public void registerConfigurationCallback(IConfigurationReceiver var1) throws RemoteException;

    public void unregisterConfigurationCallback(IConfigurationReceiver var1) throws RemoteException;

    public void activateEphemeralKeyMode(long var1, IOperationReceiver var3) throws RemoteException;

    public void deactivateEphemeralKeyMode(IOperationReceiver var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IThreadNetworkController {
        static final int TRANSACTION_registerStateCallback = 1;
        static final int TRANSACTION_unregisterStateCallback = 2;
        static final int TRANSACTION_registerOperationalDatasetCallback = 3;
        static final int TRANSACTION_unregisterOperationalDatasetCallback = 4;
        static final int TRANSACTION_join = 5;
        static final int TRANSACTION_scheduleMigration = 6;
        static final int TRANSACTION_leave = 7;
        static final int TRANSACTION_setTestNetworkAsUpstream = 8;
        static final int TRANSACTION_setChannelMaxPowers = 9;
        static final int TRANSACTION_getThreadVersion = 10;
        static final int TRANSACTION_createRandomizedDataset = 11;
        static final int TRANSACTION_setEnabled = 12;
        static final int TRANSACTION_setConfiguration = 13;
        static final int TRANSACTION_registerConfigurationCallback = 14;
        static final int TRANSACTION_unregisterConfigurationCallback = 15;
        static final int TRANSACTION_activateEphemeralKeyMode = 16;
        static final int TRANSACTION_deactivateEphemeralKeyMode = 17;

        public Stub() {
            this.attachInterface(this, IThreadNetworkController.DESCRIPTOR);
        }

        public static IThreadNetworkController asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IThreadNetworkController.DESCRIPTOR);
            if (iin != null && iin instanceof IThreadNetworkController) {
                return (IThreadNetworkController)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "registerStateCallback";
                }
                case 2: {
                    return "unregisterStateCallback";
                }
                case 3: {
                    return "registerOperationalDatasetCallback";
                }
                case 4: {
                    return "unregisterOperationalDatasetCallback";
                }
                case 5: {
                    return "join";
                }
                case 6: {
                    return "scheduleMigration";
                }
                case 7: {
                    return "leave";
                }
                case 8: {
                    return "setTestNetworkAsUpstream";
                }
                case 9: {
                    return "setChannelMaxPowers";
                }
                case 10: {
                    return "getThreadVersion";
                }
                case 11: {
                    return "createRandomizedDataset";
                }
                case 12: {
                    return "setEnabled";
                }
                case 13: {
                    return "setConfiguration";
                }
                case 14: {
                    return "registerConfigurationCallback";
                }
                case 15: {
                    return "unregisterConfigurationCallback";
                }
                case 16: {
                    return "activateEphemeralKeyMode";
                }
                case 17: {
                    return "deactivateEphemeralKeyMode";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IThreadNetworkController.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IStateCallback _arg0 = IStateCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerStateCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    IStateCallback _arg0 = IStateCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterStateCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    IOperationalDatasetCallback _arg0 = IOperationalDatasetCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerOperationalDatasetCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    IOperationalDatasetCallback _arg0 = IOperationalDatasetCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterOperationalDatasetCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    ActiveOperationalDataset _arg0 = data.readTypedObject(ActiveOperationalDataset.CREATOR);
                    IOperationReceiver _arg1 = IOperationReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.join(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    PendingOperationalDataset _arg0 = data.readTypedObject(PendingOperationalDataset.CREATOR);
                    IOperationReceiver _arg1 = IOperationReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.scheduleMigration(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    IOperationReceiver _arg0 = IOperationReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.leave(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    IOperationReceiver _arg1 = IOperationReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setTestNetworkAsUpstream(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    ChannelMaxPower[] _arg0 = data.createTypedArray(ChannelMaxPower.CREATOR);
                    IOperationReceiver _arg1 = IOperationReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setChannelMaxPowers(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    int _result = this.getThreadVersion();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    IActiveOperationalDatasetReceiver _arg1 = IActiveOperationalDatasetReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.createRandomizedDataset(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    boolean _arg0 = data.readBoolean();
                    IOperationReceiver _arg1 = IOperationReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    ThreadConfiguration _arg0 = data.readTypedObject(ThreadConfiguration.CREATOR);
                    IOperationReceiver _arg1 = IOperationReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    IConfigurationReceiver _arg0 = IConfigurationReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerConfigurationCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    IConfigurationReceiver _arg0 = IConfigurationReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterConfigurationCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    long _arg0 = data.readLong();
                    IOperationReceiver _arg1 = IOperationReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.activateEphemeralKeyMode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    IOperationReceiver _arg0 = IOperationReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.deactivateEphemeralKeyMode(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 16;
        }

        private static class Proxy
        implements IThreadNetworkController {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IThreadNetworkController.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerStateCallback(IStateCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IThreadNetworkController.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterStateCallback(IStateCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IThreadNetworkController.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerOperationalDatasetCallback(IOperationalDatasetCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IThreadNetworkController.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterOperationalDatasetCallback(IOperationalDatasetCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IThreadNetworkController.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void join(ActiveOperationalDataset activeOpDataset, IOperationReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IThreadNetworkController.DESCRIPTOR);
                    _data.writeTypedObject(activeOpDataset, 0);
                    _data.writeStrongInterface(receiver);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void scheduleMigration(PendingOperationalDataset pendingOpDataset, IOperationReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IThreadNetworkController.DESCRIPTOR);
                    _data.writeTypedObject(pendingOpDataset, 0);
                    _data.writeStrongInterface(receiver);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void leave(IOperationReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IThreadNetworkController.DESCRIPTOR);
                    _data.writeStrongInterface(receiver);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTestNetworkAsUpstream(String testNetworkInterfaceName, IOperationReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IThreadNetworkController.DESCRIPTOR);
                    _data.writeString(testNetworkInterfaceName);
                    _data.writeStrongInterface(receiver);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setChannelMaxPowers(ChannelMaxPower[] channelMaxPowers, IOperationReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IThreadNetworkController.DESCRIPTOR);
                    _data.writeTypedArray(channelMaxPowers, 0);
                    _data.writeStrongInterface(receiver);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getThreadVersion() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IThreadNetworkController.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createRandomizedDataset(String networkName, IActiveOperationalDatasetReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IThreadNetworkController.DESCRIPTOR);
                    _data.writeString(networkName);
                    _data.writeStrongInterface(receiver);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setEnabled(boolean enabled, IOperationReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IThreadNetworkController.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    _data.writeStrongInterface(receiver);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setConfiguration(ThreadConfiguration config, IOperationReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IThreadNetworkController.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    _data.writeStrongInterface(receiver);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerConfigurationCallback(IConfigurationReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IThreadNetworkController.DESCRIPTOR);
                    _data.writeStrongInterface(receiver);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterConfigurationCallback(IConfigurationReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IThreadNetworkController.DESCRIPTOR);
                    _data.writeStrongInterface(receiver);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void activateEphemeralKeyMode(long lifetimeMillis, IOperationReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IThreadNetworkController.DESCRIPTOR);
                    _data.writeLong(lifetimeMillis);
                    _data.writeStrongInterface(receiver);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deactivateEphemeralKeyMode(IOperationReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IThreadNetworkController.DESCRIPTOR);
                    _data.writeStrongInterface(receiver);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IThreadNetworkController {
        @Override
        public void registerStateCallback(IStateCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterStateCallback(IStateCallback callback) throws RemoteException {
        }

        @Override
        public void registerOperationalDatasetCallback(IOperationalDatasetCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterOperationalDatasetCallback(IOperationalDatasetCallback callback) throws RemoteException {
        }

        @Override
        public void join(ActiveOperationalDataset activeOpDataset, IOperationReceiver receiver) throws RemoteException {
        }

        @Override
        public void scheduleMigration(PendingOperationalDataset pendingOpDataset, IOperationReceiver receiver) throws RemoteException {
        }

        @Override
        public void leave(IOperationReceiver receiver) throws RemoteException {
        }

        @Override
        public void setTestNetworkAsUpstream(String testNetworkInterfaceName, IOperationReceiver receiver) throws RemoteException {
        }

        @Override
        public void setChannelMaxPowers(ChannelMaxPower[] channelMaxPowers, IOperationReceiver receiver) throws RemoteException {
        }

        @Override
        public int getThreadVersion() throws RemoteException {
            return 0;
        }

        @Override
        public void createRandomizedDataset(String networkName, IActiveOperationalDatasetReceiver receiver) throws RemoteException {
        }

        @Override
        public void setEnabled(boolean enabled, IOperationReceiver receiver) throws RemoteException {
        }

        @Override
        public void setConfiguration(ThreadConfiguration config, IOperationReceiver receiver) throws RemoteException {
        }

        @Override
        public void registerConfigurationCallback(IConfigurationReceiver receiver) throws RemoteException {
        }

        @Override
        public void unregisterConfigurationCallback(IConfigurationReceiver receiver) throws RemoteException {
        }

        @Override
        public void activateEphemeralKeyMode(long lifetimeMillis, IOperationReceiver receiver) throws RemoteException {
        }

        @Override
        public void deactivateEphemeralKeyMode(IOperationReceiver receiver) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

