/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.android.net;

import android.net.QosSession;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.data.EpsBearerQosSessionAttributes;
import android.telephony.data.NrQosSessionAttributes;

public interface IQosCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.connectivity.android.net.IQosCallback";

    public void onQosEpsBearerSessionAvailable(QosSession var1, EpsBearerQosSessionAttributes var2) throws RemoteException;

    public void onNrQosSessionAvailable(QosSession var1, NrQosSessionAttributes var2) throws RemoteException;

    public void onQosSessionLost(QosSession var1) throws RemoteException;

    public void onError(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IQosCallback {
        static final int TRANSACTION_onQosEpsBearerSessionAvailable = 1;
        static final int TRANSACTION_onNrQosSessionAvailable = 2;
        static final int TRANSACTION_onQosSessionLost = 3;
        static final int TRANSACTION_onError = 4;

        public Stub() {
            this.attachInterface(this, IQosCallback.DESCRIPTOR);
        }

        public static IQosCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IQosCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IQosCallback) {
                return (IQosCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onQosEpsBearerSessionAvailable";
                }
                case 2: {
                    return "onNrQosSessionAvailable";
                }
                case 3: {
                    return "onQosSessionLost";
                }
                case 4: {
                    return "onError";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IQosCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    QosSession _arg0 = data.readTypedObject(QosSession.CREATOR);
                    EpsBearerQosSessionAttributes _arg1 = data.readTypedObject(EpsBearerQosSessionAttributes.CREATOR);
                    this.onQosEpsBearerSessionAvailable(_arg0, _arg1);
                    break;
                }
                case 2: {
                    QosSession _arg0 = data.readTypedObject(QosSession.CREATOR);
                    NrQosSessionAttributes _arg1 = data.readTypedObject(NrQosSessionAttributes.CREATOR);
                    this.onNrQosSessionAvailable(_arg0, _arg1);
                    break;
                }
                case 3: {
                    QosSession _arg0 = data.readTypedObject(QosSession.CREATOR);
                    this.onQosSessionLost(_arg0);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    this.onError(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements IQosCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IQosCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onQosEpsBearerSessionAvailable(QosSession session, EpsBearerQosSessionAttributes attributes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IQosCallback.DESCRIPTOR);
                    _data.writeTypedObject(session, 0);
                    _data.writeTypedObject(attributes, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNrQosSessionAvailable(QosSession session, NrQosSessionAttributes attributes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IQosCallback.DESCRIPTOR);
                    _data.writeTypedObject(session, 0);
                    _data.writeTypedObject(attributes, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onQosSessionLost(QosSession session) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IQosCallback.DESCRIPTOR);
                    _data.writeTypedObject(session, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(int type) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IQosCallback.DESCRIPTOR);
                    _data.writeInt(type);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IQosCallback {
        @Override
        public void onQosEpsBearerSessionAvailable(QosSession session, EpsBearerQosSessionAttributes attributes) throws RemoteException {
        }

        @Override
        public void onNrQosSessionAvailable(QosSession session, NrQosSessionAttributes attributes) throws RemoteException {
        }

        @Override
        public void onQosSessionLost(QosSession session) throws RemoteException {
        }

        @Override
        public void onError(int type) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

