/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.Network;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.system.OsConstants;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Objects;

@SystemApi
public class QosSocketInfo
implements Parcelable {
    @NonNull
    private final Network mNetwork;
    @NonNull
    private final ParcelFileDescriptor mParcelFileDescriptor;
    @NonNull
    private final InetSocketAddress mLocalSocketAddress;
    @Nullable
    private final InetSocketAddress mRemoteSocketAddress;
    private final int mSocketType;
    @NonNull
    public static final Parcelable.Creator<QosSocketInfo> CREATOR = new Parcelable.Creator<QosSocketInfo>(){

        @Override
        @NonNull
        public QosSocketInfo createFromParcel(Parcel in) {
            return new QosSocketInfo(in);
        }

        @NonNull
        public QosSocketInfo[] newArray(int size) {
            return new QosSocketInfo[size];
        }
    };

    @NonNull
    public Network getNetwork() {
        return this.mNetwork;
    }

    @NonNull
    public ParcelFileDescriptor getParcelFileDescriptor() {
        return this.mParcelFileDescriptor;
    }

    @NonNull
    public InetSocketAddress getLocalSocketAddress() {
        return this.mLocalSocketAddress;
    }

    @Nullable
    public InetSocketAddress getRemoteSocketAddress() {
        return this.mRemoteSocketAddress;
    }

    public int getSocketType() {
        return this.mSocketType;
    }

    public QosSocketInfo(@NonNull Network network, @NonNull Socket socket) throws IOException {
        Objects.requireNonNull(socket, "socket cannot be null");
        this.mNetwork = Objects.requireNonNull(network, "network cannot be null");
        this.mParcelFileDescriptor = ParcelFileDescriptor.fromSocket(socket);
        this.mLocalSocketAddress = new InetSocketAddress(socket.getLocalAddress(), socket.getLocalPort());
        this.mSocketType = OsConstants.SOCK_STREAM;
        this.mRemoteSocketAddress = socket.isConnected() ? (InetSocketAddress)socket.getRemoteSocketAddress() : null;
    }

    public QosSocketInfo(@NonNull Network network, @NonNull DatagramSocket socket) throws IOException {
        Objects.requireNonNull(socket, "socket cannot be null");
        this.mNetwork = Objects.requireNonNull(network, "network cannot be null");
        this.mParcelFileDescriptor = ParcelFileDescriptor.fromDatagramSocket(socket);
        this.mLocalSocketAddress = new InetSocketAddress(socket.getLocalAddress(), socket.getLocalPort());
        this.mSocketType = OsConstants.SOCK_DGRAM;
        this.mRemoteSocketAddress = socket.isConnected() ? (InetSocketAddress)socket.getRemoteSocketAddress() : null;
    }

    private QosSocketInfo(Parcel in) {
        this.mNetwork = Objects.requireNonNull(Network.CREATOR.createFromParcel(in));
        boolean withFd = in.readBoolean();
        this.mParcelFileDescriptor = withFd ? ParcelFileDescriptor.CREATOR.createFromParcel(in) : null;
        this.mLocalSocketAddress = this.readSocketAddress(in);
        this.mRemoteSocketAddress = this.readSocketAddress(in);
        this.mSocketType = in.readInt();
    }

    private InetSocketAddress readSocketAddress(Parcel in) {
        byte[] addrBytes = in.createByteArray();
        if (addrBytes == null) {
            return null;
        }
        int port = in.readInt();
        try {
            return new InetSocketAddress(InetAddress.getByAddress(addrBytes), port);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("UnknownHostException on numeric address", e);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        this.writeToParcelInternal(dest, flags, true);
    }

    public void writeToParcelWithoutFd(@NonNull Parcel dest, int flags) {
        this.writeToParcelInternal(dest, flags, false);
    }

    private void writeToParcelInternal(@NonNull Parcel dest, int flags, boolean includeFd) {
        this.mNetwork.writeToParcel(dest, 0);
        if (includeFd) {
            dest.writeBoolean(true);
            this.mParcelFileDescriptor.writeToParcel(dest, 0);
        } else {
            dest.writeBoolean(false);
        }
        dest.writeByteArray(this.mLocalSocketAddress.getAddress().getAddress());
        dest.writeInt(this.mLocalSocketAddress.getPort());
        if (this.mRemoteSocketAddress == null) {
            dest.writeByteArray(null);
        } else {
            dest.writeByteArray(this.mRemoteSocketAddress.getAddress().getAddress());
            dest.writeInt(this.mRemoteSocketAddress.getPort());
        }
        dest.writeInt(this.mSocketType);
    }
}

