/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.app.SystemServiceRegistry;
import android.net.ConnectivityDiagnosticsManager;
import android.net.ConnectivityManager;
import android.net.IConnectivityManager;
import android.net.TestNetworkManager;
import android.net.connectivity.android.net.DnsResolverServiceManager;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class ConnectivityFrameworkInitializer {
    private ConnectivityFrameworkInitializer() {
    }

    public static void registerServiceWrappers() {
        SystemServiceRegistry.registerContextAwareService("connectivity", ConnectivityManager.class, (context, serviceBinder) -> {
            IConnectivityManager icm = IConnectivityManager.Stub.asInterface(serviceBinder);
            return new ConnectivityManager(context, icm);
        });
        SystemServiceRegistry.registerContextAwareService("connectivity_diagnostics", ConnectivityDiagnosticsManager.class, context -> {
            ConnectivityManager cm = context.getSystemService(ConnectivityManager.class);
            return cm.createDiagnosticsManager();
        });
        SystemServiceRegistry.registerContextAwareService("test_network", TestNetworkManager.class, context -> {
            ConnectivityManager cm = context.getSystemService(ConnectivityManager.class);
            return cm.startOrGetTestNetworkManager();
        });
        SystemServiceRegistry.registerContextAwareService("dnsresolver", DnsResolverServiceManager.class, (context, serviceBinder) -> new DnsResolverServiceManager(serviceBinder));
    }
}

