/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.nearby.ScanFilter;
import android.net.connectivity.com.android.internal.util.Preconditions;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.WorkSource;
import android.os._Original_Build;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@SystemApi
public class ScanRequest
implements Parcelable {
    public static final int SCAN_TYPE_FAST_PAIR = 1;
    public static final int SCAN_TYPE_NEARBY_PRESENCE = 2;
    public static final int SCAN_MODE_LOW_LATENCY = 2;
    public static final int SCAN_MODE_BALANCED = 1;
    public static final int SCAN_MODE_LOW_POWER = 0;
    public static final int SCAN_MODE_NO_POWER = -1;
    public static final int SCAN_MODE_CHRE_ONLY = 3;
    @NonNull
    public static final Parcelable.Creator<ScanRequest> CREATOR = new Parcelable.Creator<ScanRequest>(){

        @Override
        public ScanRequest createFromParcel(Parcel in) {
            Builder builder = new Builder().setScanType(in.readInt()).setScanMode(in.readInt()).setBleEnabled(in.readBoolean()).setOffloadOnly(in.readBoolean()).setWorkSource(in.readTypedObject(WorkSource.CREATOR));
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                builder.addScanFilter(ScanFilter.createFromParcel(in));
            }
            return builder.build();
        }

        public ScanRequest[] newArray(int size) {
            return new ScanRequest[size];
        }
    };
    private final int mScanType;
    private final int mScanMode;
    private final boolean mBleEnabled;
    private final boolean mOffloadOnly;
    @NonNull
    private final WorkSource mWorkSource;
    private final List<ScanFilter> mScanFilters;

    private ScanRequest(int scanType, int scanMode, boolean bleEnabled, boolean offloadOnly, @NonNull WorkSource workSource, List<ScanFilter> scanFilters) {
        this.mScanType = scanType;
        this.mScanMode = scanMode;
        this.mBleEnabled = bleEnabled;
        this.mOffloadOnly = offloadOnly;
        this.mWorkSource = workSource;
        this.mScanFilters = scanFilters;
    }

    @NonNull
    public static String scanModeToString(int scanMode) {
        switch (scanMode) {
            case 2: {
                return "SCAN_MODE_LOW_LATENCY";
            }
            case 1: {
                return "SCAN_MODE_BALANCED";
            }
            case 0: {
                return "SCAN_MODE_LOW_POWER";
            }
            case -1: {
                return "SCAN_MODE_NO_POWER";
            }
        }
        return "SCAN_MODE_INVALID";
    }

    public static boolean isValidScanType(int scanType) {
        return scanType == 1 || scanType == 2;
    }

    public static boolean isValidScanMode(int scanMode) {
        return scanMode == 2 || scanMode == 1 || scanMode == 0 || scanMode == -1;
    }

    public int getScanType() {
        return this.mScanType;
    }

    public int getScanMode() {
        return this.mScanMode;
    }

    public boolean isBleEnabled() {
        return this.mBleEnabled;
    }

    public boolean isOffloadOnly() {
        return this.mOffloadOnly;
    }

    @NonNull
    public List<ScanFilter> getScanFilters() {
        return this.mScanFilters;
    }

    @SystemApi
    @NonNull
    public WorkSource getWorkSource() {
        return this.mWorkSource;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append("scanType=").append(this.mScanType);
        stringBuilder.append(", scanMode=").append(ScanRequest.scanModeToString(this.mScanMode));
        if (_Original_Build.VERSION.SDK_INT >= 34) {
            stringBuilder.append(", bleEnabled=").append(this.mBleEnabled);
            stringBuilder.append(", offloadOnly=").append(this.mOffloadOnly);
        } else {
            stringBuilder.append(", enableBle=").append(this.mBleEnabled);
        }
        stringBuilder.append(", workSource=").append(this.mWorkSource);
        stringBuilder.append(", scanFilters=").append(this.mScanFilters);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mScanType);
        dest.writeInt(this.mScanMode);
        dest.writeBoolean(this.mBleEnabled);
        dest.writeBoolean(this.mOffloadOnly);
        dest.writeTypedObject(this.mWorkSource, 0);
        int size = this.mScanFilters.size();
        dest.writeInt(size);
        for (int i = 0; i < size; ++i) {
            this.mScanFilters.get(i).writeToParcel(dest, flags);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof ScanRequest) {
            ScanRequest otherRequest = (ScanRequest)other;
            return this.mScanType == otherRequest.mScanType && this.mScanMode == otherRequest.mScanMode && this.mBleEnabled == otherRequest.mBleEnabled && this.mOffloadOnly == otherRequest.mOffloadOnly && Objects.equals(this.mWorkSource, otherRequest.mWorkSource);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mScanType, this.mScanMode, this.mBleEnabled, this.mOffloadOnly, this.mWorkSource);
    }

    public static class Builder {
        private static final int INVALID_SCAN_TYPE = -1;
        private int mScanType = -1;
        private int mScanMode;
        private boolean mBleEnabled = true;
        private boolean mOffloadOnly = false;
        private WorkSource mWorkSource = new WorkSource();
        private List<ScanFilter> mScanFilters = new ArrayList<ScanFilter>();

        @NonNull
        public Builder setScanType(int scanType) {
            this.mScanType = scanType;
            return this;
        }

        @NonNull
        public Builder setScanMode(int scanMode) {
            this.mScanMode = scanMode;
            return this;
        }

        @NonNull
        public Builder setBleEnabled(boolean bleEnabled) {
            this.mBleEnabled = bleEnabled;
            return this;
        }

        @NonNull
        public Builder setOffloadOnly(boolean offloadOnly) {
            this.mOffloadOnly = offloadOnly;
            return this;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
        @NonNull
        public Builder setWorkSource(@Nullable WorkSource workSource) {
            this.mWorkSource = workSource == null ? new WorkSource() : workSource;
            return this;
        }

        @NonNull
        public Builder addScanFilter(@NonNull ScanFilter scanFilter) {
            Objects.requireNonNull(scanFilter);
            this.mScanFilters.add(scanFilter);
            return this;
        }

        @NonNull
        public ScanRequest build() {
            Preconditions.checkState(ScanRequest.isValidScanType(this.mScanType), "invalid scan type : " + this.mScanType + ", scan type must be one of ScanRequest#SCAN_TYPE_");
            Preconditions.checkState(ScanRequest.isValidScanMode(this.mScanMode), "invalid scan mode : " + this.mScanMode + ", scan mode must be one of ScanMode#SCAN_MODE_");
            return new ScanRequest(this.mScanType, this.mScanMode, this.mBleEnabled, this.mOffloadOnly, this.mWorkSource, this.mScanFilters);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScanMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScanType {
    }
}

