/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.media.tv.TvContentRating;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class TvRecordingInfo
implements Parcelable {
    public static final int RECORDING_SCHEDULED = 1;
    public static final int RECORDING_IN_PROGRESS = 2;
    public static final int RECORDING_ALL = 3;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 4;
    public static final int WEDNESDAY = 8;
    public static final int THURSDAY = 16;
    public static final int FRIDAY = 32;
    public static final int SATURDAY = 64;
    private String mRecordingId;
    private long mStartPaddingMillis;
    private long mEndPaddingMillis;
    private int mRepeatDays;
    private String mName;
    private String mDescription;
    private long mScheduledStartTimeMillis;
    private long mScheduledDurationMillis;
    private Uri mChannelUri;
    private Uri mProgramUri;
    private List<TvContentRating> mContentRatings;
    private Uri mRecordingUri;
    private long mRecordingStartTimeMillis;
    private long mRecordingDurationMillis;
    @NonNull
    public static final Parcelable.Creator<TvRecordingInfo> CREATOR = new Parcelable.Creator<TvRecordingInfo>(){

        @Override
        @NonNull
        public TvRecordingInfo createFromParcel(Parcel in) {
            return new TvRecordingInfo(in);
        }

        @NonNull
        public TvRecordingInfo[] newArray(int size) {
            return new TvRecordingInfo[size];
        }
    };

    public TvRecordingInfo(@NonNull String recordingId, long startPadding, long endPadding, int repeatDays, @NonNull String name, @NonNull String description, long scheduledStartTime, long scheduledDuration, @NonNull Uri channelUri, @Nullable Uri programUri, @NonNull List<TvContentRating> contentRatings, @Nullable Uri recordingUri, long recordingStartTime, long recordingDuration) {
        this.mRecordingId = recordingId;
        this.mStartPaddingMillis = startPadding;
        this.mEndPaddingMillis = endPadding;
        this.mRepeatDays = repeatDays;
        this.mName = name;
        this.mDescription = description;
        this.mScheduledStartTimeMillis = scheduledStartTime;
        this.mScheduledDurationMillis = scheduledDuration;
        this.mChannelUri = channelUri;
        this.mProgramUri = programUri;
        this.mContentRatings = contentRatings;
        this.mRecordingUri = recordingUri;
        this.mRecordingStartTimeMillis = recordingStartTime;
        this.mRecordingDurationMillis = recordingDuration;
    }

    @NonNull
    public String getRecordingId() {
        return this.mRecordingId;
    }

    public long getStartPaddingMillis() {
        return this.mStartPaddingMillis;
    }

    public long getEndPaddingMillis() {
        return this.mEndPaddingMillis;
    }

    public int getRepeatDays() {
        return this.mRepeatDays;
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    public void setName(@NonNull String name) {
        this.mName = name;
    }

    @NonNull
    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(@NonNull String description) {
        this.mDescription = description;
    }

    public long getScheduledStartTimeMillis() {
        return this.mScheduledStartTimeMillis;
    }

    public long getScheduledDurationMillis() {
        return this.mScheduledDurationMillis;
    }

    @NonNull
    public Uri getChannelUri() {
        return this.mChannelUri;
    }

    @Nullable
    public Uri getProgramUri() {
        return this.mProgramUri;
    }

    @NonNull
    public List<TvContentRating> getContentRatings() {
        return this.mContentRatings;
    }

    @Nullable
    public Uri getRecordingUri() {
        return this.mRecordingUri;
    }

    public long getRecordingStartTimeMillis() {
        return this.mRecordingStartTimeMillis;
    }

    public long getRecordingDurationMillis() {
        return this.mRecordingDurationMillis;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mRecordingId);
        dest.writeLong(this.mStartPaddingMillis);
        dest.writeLong(this.mEndPaddingMillis);
        dest.writeInt(this.mRepeatDays);
        dest.writeString(this.mName);
        dest.writeString(this.mDescription);
        dest.writeLong(this.mScheduledStartTimeMillis);
        dest.writeLong(this.mScheduledDurationMillis);
        dest.writeString(this.mChannelUri == null ? null : this.mChannelUri.toString());
        dest.writeString(this.mProgramUri == null ? null : this.mProgramUri.toString());
        ArrayList flattenedContentRatings = new ArrayList();
        this.mContentRatings.forEach(rating -> flattenedContentRatings.add(rating.flattenToString()));
        dest.writeList(this.mContentRatings);
        dest.writeString(this.mRecordingUri == null ? null : this.mProgramUri.toString());
        dest.writeLong(this.mRecordingDurationMillis);
        dest.writeLong(this.mRecordingStartTimeMillis);
    }

    private TvRecordingInfo(Parcel in) {
        this.mRecordingId = in.readString();
        this.mStartPaddingMillis = in.readLong();
        this.mEndPaddingMillis = in.readLong();
        this.mRepeatDays = in.readInt();
        this.mName = in.readString();
        this.mDescription = in.readString();
        this.mScheduledStartTimeMillis = in.readLong();
        this.mScheduledDurationMillis = in.readLong();
        this.mChannelUri = Uri.parse(in.readString());
        this.mProgramUri = Uri.parse(in.readString());
        this.mContentRatings = new ArrayList<TvContentRating>();
        ArrayList<String> flattenedContentRatings = new ArrayList<String>();
        in.readStringList(flattenedContentRatings);
        flattenedContentRatings.forEach(rating -> this.mContentRatings.add(TvContentRating.unflattenFromString(rating)));
        this.mRecordingUri = Uri.parse(in.readString());
        this.mRecordingDurationMillis = in.readLong();
        this.mRecordingStartTimeMillis = in.readLong();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DaysOfWeek {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TvRecordingListType {
    }
}

