/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.media.tv.BroadcastInfoResponse;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SharedMemory;

public class TableResponse
extends BroadcastInfoResponse
implements Parcelable {
    private static final int RESPONSE_TYPE = 2;
    @NonNull
    public static final Parcelable.Creator<TableResponse> CREATOR = new Parcelable.Creator<TableResponse>(){

        @Override
        public TableResponse createFromParcel(Parcel source) {
            source.readInt();
            return TableResponse.createFromParcelBody(source);
        }

        public TableResponse[] newArray(int size) {
            return new TableResponse[size];
        }
    };
    private final Uri mTableUri;
    private final int mVersion;
    private final int mSize;
    private final byte[] mTableByteArray;
    private final SharedMemory mTableSharedMemory;

    static TableResponse createFromParcelBody(Parcel in) {
        return new TableResponse(in);
    }

    @Deprecated
    public TableResponse(int requestId, int sequence, int responseResult, @Nullable Uri tableUri, int version, int size) {
        super(2, requestId, sequence, responseResult);
        this.mVersion = version;
        this.mSize = size;
        this.mTableUri = tableUri;
        this.mTableByteArray = null;
        this.mTableSharedMemory = null;
    }

    private TableResponse(int requestId, int sequence, int responseResult, int version, int size, Uri tableUri, byte[] tableByteArray, SharedMemory tableSharedMemory) {
        super(2, requestId, sequence, responseResult);
        this.mVersion = version;
        this.mSize = size;
        this.mTableUri = tableUri;
        this.mTableByteArray = tableByteArray;
        this.mTableSharedMemory = tableSharedMemory;
    }

    TableResponse(Parcel source) {
        super(2, source);
        String uriString = source.readString();
        this.mTableUri = uriString == null ? null : Uri.parse(uriString);
        this.mVersion = source.readInt();
        this.mSize = source.readInt();
        int arrayLength = source.readInt();
        if (arrayLength >= 0) {
            this.mTableByteArray = new byte[arrayLength];
            source.readByteArray(this.mTableByteArray);
        } else {
            this.mTableByteArray = null;
        }
        this.mTableSharedMemory = source.readTypedObject(SharedMemory.CREATOR);
    }

    @Nullable
    public Uri getTableUri() {
        return this.mTableUri;
    }

    @Nullable
    public byte[] getTableByteArray() {
        return this.mTableByteArray;
    }

    @Nullable
    public SharedMemory getTableSharedMemory() {
        return this.mTableSharedMemory;
    }

    public int getVersion() {
        return this.mVersion;
    }

    public int getSize() {
        return this.mSize;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        String uriString = this.mTableUri == null ? null : this.mTableUri.toString();
        dest.writeString(uriString);
        dest.writeInt(this.mVersion);
        dest.writeInt(this.mSize);
        if (this.mTableByteArray != null) {
            dest.writeInt(this.mTableByteArray.length);
            dest.writeByteArray(this.mTableByteArray);
        } else {
            dest.writeInt(-1);
        }
        dest.writeTypedObject(this.mTableSharedMemory, flags);
    }

    public static class Builder {
        private final int mRequestId;
        private final int mSequence;
        private final int mResponseResult;
        private final int mVersion;
        private final int mSize;
        private Uri mTableUri;
        private byte[] mTableByteArray;
        private SharedMemory mTableSharedMemory;

        public Builder(int requestId, int sequence, int responseResult, int version, int size) {
            this.mRequestId = requestId;
            this.mSequence = sequence;
            this.mResponseResult = responseResult;
            this.mVersion = version;
            this.mSize = size;
        }

        @NonNull
        public Builder setTableUri(@NonNull Uri uri) {
            this.mTableUri = uri;
            this.mTableByteArray = null;
            this.mTableSharedMemory = null;
            return this;
        }

        @NonNull
        public Builder setTableByteArray(@NonNull byte[] bytes) {
            this.mTableByteArray = bytes;
            this.mTableUri = null;
            this.mTableSharedMemory = null;
            return this;
        }

        @NonNull
        public Builder setTableSharedMemory(@NonNull SharedMemory sharedMemory) {
            this.mTableSharedMemory = sharedMemory;
            this.mTableUri = null;
            this.mTableByteArray = null;
            return this;
        }

        @NonNull
        public TableResponse build() {
            return new TableResponse(this.mRequestId, this.mSequence, this.mResponseResult, this.mVersion, this.mSize, this.mTableUri, this.mTableByteArray, this.mTableSharedMemory);
        }
    }
}

