/*
 * Decompiled with CFR 0.152.
 */
package android.media.quality;

import android.annotation.FlaggedApi;
import android.annotation.SystemApi;
import android.media.quality.PictureProfileHandle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.layoutlib.androidx.annotation.Nullable;
import com.android.layoutlib.androidx.annotation.RequiresPermission;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@FlaggedApi(value="android.media.tv.flags.media_quality_fw")
public class PictureProfile
implements Parcelable {
    @Nullable
    private String mId;
    private final int mType;
    @NonNull
    private final String mName;
    @Nullable
    private final String mInputId;
    @NonNull
    private final String mPackageName;
    @NonNull
    private final PersistableBundle mParams;
    private final PictureProfileHandle mHandle;
    public static final int TYPE_SYSTEM = 1;
    public static final int TYPE_APPLICATION = 2;
    public static final String NAME_DEFAULT = "default";
    public static final int ERROR_UNKNOWN = 0;
    public static final int ERROR_NO_PERMISSION = 1;
    public static final int ERROR_DUPLICATE = 2;
    public static final int ERROR_INVALID_ARGUMENT = 3;
    public static final int ERROR_NOT_ALLOWLISTED = 4;
    public static final String STATUS_SDR = "SDR";
    public static final String STATUS_HDR10 = "HDR10";
    public static final String STATUS_DOLBY_VISION = "DOLBY_VISION";
    public static final String STATUS_TCH = "TCH";
    public static final String STATUS_HLG = "HLG";
    public static final String STATUS_HDR10_PLUS = "HDR10_PLUS";
    public static final String STATUS_HDR_VIVID = "HDR_VIVID";
    public static final String STATUS_IMAX_SDR = "IMAX_SDR";
    public static final String STATUS_IMAX_HDR10 = "IMAX_HDR10";
    public static final String STATUS_IMAX_HDR10_PLUS = "IMAX_HDR10_PLUS";
    public static final String STATUS_FMM_SDR = "FMM_SDR";
    public static final String STATUS_FMM_HDR10 = "FMM_HDR10";
    public static final String STATUS_FMM_HDR10_PLUS = "FMM_HDR10_PLUS";
    public static final String STATUS_FMM_HLG = "FMM_HLG";
    public static final String STATUS_FMM_DOLBY = "FMM_DOLBY";
    public static final String STATUS_FMM_TCH = "FMM_TCH";
    public static final String STATUS_FMM_HDR_VIVID = "FMM_HDR_VIVID";
    public static final String NAME_STANDARD = "standard";
    public static final String NAME_VIVID = "vivid";
    public static final String NAME_SPORTS = "sports";
    public static final String NAME_GAME = "game";
    public static final String NAME_MOVIE = "movie";
    public static final String NAME_ENERGY_SAVING = "energy_saving";
    public static final String NAME_USER = "user";
    @NonNull
    public static final Parcelable.Creator<PictureProfile> CREATOR = new Parcelable.Creator<PictureProfile>(){

        @Override
        public PictureProfile createFromParcel(Parcel in) {
            return new PictureProfile(in);
        }

        public PictureProfile[] newArray(int size) {
            return new PictureProfile[size];
        }
    };

    private PictureProfile(@NonNull Parcel in) {
        this.mId = in.readString();
        this.mType = in.readInt();
        this.mName = in.readString();
        this.mInputId = in.readString();
        this.mPackageName = in.readString();
        this.mParams = in.readPersistableBundle();
        this.mHandle = (PictureProfileHandle)in.readParcelable(PictureProfileHandle.class.getClassLoader());
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mId);
        dest.writeInt(this.mType);
        dest.writeString(this.mName);
        dest.writeString(this.mInputId);
        dest.writeString(this.mPackageName);
        dest.writePersistableBundle(this.mParams);
        dest.writeParcelable(this.mHandle, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public PictureProfile(@Nullable String id2, int type, @NonNull String name, @Nullable String inputId, @NonNull String packageName, @NonNull PersistableBundle params, @NonNull PictureProfileHandle handle) {
        this.mId = id2;
        this.mType = type;
        this.mName = name;
        this.mInputId = inputId;
        this.mPackageName = packageName;
        this.mParams = params;
        this.mHandle = handle;
    }

    @Nullable
    public String getProfileId() {
        return this.mId;
    }

    public void setProfileId(String id2) {
        this.mId = id2;
    }

    public int getProfileType() {
        return this.mType;
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    @Nullable
    public String getInputId() {
        return this.mInputId;
    }

    @Nullable
    public String getPackageName() {
        return this.mPackageName;
    }

    @NonNull
    public PersistableBundle getParameters() {
        return new PersistableBundle(this.mParams);
    }

    @NonNull
    public PictureProfileHandle getHandle() {
        return this.mHandle;
    }

    public static class Builder {
        @Nullable
        private String mId;
        private int mType = 2;
        @NonNull
        private String mName;
        @Nullable
        private String mInputId;
        @NonNull
        private String mPackageName;
        @NonNull
        private PersistableBundle mParams;
        private PictureProfileHandle mHandle;

        public Builder(@NonNull String name) {
            this.mName = name;
        }

        public Builder(@NonNull PictureProfile p) {
            this.mId = null;
            this.mType = p.getProfileType();
            this.mName = p.getName();
            this.mPackageName = p.getPackageName();
            this.mInputId = p.getInputId();
            this.mParams = p.getParameters();
            this.mHandle = p.getHandle();
        }

        @NonNull
        public Builder setProfileId(@Nullable String id2) {
            this.mId = id2;
            return this;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.MANAGE_GLOBAL_PICTURE_QUALITY_SERVICE")
        @NonNull
        public Builder setProfileType(int value) {
            this.mType = value;
            return this;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.MANAGE_GLOBAL_PICTURE_QUALITY_SERVICE")
        @NonNull
        public Builder setInputId(@NonNull String value) {
            this.mInputId = value;
            return this;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.MANAGE_GLOBAL_PICTURE_QUALITY_SERVICE")
        @NonNull
        public Builder setPackageName(@NonNull String value) {
            this.mPackageName = value;
            return this;
        }

        @NonNull
        public Builder setParameters(@NonNull PersistableBundle params) {
            this.mParams = new PersistableBundle(params);
            return this;
        }

        @NonNull
        public Builder setHandle(@NonNull PictureProfileHandle handle) {
            this.mHandle = handle;
            return this;
        }

        @NonNull
        public PictureProfile build() {
            PictureProfile o = new PictureProfile(this.mId, this.mType, this.mName, this.mInputId, this.mPackageName, this.mParams, this.mHandle);
            return o;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ErrorCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProfileName {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProfileType {
    }
}

